/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.vmf.adapter.mpls.translation.asn.spec;

import com.huawei.network.qasn.m_q_ip_tunnel_model.QAsnRSVPTunnelInfo;
import com.huawei.vmf.adapter.common.exception.VMFException;
import com.huawei.vmf.adapter.framework.notify.IMOChangeRecord;
import com.huawei.vmf.adapter.framework.transaction.Context;
import com.huawei.vmf.adapter.framework.translation.asn.AbstractAsnSpecTranslator;
import com.huawei.vmf.adapter.framework.translation.asn.AsnTranslatorUtil;
import com.huawei.vmf.adapter.framework.translation.asn.IAsnTranslationContext;
import com.huawei.vmf.adapter.fservice.model.VmfMO;
import com.huawei.vmf.adapter.fservice.mpls.fdn.RsvpTeTunnelFdnParser;
import com.huawei.vmf.adapter.fservice.mpls.model.RsvpTeTunnel;
import com.huawei.vmf.adapter.fservice.mpls.model.RsvpTeTunnelAdv;
import com.huawei.vmf.adapter.fservice.mpls.model.RsvpTeTunnelPathConstraint;
import com.huawei.vmf.adapter.mpls.common.MplsUtil;
import com.huawei.vmf.adapter.mpls.translation.asn.QAsnRSVPTunnelInfoTranslator;

public class QAsnRSVPTunnelInfoSpecTranslator
extends AbstractAsnSpecTranslator<QAsnRSVPTunnelInfoTranslator> {
    public void decodeKeyProperties(QAsnRSVPTunnelInfo asn, RsvpTeTunnel mo, IAsnTranslationContext context) throws VMFException {
    }

    public void encodeKeyProperties(RsvpTeTunnel mo, QAsnRSVPTunnelInfo asn, IAsnTranslationContext context) throws VMFException {
    }

    public void postDecode(QAsnRSVPTunnelInfo asn, RsvpTeTunnel mo, IAsnTranslationContext context) {
        boolean isBypass;
        boolean isBackup;
        RsvpTeTunnelFdnParser fdnParser = new RsvpTeTunnelFdnParser();
        mo.setFdn(fdnParser.getFdn((VmfMO)mo));
        Context ctx = context.getTransactionContext();
        RsvpTeTunnelAdv adv = mo.getRsvpTeTunnelAdv();
        boolean frrEnable = this.parseBoolean(adv.getFrrEnable());
        boolean hotStandbyEnable = this.parseBoolean(adv.getHotStandbyEnable());
        boolean ordinaryEnable = this.parseBoolean(adv.getOrdinaryEnable());
        boolean bestEffortEnable = this.parseBoolean(adv.getBestEffortEnable());
        boolean bl = isBackup = hotStandbyEnable || ordinaryEnable;
        if (frrEnable) {
            adv.setMplsTunnelRecordRoute(AsnTranslatorUtil.integerValue((Integer)RsvpTeTunnelAdv.MPLS_TUNNEL_RECORD_ROUTE_ENUM.RECORD_LABLE, (String)"mplsTunnelRecordRoute", (Object[][])null, (VmfMO)adv, (IAsnTranslationContext)context));
            if (!this.parseBoolean(adv.getBwProtEnable())) {
                AsnTranslatorUtil.addModifyDbNull((Context)ctx, (VmfMO)adv, (String[])new String[]{"frrBandwidth", "frrSetupPriority", "frrHoldPriority"});
            }
        } else {
            AsnTranslatorUtil.addModifyDbNull((Context)ctx, (VmfMO)adv, (String[])new String[]{"bwProtEnable", "frrBandwidth", "frrSetupPriority", "frrHoldPriority"});
        }
        if (isBackup && this.isRecordDisable(mo)) {
            adv.setMplsTunnelRecordRoute(AsnTranslatorUtil.integerValue((Integer)RsvpTeTunnelAdv.MPLS_TUNNEL_RECORD_ROUTE_ENUM.RECORD_ROUTE_ONLY, (String)"mplsTunnelRecordRoute", (Object[][])null, (VmfMO)adv, (IAsnTranslationContext)context));
        }
        if ((isBypass = this.parseBoolean(mo.getRsvpTeTunnelAdv().getBypassEnable())) && this.isRecordDisable(mo)) {
            adv.setMplsTunnelRecordRoute(AsnTranslatorUtil.integerValue((Integer)RsvpTeTunnelAdv.MPLS_TUNNEL_RECORD_ROUTE_ENUM.RECORD_ROUTE_ONLY, (String)"mplsTunnelRecordRoute", (Object[][])null, (VmfMO)adv, (IAsnTranslationContext)context));
        }
        RsvpTeTunnelPathConstraint constraint = mo.getRsvpTeTunnelPathConstraint();
        if (ordinaryEnable || !bestEffortEnable) {
            MplsUtil.addModifyDbNull(mo, ctx, (VmfMO)constraint, "bestEffortExcludeAny", "bestEffortExplicitPathName", "bestEffortHopLimit", "bestEffortIncludeAll", "bestEffortIncludeAny", "bestEffortLspId");
        }
        if (this.isBackTypeChanged(ctx, adv)) {
            if (!hotStandbyEnable) {
                AsnTranslatorUtil.addModifyDbNull((Context)ctx, (VmfMO)constraint, (String[])new String[]{"hotStandbyExcludeAny", "hotStandbyExplicitPathName", "hotStandbyHopLimit", "hotStandbyIncludeAll", "hotStandbyIncludeAny", "hotStandbyLspId"});
            }
            if (!ordinaryEnable) {
                AsnTranslatorUtil.addModifyDbNull((Context)ctx, (VmfMO)constraint, (String[])new String[]{"ordinaryExcludeAny", "ordinaryExplicitPathName", "ordinaryHopLimit", "ordinaryIncludeAll", "ordinaryIncludeAny", "ordinaryLspId"});
            }
        }
        if (RsvpTeTunnelAdv.AUTO_BW_MODE_ENUM.DISABLE.equals(adv.getAutoBwMode())) {
            AsnTranslatorUtil.addModifyDbNull((Context)ctx, (VmfMO)adv, (String[])new String[]{"autoBwFreq", "autoBwMin", "autoBwMax"});
        }
    }

    private boolean isBackTypeChanged(Context ctx, RsvpTeTunnelAdv adv) {
        IMOChangeRecord advRecord = ctx.addChangeRecord(RsvpTeTunnelAdv.class);
        return advRecord.isModified((Object)adv, "hotStandbyEnable") || advRecord.isModified((Object)adv, "ordinaryEnable");
    }

    private boolean isRecordDisable(RsvpTeTunnel tunnel) {
        RsvpTeTunnelAdv adv = tunnel.getRsvpTeTunnelAdv();
        return adv.getMplsTunnelRecordRoute() == null || RsvpTeTunnelAdv.MPLS_TUNNEL_RECORD_ROUTE_ENUM.DISABLE.equals(adv.getMplsTunnelRecordRoute());
    }

    private boolean parseBoolean(Boolean b) {
        return null != b && b != false;
    }
}

