/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.vmf.adapter.mpls.translation.asn.spec;

import com.huawei.network.qasn.m_q_ip_tunnel_model.QAsnAffinityAttr;
import com.huawei.network.qasn.m_q_ip_tunnel_model.QAsnAffinityAttrList;
import com.huawei.network.qasn.m_q_ip_tunnel_model.QAsnExpathHop;
import com.huawei.network.qasn.m_q_ip_tunnel_model.QAsnHopLimitAttr;
import com.huawei.network.qasn.m_q_ip_tunnel_model.QAsnHopLimitAttrList;
import com.huawei.network.qasn.m_q_ip_tunnel_model.QAsnPathConstraintAttr;
import com.huawei.network.qasn.m_q_ip_tunnel_model.QAsnTunnelExPathAttr;
import com.huawei.network.qasn.m_q_ip_tunnel_model.QAsnTunnelExPathAttrList;
import com.huawei.network.qasn.m_q_ip_tunnel_model.QAsnTunnelExpathHopAttrList;
import com.huawei.vmf.adapter.common.exception.VMFException;
import com.huawei.vmf.adapter.common.utilty.AsnUtil;
import com.huawei.vmf.adapter.common.utilty.StringUtil;
import com.huawei.vmf.adapter.framework.notify.IMOChangeRecord;
import com.huawei.vmf.adapter.framework.notify.PropertyChangeItem;
import com.huawei.vmf.adapter.framework.transaction.Context;
import com.huawei.vmf.adapter.framework.translation.asn.AbstractAsnSpecTranslator;
import com.huawei.vmf.adapter.framework.translation.asn.AsnTranslatorUtil;
import com.huawei.vmf.adapter.framework.translation.asn.IAsnTranslationContext;
import com.huawei.vmf.adapter.framework.translation.asn.IAsnTranslator;
import com.huawei.vmf.adapter.fservice.model.EOperationType;
import com.huawei.vmf.adapter.fservice.model.VmfMO;
import com.huawei.vmf.adapter.fservice.mpls.model.ExplicitPath;
import com.huawei.vmf.adapter.fservice.mpls.model.ExplicitPathHop;
import com.huawei.vmf.adapter.fservice.mpls.model.RsvpTeTunnel;
import com.huawei.vmf.adapter.fservice.mpls.model.RsvpTeTunnelAdv;
import com.huawei.vmf.adapter.fservice.mpls.model.RsvpTeTunnelPathConstraint;
import com.huawei.vmf.adapter.mpls.common.MplsUtil;
import com.huawei.vmf.adapter.mpls.dao.MplsDao;
import com.huawei.vmf.adapter.mpls.translation.asn.QAsnExpathHopTranslator;
import com.huawei.vmf.adapter.mpls.translation.asn.QAsnPathConstraintAttrTranslator;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import net.commustru.fstru.FStruct;
import org.apache.commons.lang.ArrayUtils;
import org.apache.commons.lang.StringUtils;
import org.springframework.util.CollectionUtils;

public class QAsnPathConstraintAttrSpecTranslator
extends AbstractAsnSpecTranslator<QAsnPathConstraintAttrTranslator> {
    private static final int DEFAULT_HOP_LIMIT = 32;
    private static final String DEFAULT_TUNNEL_PATH_VALUE = "0";
    private IAsnTranslator<QAsnExpathHop, ExplicitPathHop> qasnExpathHopTranslator = new QAsnExpathHopTranslator();

    public void decodeAffinityAttr(QAsnAffinityAttr affinityAttr, RsvpTeTunnel mo, IAsnTranslationContext context) throws VMFException {
        RsvpTeTunnelAdv adv = mo.getRsvpTeTunnelAdv();
        Context ctx = context.getTransactionContext();
        if (AsnTranslatorUtil.isUnmodified((IAsnTranslationContext)context, (Integer)affinityAttr.poOperMask) && (affinityAttr.iType == 1 || affinityAttr.iType == 3 || !this.isBackTypeChanged(ctx, adv))) {
            return;
        }
        RsvpTeTunnelPathConstraint constraint = this.getRsvpTeTunnelPathConstraint(mo);
        if (ArrayUtils.isEmpty((byte[])affinityAttr.strValue) || ArrayUtils.isEmpty((byte[])affinityAttr.strMask)) {
            return;
        }
        String includeAny = Long.toHexString(AsnUtil.parseLong((byte[])affinityAttr.strValue) & AsnUtil.parseLong((byte[])affinityAttr.strMask));
        String excludeAny = Long.toHexString((AsnUtil.parseLong((byte[])affinityAttr.strValue) ^ 0xFFFFFFFFFFFFFFFFL) & AsnUtil.parseLong((byte[])affinityAttr.strMask));
        switch (affinityAttr.iType) {
            case 1: {
                constraint.setPrimaryIncludeAny(AsnTranslatorUtil.strValue((String)includeAny, (String)"primaryIncludeAny", (Object[][])null, (Object)constraint, (IAsnTranslationContext)context));
                constraint.setPrimaryExcludeAny(AsnTranslatorUtil.strValue((String)excludeAny, (String)"primaryExcludeAny", (Object[][])null, (Object)constraint, (IAsnTranslationContext)context));
                break;
            }
            case 2: {
                Boolean hotStandbyEnable = adv.getHotStandbyEnable();
                Boolean ordinaryEnable = adv.getOrdinaryEnable();
                if (Boolean.TRUE.equals(hotStandbyEnable)) {
                    constraint.setHotStandbyIncludeAny(AsnTranslatorUtil.strValue((String)includeAny, (String)"hotStandbyIncludeAny", (Object[][])null, (Object)constraint, (IAsnTranslationContext)context));
                    constraint.setHotStandbyExcludeAny(AsnTranslatorUtil.strValue((String)excludeAny, (String)"hotStandbyExcludeAny", (Object[][])null, (Object)constraint, (IAsnTranslationContext)context));
                    AsnTranslatorUtil.addModifyDbNull((Context)ctx, (VmfMO)constraint, (String[])new String[]{"ordinaryIncludeAny", "ordinaryExcludeAny"});
                    break;
                }
                if (Boolean.TRUE.equals(ordinaryEnable)) {
                    constraint.setOrdinaryIncludeAny(AsnTranslatorUtil.strValue((String)includeAny, (String)"ordinaryIncludeAny", (Object[][])null, (Object)constraint, (IAsnTranslationContext)context));
                    constraint.setOrdinaryExcludeAny(AsnTranslatorUtil.strValue((String)excludeAny, (String)"ordinaryExcludeAny", (Object[][])null, (Object)constraint, (IAsnTranslationContext)context));
                    AsnTranslatorUtil.addModifyDbNull((Context)ctx, (VmfMO)constraint, (String[])new String[]{"hotStandbyIncludeAny", "hotStandbyExcludeAny"});
                    break;
                }
                AsnTranslatorUtil.addModifyDbNull((Context)ctx, (VmfMO)constraint, (String[])new String[]{"ordinaryIncludeAny", "ordinaryExcludeAny", "hotStandbyIncludeAny", "hotStandbyExcludeAny"});
                break;
            }
            case 3: {
                if (Boolean.TRUE.equals(adv.getBestEffortEnable())) {
                    constraint.setBestEffortIncludeAny(AsnTranslatorUtil.strValue((String)includeAny, (String)"bestEffortIncludeAny", (Object[][])null, (Object)constraint, (IAsnTranslationContext)context));
                    constraint.setBestEffortExcludeAny(AsnTranslatorUtil.strValue((String)excludeAny, (String)"bestEffortExcludeAny", (Object[][])null, (Object)constraint, (IAsnTranslationContext)context));
                    break;
                }
                AsnTranslatorUtil.addModifyDbNull((Context)ctx, (VmfMO)constraint, (String[])new String[]{"bestEffortIncludeAny", "bestEffortExcludeAny"});
                break;
            }
            default: {
                this.getLogger().info("QAsnAffinityAttr.iType is invalidate, iType=" + affinityAttr.iType);
            }
        }
    }

    public void decodeKeyProperties(QAsnPathConstraintAttr asn, RsvpTeTunnel mo, IAsnTranslationContext context) throws VMFException {
    }

    public void decodeKeyRefMoExplicitPath(QAsnPathConstraintAttr asn, RsvpTeTunnel mo, IAsnTranslationContext context) throws VMFException {
    }

    public void decodeLstAffinityAttr(QAsnPathConstraintAttr asn, RsvpTeTunnel mo, IAsnTranslationContext context) throws VMFException {
        if (CollectionUtils.isEmpty((Collection)asn.lstAffinityAttr)) {
            return;
        }
        for (Object object : asn.lstAffinityAttr) {
            if (null == object) continue;
            QAsnAffinityAttr affinityAttr = (QAsnAffinityAttr)object;
            this.decodeAffinityAttr(affinityAttr, mo, context);
        }
    }

    public void decodeLstHopLimitAttr(QAsnPathConstraintAttr asn, RsvpTeTunnel mo, IAsnTranslationContext context) throws VMFException {
        if (CollectionUtils.isEmpty((Collection)asn.lstHopLimitAttr)) {
            return;
        }
        for (Object object : asn.lstHopLimitAttr) {
            if (null == object) continue;
            QAsnHopLimitAttr qasnHopLimitAttr = (QAsnHopLimitAttr)object;
            this.decodeHopLimitAttr(qasnHopLimitAttr, mo, context);
        }
    }

    public void decodeLstTunnelExPathAttr(QAsnPathConstraintAttr asn, RsvpTeTunnel mo, IAsnTranslationContext context) throws VMFException {
        if (CollectionUtils.isEmpty((Collection)asn.lstTunnelExPathAttr)) {
            return;
        }
        for (Object object : asn.lstTunnelExPathAttr) {
            if (null == object) continue;
            QAsnTunnelExPathAttr qasnTunnelExPathAttr = (QAsnTunnelExPathAttr)object;
            if (ArrayUtils.isEmpty((byte[])qasnTunnelExPathAttr.strName)) continue;
            this.decodeTunnelExPathAttr(qasnTunnelExPathAttr, mo, context);
        }
    }

    public void decodeQAsnPathConstraintAttrSpecKeys(QAsnPathConstraintAttr asn, RsvpTeTunnel mo, IAsnTranslationContext context) throws VMFException {
    }

    public void decodeTunnelExPathAttr(QAsnTunnelExPathAttr qasnTunnelExPathAttr, RsvpTeTunnel mo, IAsnTranslationContext context) throws VMFException {
        boolean isChanged;
        RsvpTeTunnelPathConstraint constraint = this.getRsvpTeTunnelPathConstraint(mo);
        Context ctx = context.getTransactionContext();
        IMOChangeRecord record = ctx.addChangeRecord(RsvpTeTunnelPathConstraint.class);
        String pathName = AsnUtil.strValue((byte[])qasnTunnelExPathAttr.strName);
        EOperationType operType = context.getOperType();
        if (EOperationType.GET.equals((Object)operType)) {
            if (1 == qasnTunnelExPathAttr.iType) {
                constraint.setPrimaryExplicitPathName(pathName);
            } else if (2 == qasnTunnelExPathAttr.iType) {
                constraint.setHotStandbyExplicitPathName(pathName);
                constraint.setOrdinaryExplicitPathName(pathName);
            }
            return;
        }
        Integer operMask = qasnTunnelExPathAttr.poOperMask;
        boolean isDelete = AsnTranslatorUtil.isMaskChanged((Integer)operMask, (int)2);
        boolean isModify = AsnTranslatorUtil.isMaskChanged((Integer)operMask, (int)8);
        boolean isCreate = AsnTranslatorUtil.isMaskChanged((Integer)operMask, (int)1);
        boolean bl = isChanged = isDelete || isModify || isCreate;
        if (isDelete) {
            pathName = null;
        }
        switch (qasnTunnelExPathAttr.iType) {
            case 1: {
                constraint.setPrimaryExplicitPathName(pathName);
                this.setChange((IMOChangeRecord<RsvpTeTunnelPathConstraint>)record, constraint, "primaryExplicitPathName", isChanged);
                break;
            }
            case 2: {
                RsvpTeTunnelAdv adv = mo.getRsvpTeTunnelAdv();
                boolean secondChanged = isChanged || this.isBackTypeChanged(ctx, adv);
                Boolean hotStandbyEnable = adv.getHotStandbyEnable();
                Boolean ordinaryEnable = adv.getOrdinaryEnable();
                if (Boolean.TRUE.equals(hotStandbyEnable)) {
                    constraint.setHotStandbyExplicitPathName(pathName);
                    this.setChange((IMOChangeRecord<RsvpTeTunnelPathConstraint>)record, constraint, "hotStandbyExplicitPathName", secondChanged);
                    AsnTranslatorUtil.addModifyDbNull((Context)ctx, (VmfMO)constraint, (String[])new String[]{"ordinaryExplicitPathName"});
                    break;
                }
                if (Boolean.TRUE.equals(ordinaryEnable)) {
                    constraint.setOrdinaryExplicitPathName(pathName);
                    this.setChange((IMOChangeRecord<RsvpTeTunnelPathConstraint>)record, constraint, "ordinaryExplicitPathName", secondChanged);
                    AsnTranslatorUtil.addModifyDbNull((Context)ctx, (VmfMO)constraint, (String[])new String[]{"hotStandbyExplicitPathName"});
                    break;
                }
                AsnTranslatorUtil.addModifyDbNull((Context)ctx, (VmfMO)constraint, (String[])new String[]{"ordinaryExplicitPathName", "hotStandbyExplicitPathName"});
                break;
            }
            default: {
                this.getLogger().info("QAsnTunnelExPathAttr.iType is invalidate, iType=" + qasnTunnelExPathAttr.iType);
            }
        }
    }

    public void encodeKeyProperties(RsvpTeTunnel mo, QAsnPathConstraintAttr asn, IAsnTranslationContext context) throws VMFException {
    }

    public void encodeKeyRefMoExplicitPath(RsvpTeTunnel mo, QAsnPathConstraintAttr asn, IAsnTranslationContext context) throws VMFException {
        List<String> pathNames = MplsUtil.getTunnelExpathNames(mo);
        if (CollectionUtils.isEmpty(pathNames)) {
            return;
        }
        ArrayList<ExplicitPath> explicitPaths = new ArrayList<ExplicitPath>();
        for (String pathName : pathNames) {
            ExplicitPath explicitPath = new ExplicitPath();
            AsnTranslatorUtil.copyDevAndVrId((VmfMO)mo, (VmfMO)explicitPath);
            explicitPath.setExplicitPathName(pathName);
            explicitPaths.add(explicitPath);
        }
        MplsDao dao = MplsDao.newInstance();
        dao.queryByParentKey(ExplicitPathHop.class, ExplicitPath.class, explicitPaths);
        for (ExplicitPath explicitPath : explicitPaths) {
            Collection explicitPathHops = explicitPath.getExplicitPathHops();
            if (CollectionUtils.isEmpty((Collection)explicitPathHops)) continue;
            context.addProperty(ExplicitPath.class.getName(), (Object)explicitPath);
            if (null == asn.lstTunnelExpathHopAttr) {
                asn.lstTunnelExpathHopAttr = new QAsnTunnelExpathHopAttrList();
                AsnUtil.setDefaultAsnValue((FStruct)asn.lstTunnelExpathHopAttr);
            }
            asn.lstTunnelExpathHopAttr.addAll(this.qasnExpathHopTranslator.encode(explicitPathHops, context));
        }
    }

    public void encodeLstAffinityAttr(RsvpTeTunnel mo, QAsnPathConstraintAttr asn, IAsnTranslationContext context) throws VMFException {
        RsvpTeTunnelPathConstraint constraint = mo.getRsvpTeTunnelPathConstraint();
        if (null == constraint) {
            return;
        }
        this.encodeAffinityAttr(constraint.getPrimaryIncludeAny(), constraint.getPrimaryExcludeAny(), 1, asn);
        String secondaryIncludeAny = null;
        String secondaryExcludeAny = null;
        RsvpTeTunnelAdv adv = mo.getRsvpTeTunnelAdv();
        if (null != adv) {
            if (Boolean.TRUE.equals(adv.getHotStandbyEnable())) {
                secondaryIncludeAny = constraint.getHotStandbyIncludeAny();
                secondaryExcludeAny = constraint.getHotStandbyExcludeAny();
            } else if (Boolean.TRUE.equals(adv.getOrdinaryEnable())) {
                secondaryIncludeAny = constraint.getOrdinaryIncludeAny();
                secondaryExcludeAny = constraint.getOrdinaryExcludeAny();
            }
        }
        this.encodeAffinityAttr(secondaryIncludeAny, secondaryExcludeAny, 2, asn);
        this.encodeAffinityAttr(constraint.getBestEffortIncludeAny(), constraint.getBestEffortExcludeAny(), 3, asn);
    }

    public void encodeLstHopLimitAttr(RsvpTeTunnel mo, QAsnPathConstraintAttr asn, IAsnTranslationContext context) throws VMFException {
        RsvpTeTunnelPathConstraint constraint = mo.getRsvpTeTunnelPathConstraint();
        RsvpTeTunnelAdv adv = mo.getRsvpTeTunnelAdv();
        if (null == constraint || adv == null) {
            return;
        }
        this.encodeHopLimitAttr(constraint.getPrimaryHopLimit(), 1, asn);
        if (Boolean.TRUE.equals(adv.getHotStandbyEnable())) {
            this.encodeHopLimitAttr(constraint.getHotStandbyHopLimit(), 2, asn);
        } else if (Boolean.TRUE.equals(adv.getOrdinaryEnable())) {
            this.encodeHopLimitAttr(constraint.getOrdinaryHopLimit(), 2, asn);
        } else {
            this.encodeHopLimitAttr(-1L, 2, asn);
        }
        if (Boolean.TRUE.equals(adv.getBestEffortEnable())) {
            this.encodeHopLimitAttr(constraint.getBestEffortHopLimit(), 3, asn);
        } else {
            this.encodeHopLimitAttr(-1L, 3, asn);
        }
    }

    public void encodeLstTunnelExPathAttr(RsvpTeTunnel mo, QAsnPathConstraintAttr asn, IAsnTranslationContext context) throws VMFException {
        RsvpTeTunnelPathConstraint constraint = mo.getRsvpTeTunnelPathConstraint();
        RsvpTeTunnelAdv adv = mo.getRsvpTeTunnelAdv();
        if (null == constraint || adv == null) {
            return;
        }
        this.encodeTunnelExPathAttr(constraint.getPrimaryExplicitPathName(), 1, asn);
        if (Boolean.TRUE.equals(adv.getHotStandbyEnable())) {
            this.encodeTunnelExPathAttr(constraint.getHotStandbyExplicitPathName(), 2, asn);
        }
        if (Boolean.TRUE.equals(adv.getOrdinaryEnable())) {
            this.encodeTunnelExPathAttr(constraint.getOrdinaryExplicitPathName(), 2, asn);
        }
        if (Boolean.TRUE.equals(adv.getBestEffortEnable())) {
            this.encodeTunnelExPathAttr(constraint.getBestEffortExplicitPathName(), 3, asn);
        }
    }

    private String addHexPrefix(String str) {
        if (!StringUtil.isEmpty((String)str)) {
            return "0x" + str;
        }
        return "0x0";
    }

    private void decodeHopLimitAttr(QAsnHopLimitAttr qasnHopLimitAttr, RsvpTeTunnel mo, IAsnTranslationContext context) {
        Long limitValue;
        boolean isChanged;
        RsvpTeTunnelPathConstraint constraint = this.getRsvpTeTunnelPathConstraint(mo);
        RsvpTeTunnelAdv adv = mo.getRsvpTeTunnelAdv();
        Context ctx = context.getTransactionContext();
        IMOChangeRecord record = ctx.addChangeRecord(RsvpTeTunnelPathConstraint.class);
        Integer operMask = qasnHopLimitAttr.poOperMask;
        boolean isDelete = AsnTranslatorUtil.isMaskChanged((Integer)operMask, (int)2);
        boolean isModify = AsnTranslatorUtil.isMaskChanged((Integer)operMask, (int)8);
        boolean isCreate = AsnTranslatorUtil.isMaskChanged((Integer)operMask, (int)1);
        boolean bl = isChanged = isDelete || isModify || isCreate;
        if (!isChanged && !this.isCreate(context) && qasnHopLimitAttr.iType == 1) {
            return;
        }
        Long l = limitValue = -1 == qasnHopLimitAttr.iValue ? null : Long.valueOf(qasnHopLimitAttr.iValue);
        if (isDelete) {
            limitValue = 32L;
        }
        switch (qasnHopLimitAttr.iType) {
            case 1: {
                constraint.setPrimaryHopLimit(limitValue);
                this.setChange((IMOChangeRecord<RsvpTeTunnelPathConstraint>)record, constraint, "primaryHopLimit", isChanged);
                break;
            }
            case 2: {
                boolean secondChanged = isChanged || this.isBackTypeChanged(ctx, adv);
                Boolean hotStandbyEnable = adv.getHotStandbyEnable();
                Boolean ordinaryEnable = adv.getOrdinaryEnable();
                if (Boolean.TRUE.equals(hotStandbyEnable)) {
                    constraint.setHotStandbyHopLimit(limitValue);
                    this.setChange((IMOChangeRecord<RsvpTeTunnelPathConstraint>)record, constraint, "hotStandbyHopLimit", secondChanged);
                    AsnTranslatorUtil.addModifyDbNull((Context)ctx, (VmfMO)constraint, (String[])new String[]{"ordinaryHopLimit"});
                    break;
                }
                if (Boolean.TRUE.equals(ordinaryEnable)) {
                    constraint.setOrdinaryHopLimit(limitValue);
                    this.setChange((IMOChangeRecord<RsvpTeTunnelPathConstraint>)record, constraint, "ordinaryHopLimit", secondChanged);
                    AsnTranslatorUtil.addModifyDbNull((Context)ctx, (VmfMO)constraint, (String[])new String[]{"hotStandbyHopLimit"});
                    break;
                }
                AsnTranslatorUtil.addModifyDbNull((Context)ctx, (VmfMO)constraint, (String[])new String[]{"ordinaryHopLimit", "hotStandbyHopLimit"});
                break;
            }
            case 3: {
                if (Boolean.TRUE.equals(adv.getBestEffortEnable())) {
                    constraint.setBestEffortHopLimit(limitValue);
                    this.setChange((IMOChangeRecord<RsvpTeTunnelPathConstraint>)record, constraint, "bestEffortHopLimit", isChanged);
                    break;
                }
                AsnTranslatorUtil.addModifyDbNull((Context)ctx, (VmfMO)constraint, (String[])new String[]{"bestEffortHopLimit"});
                break;
            }
            default: {
                this.getLogger().info("QAsnHopLimitAttr.iType is invalidate, iType=" + qasnHopLimitAttr.iType);
            }
        }
    }

    private void encodeAffinityAttr(String includeAny, String excludeAny, int type, QAsnPathConstraintAttr asn) {
        QAsnAffinityAttr qasnAffinityAttr = new QAsnAffinityAttr();
        qasnAffinityAttr.iType = type;
        if (StringUtil.isEmpty((String)includeAny)) {
            qasnAffinityAttr.strValue = AsnUtil.getBytes((String)includeAny);
            qasnAffinityAttr.strMask = AsnUtil.getBytes((String)includeAny);
        } else {
            String tmpIncludeAny = this.removeHexPrefix(includeAny);
            String tmpExcludeAny = this.removeHexPrefix(excludeAny);
            qasnAffinityAttr.strValue = AsnUtil.getBytes((String)this.addHexPrefix(tmpIncludeAny));
            Long strMask = Long.parseLong(tmpIncludeAny, 16) | Long.parseLong(tmpExcludeAny, 16);
            qasnAffinityAttr.strMask = AsnUtil.getBytes((String)this.addHexPrefix(Long.toHexString(strMask)));
        }
        if (null == asn.lstAffinityAttr) {
            asn.lstAffinityAttr = new QAsnAffinityAttrList();
        }
        asn.lstAffinityAttr.add((Object)qasnAffinityAttr);
    }

    private void encodeHopLimitAttr(Long hopLimit, int type, QAsnPathConstraintAttr asn) {
        QAsnHopLimitAttr qasnHopLimitAttr = new QAsnHopLimitAttr();
        qasnHopLimitAttr.iType = type;
        qasnHopLimitAttr.iValue = null != hopLimit ? AsnUtil.intValue((Long)hopLimit) : -1;
        if (null == asn.lstHopLimitAttr) {
            asn.lstHopLimitAttr = new QAsnHopLimitAttrList();
        }
        asn.lstHopLimitAttr.add((Object)qasnHopLimitAttr);
    }

    private void encodeTunnelExPathAttr(String pathName, int type, QAsnPathConstraintAttr asn) {
        if (StringUtils.isEmpty((String)pathName)) {
            return;
        }
        QAsnTunnelExPathAttr qanTunnelExPathAttr = new QAsnTunnelExPathAttr();
        qanTunnelExPathAttr.iEnable = 1;
        qanTunnelExPathAttr.iType = type;
        qanTunnelExPathAttr.strName = AsnUtil.getBytes((String)pathName);
        if (null == asn.lstTunnelExPathAttr) {
            asn.lstTunnelExPathAttr = new QAsnTunnelExPathAttrList();
        }
        asn.lstTunnelExPathAttr.add((Object)qanTunnelExPathAttr);
    }

    private RsvpTeTunnelPathConstraint getRsvpTeTunnelPathConstraint(RsvpTeTunnel mo) {
        RsvpTeTunnelPathConstraint constraint = mo.getRsvpTeTunnelPathConstraint();
        if (constraint == null) {
            constraint = new RsvpTeTunnelPathConstraint();
            constraint.setDevID(mo.getDevID());
            constraint.setVrID(mo.getVrID());
            constraint.setTunnelName(mo.getTunnelName());
            mo.setRsvpTeTunnelPathConstraint(constraint);
        }
        return constraint;
    }

    private boolean isBackTypeChanged(Context ctx, RsvpTeTunnelAdv adv) {
        IMOChangeRecord advRecord = ctx.addChangeRecord(RsvpTeTunnelAdv.class);
        return advRecord.isModified((Object)adv, "hotStandbyEnable") || advRecord.isModified((Object)adv, "ordinaryEnable");
    }

    private boolean isCreate(IAsnTranslationContext context) {
        return EOperationType.CREATE.equals((Object)context.getOperType()) || EOperationType.PREDEPLOY.equals((Object)context.getOperType());
    }

    private String removeHexPrefix(String str) {
        if (StringUtil.isEmpty((String)str)) {
            return DEFAULT_TUNNEL_PATH_VALUE;
        }
        if (str.toUpperCase().startsWith("0x".toUpperCase())) {
            return str.substring("0x".length());
        }
        return str;
    }

    private void setChange(IMOChangeRecord<RsvpTeTunnelPathConstraint> record, RsvpTeTunnelPathConstraint constraint, String fieldName, boolean isChange) {
        if (isChange) {
            record.addModify((Object)constraint, new PropertyChangeItem(fieldName));
        }
    }

    private static final class ITYPE_ENUM {
        private static final int BEST_EFFORT = 3;
        private static final int PRIMARY = 1;
        private static final int SECONDARY = 2;

        private ITYPE_ENUM() {
        }
    }
}

