/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.vmf.adapter.mpls.translation.asn.spec;

import com.huawei.network.qasn.m_q_ip_common_model.QAsnLDPPeerInfo;
import com.huawei.network.qasn.m_q_ip_common_model.QAsnLDPPeerInfoList;
import com.huawei.network.qasn.m_q_ip_common_model.QAsnMplsInfo;
import com.huawei.vmf.adapter.common.exception.VMFException;
import com.huawei.vmf.adapter.common.utilty.AsnUtil;
import com.huawei.vmf.adapter.framework.notify.IMOChangeRecord;
import com.huawei.vmf.adapter.framework.notify.PropertyChangeItem;
import com.huawei.vmf.adapter.framework.translation.asn.AbstractAsnSpecTranslator;
import com.huawei.vmf.adapter.framework.translation.asn.AsnTranslatorUtil;
import com.huawei.vmf.adapter.framework.translation.asn.IAsnTranslationContext;
import com.huawei.vmf.adapter.framework.translation.asn.IAsnTranslator;
import com.huawei.vmf.adapter.fservice.model.EOperationType;
import com.huawei.vmf.adapter.fservice.model.VmfMO;
import com.huawei.vmf.adapter.fservice.mpls.model.LdpInstance;
import com.huawei.vmf.adapter.fservice.mpls.model.LdpRemotePeer;
import com.huawei.vmf.adapter.fservice.mpls.model.MplsCommonCfg;
import com.huawei.vmf.adapter.fservice.mpls.model.MplsTeSite;
import com.huawei.vmf.adapter.fservice.pwe3.model.L2vpnGlobal;
import com.huawei.vmf.adapter.mpls.dao.MplsDao;
import com.huawei.vmf.adapter.mpls.translation.asn.QAsnLDPPeerInfoTranslator;
import com.huawei.vmf.adapter.mpls.translation.asn.QAsnMplsInfoTranslator;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import org.springframework.util.CollectionUtils;

public class QAsnMplsInfoSpecTranslator
extends AbstractAsnSpecTranslator<QAsnMplsInfoTranslator> {
    private IAsnTranslator<QAsnLDPPeerInfo, LdpRemotePeer> qasnLDPPeerInfoTranslator = new QAsnLDPPeerInfoTranslator();

    public void decodeIL2VPN(QAsnMplsInfo asn, MplsCommonCfg mo, IAsnTranslationContext context) throws VMFException {
        L2vpnGlobal l2vpnGlobal = new L2vpnGlobal();
        AsnTranslatorUtil.copyDevAndVrId((VmfMO)mo, (VmfMO)l2vpnGlobal);
        l2vpnGlobal.setL2vpnEnable(AsnUtil.parseBoolean((Integer)asn.iL2VPN));
        mo.addKeyRefMo((VmfMO)l2vpnGlobal);
    }

    public void decodeKeyProperties(QAsnMplsInfo asn, MplsCommonCfg mo, IAsnTranslationContext context) throws VMFException {
        mo.setDevID(Integer.valueOf(asn.neID));
    }

    public void decodeKeyRefMoLdpInstance(QAsnMplsInfo asn, MplsCommonCfg mo, IAsnTranslationContext context) throws VMFException {
        if (CollectionUtils.isEmpty((Collection)asn.poPeerInfo) || asn.poOperbit == null || (asn.poOperbit & 0x80) == 0) {
            return;
        }
        IMOChangeRecord mplsRecord = context.getTransactionContext().addChangeRecord(MplsCommonCfg.class);
        mplsRecord.addModify((Object)mo, new PropertyChangeItem(LdpInstance.class.getName()));
        LdpInstance ldpInstance = new LdpInstance();
        this.decodeLdpInstance(asn, ldpInstance, context);
        mo.addKeyRefMo((VmfMO)ldpInstance);
    }

    public void decodeKeyRefMoMplsTeSite(QAsnMplsInfo asn, MplsCommonCfg mo, IAsnTranslationContext context) throws VMFException {
        MplsTeSite mplsTeSite = new MplsTeSite();
        AsnTranslatorUtil.copyDevAndVrId((VmfMO)mo, (VmfMO)mplsTeSite);
        mplsTeSite.setCompositeType(MplsTeSite.COMPOSITE_TYPE_ENUM.MPLS_TE_SITE);
        mplsTeSite.setAutoFrrEnable(AsnUtil.parseBoolean((Integer)asn.iAutoFrr));
        mo.addKeyRefMo((VmfMO)mplsTeSite);
        MplsTeSite cspfCfg = new MplsTeSite();
        AsnTranslatorUtil.copyDevAndVrId((VmfMO)mo, (VmfMO)cspfCfg);
        cspfCfg.setCompositeType(MplsTeSite.COMPOSITE_TYPE_ENUM.CSPF_CFG);
        cspfCfg.setEnableCspf(AsnUtil.parseBoolean((Integer)asn.iMplsTeCspf));
        mo.addKeyRefMo((VmfMO)cspfCfg);
    }

    public void decodeLdpInstance(QAsnMplsInfo asn, LdpInstance mo, IAsnTranslationContext context) throws VMFException {
        this.decodePoPeerInfo(asn, mo, context);
    }

    public void encodeIL2VPN(MplsCommonCfg mo, QAsnMplsInfo asn, IAsnTranslationContext context) throws VMFException {
        List l2vpnGlobals = mo.getKeyRefMos(L2vpnGlobal.class);
        if (CollectionUtils.isEmpty((Collection)l2vpnGlobals)) {
            return;
        }
        L2vpnGlobal l2vpnGlobal = (L2vpnGlobal)l2vpnGlobals.iterator().next();
        asn.iL2VPN = AsnUtil.intValue((Boolean)l2vpnGlobal.getL2vpnEnable());
    }

    public void encodeKeyProperties(MplsCommonCfg mo, QAsnMplsInfo asn, IAsnTranslationContext context) throws VMFException {
        asn.neID = mo.getDevID();
    }

    public void encodeKeyRefMoLdpInstance(MplsCommonCfg mo, QAsnMplsInfo asn, IAsnTranslationContext context) throws VMFException {
        List ldpInstances = mo.getKeyRefMos(LdpInstance.class);
        if (CollectionUtils.isEmpty((Collection)ldpInstances)) {
            return;
        }
        LdpInstance ldpInstance = (LdpInstance)ldpInstances.iterator().next();
        if (CollectionUtils.isEmpty((Collection)ldpInstance.getLdpRemotePeers())) {
            return;
        }
        asn.poPeerInfo = new QAsnLDPPeerInfoList();
        for (LdpRemotePeer ldpRemotePeer : ldpInstance.getLdpRemotePeers()) {
            QAsnLDPPeerInfo qAsnLDPPeerInfo = (QAsnLDPPeerInfo)this.qasnLDPPeerInfoTranslator.encode((Object)ldpRemotePeer, context);
            asn.poPeerInfo.add((Object)qAsnLDPPeerInfo);
        }
    }

    public void encodeKeyRefMoMplsTeSite(MplsCommonCfg mo, QAsnMplsInfo asn, IAsnTranslationContext context) throws VMFException {
        List mplsTeSites = mo.getKeyRefMos(MplsTeSite.class);
        if (CollectionUtils.isEmpty((Collection)mplsTeSites)) {
            return;
        }
        for (MplsTeSite mplsTeSite : mplsTeSites) {
            if (mplsTeSite.getCompositeType().equals(MplsTeSite.COMPOSITE_TYPE_ENUM.MPLS_TE_SITE)) {
                asn.iAutoFrr = AsnUtil.intValue((Boolean)mplsTeSite.getAutoFrrEnable());
                continue;
            }
            if (!mplsTeSite.getCompositeType().equals(MplsTeSite.COMPOSITE_TYPE_ENUM.CSPF_CFG)) continue;
            asn.iMplsTeCspf = AsnUtil.intValue((Boolean)mplsTeSite.getEnableCspf());
        }
    }

    private void decodePoPeerInfo(QAsnMplsInfo asn, LdpInstance mo, IAsnTranslationContext context) throws VMFException {
        if (null == asn.poPeerInfo) {
            return;
        }
        mo.setDevID(Integer.valueOf(asn.neID));
        mo.setVrfName("_public_");
        context.addProperty(LdpInstance.class.getName(), (Object)mo);
        EOperationType operType = AsnTranslatorUtil.setAddOrDeleted((VmfMO)mo, (int)0, (int)0, (Integer)asn.poOperbit, (IAsnTranslationContext)context);
        if (operType.equals((Object)EOperationType.DELETE)) {
            return;
        }
        mo.addLdpRemotePeers(this.qasnLDPPeerInfoTranslator.decode((Collection)asn.poPeerInfo, context));
        if (CollectionUtils.isEmpty((Collection)mo.getLdpRemotePeers())) {
            return;
        }
        IMOChangeRecord ldpRecord = context.getTransactionContext().addChangeRecord(LdpInstance.class);
        if (!this.isExsist(mo)) {
            ldpRecord.addCreate((Object)mo);
        }
        IMOChangeRecord peerRecord = context.getTransactionContext().addChangeRecord(LdpRemotePeer.class);
        for (LdpRemotePeer ldpPeer : mo.getLdpRemotePeers()) {
            if (!peerRecord.isChanged((Object)ldpPeer) || ldpRecord.isCreated((Object)mo) || ldpRecord.isDeleted((Object)mo)) continue;
            ldpRecord.addModify((Object)mo, new PropertyChangeItem("ldpRemotePeers"));
            break;
        }
    }

    private boolean isExsist(LdpInstance ldpInstance) throws VMFException {
        return !CollectionUtils.isEmpty((Collection)MplsDao.newInstance().queryByKey(LdpInstance.class, Arrays.asList(ldpInstance), false));
    }
}

