/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.vmf.adapter.mpls.translation.asn.spec;

import com.huawei.network.qasn.m_q_ip_tunnel_model.QAsnMplsIfBaseInfo;
import com.huawei.vmf.adapter.common.exception.VMFException;
import com.huawei.vmf.adapter.common.utilty.StringUtil;
import com.huawei.vmf.adapter.framework.translation.asn.AbstractAsnSpecTranslator;
import com.huawei.vmf.adapter.framework.translation.asn.IAsnTranslationContext;
import com.huawei.vmf.adapter.fservice.ifm.model.Interface;
import com.huawei.vmf.adapter.fservice.ifm.model.Ipv4Address;
import com.huawei.vmf.adapter.fservice.model.VmfMO;
import com.huawei.vmf.adapter.fservice.mpls.fdn.MplsInterfaceFdnParser;
import com.huawei.vmf.adapter.fservice.mpls.model.MplsInterface;
import com.huawei.vmf.adapter.mpls.common.MplsUtil;
import com.huawei.vmf.adapter.mpls.translation.asn.QAsnMplsIfBaseInfoTranslator;
import java.util.Collection;
import java.util.List;
import org.springframework.util.CollectionUtils;

public class QAsnMplsIfBaseInfoSpecTranslator
extends AbstractAsnSpecTranslator<QAsnMplsIfBaseInfoTranslator> {
    public void decodeIAdminStatus(QAsnMplsIfBaseInfo asn, MplsInterface mo, IAsnTranslationContext context) throws VMFException {
    }

    public void decodeIInterfaceType(QAsnMplsIfBaseInfo asn, MplsInterface mo, IAsnTranslationContext context) throws VMFException {
    }

    public void decodeIMplsTeStatus(QAsnMplsIfBaseInfo asn, MplsInterface mo, IAsnTranslationContext context) throws VMFException {
    }

    public void decodeIRunningStatus(QAsnMplsIfBaseInfo asn, MplsInterface mo, IAsnTranslationContext context) throws VMFException {
    }

    public void decodeKeyProperties(QAsnMplsIfBaseInfo asn, MplsInterface mo, IAsnTranslationContext context) throws VMFException {
        MplsInterfaceFdnParser fdnParser = new MplsInterfaceFdnParser();
        MplsInterface temp = (MplsInterface)fdnParser.getIndexMo(asn.oInterfaceKey);
        mo.setDevID(temp.getDevID());
        mo.setVrID(temp.getDevID());
        mo.setInterfaceName(temp.getInterfaceName());
        mo.setFdn(temp.getFdn());
    }

    public void decodeQAsnMplsIfBaseInfoSpecKeys(QAsnMplsIfBaseInfo asn, MplsInterface mo, IAsnTranslationContext context) throws VMFException {
    }

    public void decodeStrAddress(QAsnMplsIfBaseInfo asn, MplsInterface mo, IAsnTranslationContext context) throws VMFException {
    }

    public void encodeIAdminStatus(MplsInterface mo, QAsnMplsIfBaseInfo asn, IAsnTranslationContext context) throws VMFException {
        Interface ifm = this.getRefInterface(mo);
        if (ifm != null) {
            asn.iAdminStatus = ifm.getIfAdminStatus();
            asn.strPortName = StringUtil.globalByte((String)ifm.getIfName());
        }
    }

    public void encodeIInterfaceType(MplsInterface mo, QAsnMplsIfBaseInfo asn, IAsnTranslationContext context) throws VMFException {
        Interface ifm = this.getRefInterface(mo);
        if (ifm != null) {
            asn.iInterfaceType = ifm.getiQIfType();
        }
    }

    public void encodeIMplsTeStatus(MplsInterface mo, QAsnMplsIfBaseInfo asn, IAsnTranslationContext context) throws VMFException {
        asn.iMplsTeStatus = 0;
        if (null != mo.getMplsTEEnable() && mo.getMplsTEEnable().booleanValue()) {
            asn.iMplsTeStatus = 1;
        }
    }

    public void encodeIRunningStatus(MplsInterface mo, QAsnMplsIfBaseInfo asn, IAsnTranslationContext context) throws VMFException {
        if (null == asn) {
            return;
        }
        Interface ifm = this.getRefInterface(mo);
        if (ifm != null) {
            asn.iRunningStatus = ifm.getIfOperStatus() == null ? -1 : ifm.getIfOperStatus();
        }
    }

    public void encodeKeyProperties(MplsInterface mo, QAsnMplsIfBaseInfo asn, IAsnTranslationContext context) throws VMFException {
        MplsInterfaceFdnParser fdnParser = new MplsInterfaceFdnParser();
        asn.oInterfaceKey = fdnParser.getUniResID((VmfMO)mo);
        asn.iMplsStatus = !CollectionUtils.isEmpty((Collection)mo.getKeyRefMos(MplsInterface.class)) ? 0 : 1;
    }

    public void encodeStrAddress(MplsInterface mo, QAsnMplsIfBaseInfo asn, IAsnTranslationContext context) throws VMFException {
        Interface ifm = this.getRefInterface(mo);
        if (ifm == null) {
            return;
        }
        Collection ipv4Addresses = ifm.getIpv4Addresss();
        if (CollectionUtils.isEmpty((Collection)ipv4Addresses)) {
            return;
        }
        for (Ipv4Address ipv4Address : ipv4Addresses) {
            if (ipv4Address.getIpAddr() == null || !Ipv4Address.ADDR_TYPE_ENUM.MAIN.equals(ipv4Address.getAddrType())) continue;
            asn.strAddress = StringUtil.globalByte((String)ipv4Address.getIpAddr());
            return;
        }
    }

    private Interface getRefInterface(MplsInterface mo) {
        List ifms = mo.getKeyRefMos(Interface.class);
        if (CollectionUtils.isEmpty((Collection)ifms)) {
            return null;
        }
        return (Interface)ifms.iterator().next();
    }

    public void postEncode(MplsInterface mo, QAsnMplsIfBaseInfo asn, IAsnTranslationContext context) {
        if (!MplsUtil.isPtn()) {
            return;
        }
        asn.iTunnelStatus = asn.iMplsStatus;
        asn.iMplsStatus = -1;
        asn.iMplsTeStatus = -1;
    }

    private static final class IMPLS_TE_STATUS_ENUM {
        private static final int DISABLE = 0;
        private static final int ENABLE = 1;

        private IMPLS_TE_STATUS_ENUM() {
        }
    }
}

