/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.vmf.adapter.mpls.translation.asn.spec;

import com.huawei.network.qasn.m_q_common.QAsnUniResID;
import com.huawei.network.qasn.m_q_ip_tunnel_model.QAsnBandWidthAttr;
import com.huawei.network.qasn.m_q_ip_tunnel_model.QAsnBandWidthAttrList;
import com.huawei.network.qasn.m_q_ip_tunnel_model.QAsnLspHop;
import com.huawei.network.qasn.m_q_ip_tunnel_model.QAsnTnlBindRing;
import com.huawei.vmf.adapter.common.exception.VMFException;
import com.huawei.vmf.adapter.common.utilty.AsnUtil;
import com.huawei.vmf.adapter.common.utilty.StringUtil;
import com.huawei.vmf.adapter.framework.notify.IMOChangeRecord;
import com.huawei.vmf.adapter.framework.translation.asn.AbstractAsnSpecTranslator;
import com.huawei.vmf.adapter.framework.translation.asn.AsnTranslatorUtil;
import com.huawei.vmf.adapter.framework.translation.asn.IAsnTranslationContext;
import com.huawei.vmf.adapter.fservice.ifm.fdn.InterfaceFdnParser;
import com.huawei.vmf.adapter.fservice.ifm.model.Interface;
import com.huawei.vmf.adapter.fservice.model.EOperationType;
import com.huawei.vmf.adapter.fservice.model.VmfMO;
import com.huawei.vmf.adapter.fservice.mpls.model.StaticTunnel;
import com.huawei.vmf.adapter.fservice.service.IFdnParser;
import com.huawei.vmf.adapter.mpls.common.MplsAsnUtil;
import com.huawei.vmf.adapter.mpls.common.MplsUtil;
import com.huawei.vmf.adapter.mpls.translation.asn.QAsnBandWidthAttrForStaticTunnelTranslator;
import com.huawei.vmf.adapter.mpls.translation.asn.QAsnLspHopForStaticTunnelTranslator;
import com.huawei.vmf.adapter.mpls.translation.asn.QAsnTunnelBaseForStaticTunnelTranslator;
import java.util.Arrays;
import java.util.Collection;
import org.springframework.util.CollectionUtils;

public class QAsnLspHopForStaticTunnelSpecTranslator
extends AbstractAsnSpecTranslator<QAsnLspHopForStaticTunnelTranslator> {
    private IFdnParser<StaticTunnel> staticTunnFdnParser = MplsUtil.getStaticTunnelFdnParser();
    private IFdnParser<Interface> ifmFdnParser = new InterfaceFdnParser();
    private QAsnBandWidthAttrForStaticTunnelTranslator qasnBandWidthAttrTranslator = new QAsnBandWidthAttrForStaticTunnelTranslator();

    public void decodeISignalType(QAsnLspHop asn, StaticTunnel mo, IAsnTranslationContext context) throws VMFException {
    }

    public void decodeKeyProperties(QAsnLspHop asn, StaticTunnel mo, IAsnTranslationContext context) throws VMFException {
        MplsAsnUtil.decodeStaticCRTunnelKeys(asn.oTunnelKey, mo, context);
    }

    public void decodeLstBandWidthAttr(QAsnLspHop asn, StaticTunnel mo, IAsnTranslationContext context) throws VMFException {
        if (CollectionUtils.isEmpty((Collection)asn.lstBandWidthAttr)) {
            return;
        }
        this.qasnBandWidthAttrTranslator.decode((QAsnBandWidthAttr)asn.lstBandWidthAttr.iterator().next(), mo, context);
    }

    public void decodePoDirection(QAsnLspHop asn, StaticTunnel mo, IAsnTranslationContext context) throws VMFException {
        if (null != asn.poDirection) {
            mo.setDirection(AsnTranslatorUtil.integerValue((Integer)asn.poDirection, (String)"direction", (Object[][])QAsnLspHopForStaticTunnelTranslator.z_staticTunnelMasks, (VmfMO)mo, (IAsnTranslationContext)context));
        }
    }

    public void decodePoInTnlType(QAsnLspHop asn, StaticTunnel mo, IAsnTranslationContext context) throws VMFException {
        if (null != asn.poInTnlType) {
            mo.setInBearerType(AsnTranslatorUtil.integerValue((Integer)asn.poInTnlType, (String)"inBearerType", (Object[][])QAsnLspHopForStaticTunnelTranslator.z_staticTunnelMasks, (VmfMO)mo, (IAsnTranslationContext)context));
        }
    }

    public void decodePoOutTnlType(QAsnLspHop asn, StaticTunnel mo, IAsnTranslationContext context) throws VMFException {
        if (null != asn.poOutTnlType) {
            mo.setOutBearerType(AsnTranslatorUtil.integerValue((Integer)asn.poOutTnlType, (String)"outBearerType", (Object[][])QAsnLspHopForStaticTunnelTranslator.z_staticTunnelMasks, (VmfMO)mo, (IAsnTranslationContext)context));
        }
    }

    public void decodePoSnkRing(QAsnLspHop asn, StaticTunnel mo, IAsnTranslationContext context) throws VMFException {
        if (null == asn.poSnkRing || 0 == asn.poSnkRing.ringID && 0 == asn.poSnkRing.bandingRingDirection) {
            return;
        }
        mo.setEnterRingId(Integer.valueOf(AsnUtil.intValue((Integer)asn.poSnkRing.ringID)));
        mo.setEnterRingSinkNodeId(Integer.valueOf(asn.poSnkRing.peerNodeID));
        int ringDirection = asn.poSnkRing.bandingRingDirection;
        mo.setEnterRingDirection(Integer.valueOf(ringDirection));
        if (EOperationType.MODIFY == context.getOperType()) {
            IMOChangeRecord recorder = context.getTransactionContext().addChangeRecord(StaticTunnel.class);
            if (-1 == ringDirection || 0 == ringDirection) {
                recorder.addModify((Object)mo, Arrays.asList("enterRingId", "enterRingSinkNodeId"));
            } else {
                recorder.addModify((Object)mo, Arrays.asList("enterRingDirection", "enterRingId", "enterRingSinkNodeId"));
            }
        }
    }

    public void decodePoSrcRing(QAsnLspHop asn, StaticTunnel mo, IAsnTranslationContext context) throws VMFException {
        if (null == asn.poSrcRing || 0 == asn.poSrcRing.ringID && 0 == asn.poSrcRing.bandingRingDirection) {
            return;
        }
        mo.setQuitRingId(Integer.valueOf(AsnUtil.intValue((Integer)asn.poSrcRing.ringID)));
        mo.setQuitRingSrcNodeId(Integer.valueOf(asn.poSrcRing.peerNodeID));
        Integer ringDirection = asn.poSrcRing.bandingRingDirection;
        mo.setQuitRingDirection(ringDirection);
        if (EOperationType.MODIFY == context.getOperType()) {
            IMOChangeRecord recorder = context.getTransactionContext().addChangeRecord(StaticTunnel.class);
            if (-1 == ringDirection || 0 == ringDirection) {
                recorder.addModify((Object)mo, Arrays.asList("quitRingId", "quitRingSrcNodeId"));
            } else {
                recorder.addModify((Object)mo, Arrays.asList("quitRingDirection", "quitRingId", "quitRingSrcNodeId"));
            }
        }
    }

    public void decodePoTPOam(QAsnLspHop asn, StaticTunnel mo, IAsnTranslationContext context) throws VMFException {
    }

    public void encodeISignalType(StaticTunnel mo, QAsnLspHop asn, IAsnTranslationContext context) throws VMFException {
        asn.iSignalType = 1;
    }

    public void encodeKeyProperties(StaticTunnel mo, QAsnLspHop asn, IAsnTranslationContext context) throws VMFException {
        asn.oTunnelKey = this.staticTunnFdnParser.getUniResID((VmfMO)mo);
        asn.oTunnelKey.poSerialNum = AsnUtil.getBytes((String)mo.getSerialNum());
        asn.iDeployStatus = AsnUtil.intValue((Integer)mo.getDeployStatus());
    }

    public void encodeLstBandWidthAttr(StaticTunnel mo, QAsnLspHop asn, IAsnTranslationContext context) throws VMFException {
        QAsnBandWidthAttr bandWidthAttrAsn = (QAsnBandWidthAttr)this.qasnBandWidthAttrTranslator.encode(mo, context);
        if (asn.lstBandWidthAttr == null) {
            asn.lstBandWidthAttr = new QAsnBandWidthAttrList();
        }
        asn.lstBandWidthAttr.add((Object)bandWidthAttrAsn);
    }

    public void encodePoDirection(StaticTunnel mo, QAsnLspHop asn, IAsnTranslationContext context) throws VMFException {
        asn.poDirection = mo.getDirection();
    }

    public void encodePoInTnlType(StaticTunnel mo, QAsnLspHop asn, IAsnTranslationContext context) throws VMFException {
        Integer inTnlType = null;
        inTnlType = StaticTunnel.IN_BEARER_TYPE_ENUM.INTERFACE.equals(mo.getInBearerType()) ? TNL_TYPE_ENUM.INTERFACE : (StaticTunnel.IN_BEARER_TYPE_ENUM.RING.equals(mo.getInBearerType()) ? TNL_TYPE_ENUM.RING : null);
        asn.poInTnlType = inTnlType;
    }

    public void encodePoOutTnlType(StaticTunnel mo, QAsnLspHop asn, IAsnTranslationContext context) throws VMFException {
        Integer outTnlType = null;
        outTnlType = StaticTunnel.OUT_BEARER_TYPE_ENUM.INTERFACE.equals(mo.getInBearerType()) ? TNL_TYPE_ENUM.INTERFACE : (StaticTunnel.OUT_BEARER_TYPE_ENUM.RING.equals(mo.getInBearerType()) ? TNL_TYPE_ENUM.RING : null);
        asn.poOutTnlType = outTnlType;
    }

    public void encodePoSnkRing(StaticTunnel mo, QAsnLspHop asn, IAsnTranslationContext context) throws VMFException {
        if (-1 == AsnUtil.intValue((Integer)mo.getEnterRingId())) {
            return;
        }
        if (asn.poSnkRing == null) {
            asn.poSnkRing = new QAsnTnlBindRing();
        }
        asn.poSnkRing.ringID = AsnUtil.intValue((Integer)mo.getEnterRingId());
        asn.poSnkRing.peerNodeID = AsnUtil.intValue((Integer)mo.getEnterRingSinkNodeId());
        asn.poSnkRing.bandingRingDirection = mo.getEnterRingDirection();
    }

    public void encodePoSrcRing(StaticTunnel mo, QAsnLspHop asn, IAsnTranslationContext context) throws VMFException {
        if (-1 == AsnUtil.intValue((Integer)mo.getQuitRingId())) {
            return;
        }
        if (asn.poSrcRing == null) {
            asn.poSrcRing = new QAsnTnlBindRing();
        }
        asn.poSrcRing.ringID = AsnUtil.intValue((Integer)mo.getQuitRingId());
        asn.poSrcRing.peerNodeID = AsnUtil.intValue((Integer)mo.getQuitRingSrcNodeId());
        asn.poSrcRing.bandingRingDirection = mo.getQuitRingDirection();
    }

    public void encodePoTPOam(StaticTunnel mo, QAsnLspHop asn, IAsnTranslationContext context) throws VMFException {
    }

    public void decodeILsrType(QAsnLspHop asn, StaticTunnel mo, IAsnTranslationContext context) throws VMFException {
        mo.setLsrRole(AsnTranslatorUtil.integerValue((int)asn.iLsrType, (String)"lsrRole", (Object[][])QAsnTunnelBaseForStaticTunnelTranslator.z_staticTunnelMasks, (VmfMO)mo, (IAsnTranslationContext)context));
    }

    public void encodeILsrType(StaticTunnel mo, QAsnLspHop asn, IAsnTranslationContext context) throws VMFException {
        asn.iLsrType = AsnTranslatorUtil.intValue((Integer)mo.getLsrRole());
    }

    public void decodeOOutgoingIfKey(QAsnLspHop asn, StaticTunnel mo, IAsnTranslationContext context) {
        String fdn = this.getIfFdn(asn.oOutgoingIfKey);
        if (StringUtil.isEmpty((String)fdn)) {
            return;
        }
        Interface ifm = (Interface)this.ifmFdnParser.getIndexMo(fdn);
        mo.setOutgoingIfName(AsnTranslatorUtil.strValue((String)ifm.getIfName(), (String)"outgoingIfName", (Object[][])QAsnLspHopForStaticTunnelTranslator.z_staticTunnelMasks, (Object)mo, (IAsnTranslationContext)context));
        mo.setOutBearerType(StaticTunnel.OUT_BEARER_TYPE_ENUM.INTERFACE);
    }

    private String getIfFdn(QAsnUniResID resId) {
        if (resId == null) {
            return null;
        }
        return AsnUtil.strValue((byte[])resId.strFDN);
    }

    public void decodeOIncomingIfKey(QAsnLspHop asn, StaticTunnel mo, IAsnTranslationContext context) {
        String fdn = this.getIfFdn(asn.oIncomingIfKey);
        if (StringUtil.isEmpty((String)fdn)) {
            return;
        }
        Interface ifm = (Interface)this.ifmFdnParser.getIndexMo(fdn);
        mo.setIncomingIfName(AsnTranslatorUtil.strValue((String)ifm.getIfName(), (String)"incomingIfName", (Object[][])QAsnLspHopForStaticTunnelTranslator.z_staticTunnelMasks, (Object)mo, (IAsnTranslationContext)context));
        mo.setInBearerType(StaticTunnel.IN_BEARER_TYPE_ENUM.INTERFACE);
    }

    public void encodeOIncomingIfKey(StaticTunnel mo, QAsnLspHop asn, IAsnTranslationContext context) {
        if (StringUtil.isEmpty((String)mo.getIncomingIfName())) {
            return;
        }
        Interface ifm = new Interface();
        AsnTranslatorUtil.copyDevAndVrId((VmfMO)mo, (VmfMO)ifm);
        ifm.setIfName(mo.getIncomingIfName());
        asn.oIncomingIfKey = this.ifmFdnParser.getUniResID((VmfMO)ifm);
    }

    public void encodeOOutgoingIfKey(StaticTunnel mo, QAsnLspHop asn, IAsnTranslationContext context) {
        if (StringUtil.isEmpty((String)mo.getOutgoingIfName())) {
            return;
        }
        Interface ifm = new Interface();
        AsnTranslatorUtil.copyDevAndVrId((VmfMO)mo, (VmfMO)ifm);
        ifm.setIfName(mo.getOutgoingIfName());
        asn.oOutgoingIfKey = this.ifmFdnParser.getUniResID((VmfMO)ifm);
    }

    private static class TNL_TYPE_ENUM {
        public static final Integer INTERFACE = 1;
        public static final Integer RING = 2;

        private TNL_TYPE_ENUM() {
        }
    }
}

