/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.vmf.adapter.mpls.translation.asn.spec;

import com.huawei.network.qasn.m_q_ip_tunnel_model.QAsnInterfaceMplsInfo;
import com.huawei.vmf.adapter.common.exception.VMFException;
import com.huawei.vmf.adapter.common.utilty.AsnUtil;
import com.huawei.vmf.adapter.common.utilty.CommonUtil;
import com.huawei.vmf.adapter.framework.notify.IMOChangeRecord;
import com.huawei.vmf.adapter.framework.notify.PropertyChangeItem;
import com.huawei.vmf.adapter.framework.translation.asn.AbstractAsnSpecTranslator;
import com.huawei.vmf.adapter.framework.translation.asn.AsnTranslatorUtil;
import com.huawei.vmf.adapter.framework.translation.asn.IAsnTranslationContext;
import com.huawei.vmf.adapter.fservice.ifm.fdn.InterfaceFdnParser;
import com.huawei.vmf.adapter.fservice.ifm.model.Interface;
import com.huawei.vmf.adapter.fservice.model.VmfMO;
import com.huawei.vmf.adapter.fservice.mpls.fdn.MplsInterfaceFdnParser;
import com.huawei.vmf.adapter.fservice.mpls.model.LdpInstance;
import com.huawei.vmf.adapter.fservice.mpls.model.LdpInterface;
import com.huawei.vmf.adapter.fservice.mpls.model.MplsInterface;
import com.huawei.vmf.adapter.fservice.mpls.model.RsvpInterface;
import com.huawei.vmf.adapter.fservice.mpls.model.TeLink;
import com.huawei.vmf.adapter.mpls.common.MplsUtil;
import com.huawei.vmf.adapter.mpls.dao.MplsDao;
import com.huawei.vmf.adapter.mpls.translation.asn.QAsnInterfaceMplsInfoTranslator;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import org.springframework.util.CollectionUtils;

public class QAsnInterfaceMplsInfoSpecTranslator
extends AbstractAsnSpecTranslator<QAsnInterfaceMplsInfoTranslator> {
    public static final int ADD = 1;
    public static final int DELETE = 0;

    public void decodeIInterfaceMpls(QAsnInterfaceMplsInfo asn, MplsInterface mo, IAsnTranslationContext context) throws VMFException {
        if (MplsUtil.isPtn()) {
            return;
        }
        String key = CommonUtil.composeTmpKey((Object[])new Object[]{mo.getDevID(), mo.getVrID(), mo.getInterfaceName()});
        context.addProperty(key, (Object)asn.iInterfaceMpls);
    }

    public void decodeIInterfaceMplsTe(QAsnInterfaceMplsInfo asn, MplsInterface mo, IAsnTranslationContext context) throws VMFException {
        if (MplsUtil.isPtn()) {
            return;
        }
        IMOChangeRecord record = context.getTransactionContext().addChangeRecord(TeLink.class);
        List teLinks = mo.getKeyRefMos(TeLink.class);
        if (CollectionUtils.isEmpty((Collection)teLinks)) {
            return;
        }
        TeLink ifm = (TeLink)teLinks.iterator().next();
        Collection ifms = MplsDao.newInstance().queryByKey(TeLink.class, Arrays.asList(ifm), false);
        if (1 == asn.iInterfaceMplsTe) {
            if (CollectionUtils.isEmpty((Collection)ifms)) {
                record.addCreate((Object)ifm);
            }
        } else if (!(0 != asn.iInterfaceMplsTe && 0 != asn.iInterfaceMpls || CollectionUtils.isEmpty((Collection)ifms))) {
            record.addDelete((Object)ifm);
        }
    }

    public void decodeKeyProperties(QAsnInterfaceMplsInfo asn, MplsInterface mo, IAsnTranslationContext context) throws VMFException {
        InterfaceFdnParser fdnParser = new InterfaceFdnParser();
        Interface temp = (Interface)fdnParser.getIndexMo(asn.iInterfaceKey);
        AsnTranslatorUtil.copyDevAndVrId((VmfMO)temp, (VmfMO)mo);
        mo.setInterfaceName(temp.getIfName());
        mo.setFdn(temp.getFdn());
    }

    public void decodeKeyRefMoRsvpInterface(QAsnInterfaceMplsInfo asn, MplsInterface mo, IAsnTranslationContext context) throws VMFException {
        RsvpInterface rsvpInterface = new RsvpInterface();
        rsvpInterface.setDevID(mo.getDevID());
        rsvpInterface.setVrID(mo.getVrID());
        rsvpInterface.setInterfaceName(mo.getInterfaceName());
        mo.addKeyRefMo((VmfMO)rsvpInterface);
    }

    public void decodeKeyRefMoTeLink(QAsnInterfaceMplsInfo asn, MplsInterface mo, IAsnTranslationContext context) throws VMFException {
        TeLink teLink = new TeLink();
        teLink.setDevID(mo.getDevID());
        teLink.setVrID(mo.getVrID());
        teLink.setInterfaceName(mo.getInterfaceName());
        mo.addKeyRefMo((VmfMO)teLink);
    }

    public void decodePoiInterfaceLDP(QAsnInterfaceMplsInfo asn, MplsInterface mo, IAsnTranslationContext context) throws VMFException {
        if (asn.poiInterfaceLDP == null) {
            return;
        }
        LdpInterface ldpInterface = new LdpInterface();
        ldpInterface.setDevID(mo.getDevID());
        ldpInterface.setVrID(mo.getVrID());
        ldpInterface.setVrfName("_public_");
        ldpInterface.setIfName(mo.getInterfaceName());
        LdpInstance ldpInstance = new LdpInstance();
        ldpInstance.setDevID(mo.getDevID());
        ldpInstance.setVrID(mo.getVrID());
        ldpInstance.setVrfName("_public_");
        ldpInstance.addLdpInterfaces((Collection)CommonUtil.genList((Object[])new LdpInterface[]{ldpInterface}));
        mo.addKeyRefMo((VmfMO)ldpInstance);
        IMOChangeRecord instanceRecord = context.getTransactionContext().addChangeRecord(LdpInstance.class);
        IMOChangeRecord ifmRecord = context.getTransactionContext().addChangeRecord(LdpInterface.class);
        MplsDao dao = MplsDao.newInstance();
        Collection ifms = dao.queryByKey(LdpInterface.class, Arrays.asList(ldpInterface), false);
        Collection instances = dao.queryByKey(LdpInstance.class, Arrays.asList(ldpInstance), false);
        if (1 == asn.poiInterfaceLDP) {
            if (!CollectionUtils.isEmpty((Collection)ifms)) {
                return;
            }
            if (CollectionUtils.isEmpty((Collection)instances)) {
                instanceRecord.addCreate((Object)ldpInstance);
            } else {
                instanceRecord.addModify((Object)ldpInstance, new PropertyChangeItem("ldpInterfaces"));
            }
            ifmRecord.addCreate((Object)ldpInterface);
        } else if (0 == asn.poRSVPTE || 0 == asn.iInterfaceMpls) {
            if (CollectionUtils.isEmpty((Collection)ifms) || CollectionUtils.isEmpty((Collection)instances)) {
                return;
            }
            instanceRecord.addModify((Object)ldpInstance, new PropertyChangeItem(LdpInstance.class.getName()));
            ifmRecord.addDelete((Object)ldpInterface);
        }
    }

    public void decodePoiLabelAdvertiseMode(QAsnInterfaceMplsInfo asn, MplsInterface mo, IAsnTranslationContext context) throws VMFException {
    }

    public void decodePoRSVPTE(QAsnInterfaceMplsInfo asn, MplsInterface mo, IAsnTranslationContext context) throws VMFException {
        if (asn.poRSVPTE == null) {
            return;
        }
        IMOChangeRecord record = context.getTransactionContext().addChangeRecord(RsvpInterface.class);
        RsvpInterface ifm = (RsvpInterface)mo.getKeyRefMos(RsvpInterface.class).iterator().next();
        Collection ifms = MplsDao.newInstance().queryByKey(RsvpInterface.class, Arrays.asList(ifm), false);
        if (1 == asn.poRSVPTE) {
            if (CollectionUtils.isEmpty((Collection)ifms)) {
                record.addCreate((Object)ifm);
            }
        } else if (!(0 != asn.poRSVPTE && 0 != asn.iInterfaceMpls || CollectionUtils.isEmpty((Collection)ifms))) {
            record.addDelete((Object)ifm);
        }
    }

    public void decodePoRSVPTEAuthMode(QAsnInterfaceMplsInfo asn, MplsInterface mo, IAsnTranslationContext context) throws VMFException {
    }

    public void decodePoRSVPTEHello(QAsnInterfaceMplsInfo asn, MplsInterface mo, IAsnTranslationContext context) throws VMFException {
        List rsvpIfms = mo.getKeyRefMos(RsvpInterface.class);
        if (!CollectionUtils.isEmpty((Collection)rsvpIfms)) {
            RsvpInterface rsvpInterface = (RsvpInterface)rsvpIfms.iterator().next();
            rsvpInterface.setHelloEnable(AsnTranslatorUtil.parseBoolean((Integer)asn.poRSVPTEHello, (String)"helloEnable", (Object[][])QAsnInterfaceMplsInfoTranslator.z_rsvpInterfaceMasks, (VmfMO)mo, (IAsnTranslationContext)context));
        }
    }

    public void decodeQAsnInterfaceMplsInfoSpecKeys(QAsnInterfaceMplsInfo asn, MplsInterface mo, IAsnTranslationContext context) throws VMFException {
        MplsInterfaceFdnParser fdnParser = new MplsInterfaceFdnParser();
        MplsInterface temp = (MplsInterface)fdnParser.getIndexMo(asn.iInterfaceKey);
        mo.setInterfaceName(temp.getInterfaceName());
    }

    public void encodeIInterfaceMpls(MplsInterface mo, QAsnInterfaceMplsInfo asn, IAsnTranslationContext context) throws VMFException {
    }

    public void encodeIInterfaceMplsTe(MplsInterface mo, QAsnInterfaceMplsInfo asn, IAsnTranslationContext context) throws VMFException {
        asn.iInterfaceMplsTe = AsnUtil.intValue((Boolean)mo.getMplsTEEnable());
    }

    public void encodeKeyProperties(MplsInterface mo, QAsnInterfaceMplsInfo asn, IAsnTranslationContext context) throws VMFException {
        InterfaceFdnParser fdnParser = new InterfaceFdnParser();
        asn.iInterfaceKey = fdnParser.getUniResID((VmfMO)MplsUtil.translate2Interface(mo));
    }

    public void encodeKeyRefMoRsvpInterface(MplsInterface mo, QAsnInterfaceMplsInfo asn, IAsnTranslationContext context) throws VMFException {
    }

    public void encodeKeyRefMoTeLink(MplsInterface mo, QAsnInterfaceMplsInfo asn, IAsnTranslationContext context) throws VMFException {
    }

    public void encodePoiInterfaceLDP(MplsInterface mo, QAsnInterfaceMplsInfo asn, IAsnTranslationContext context) throws VMFException {
        asn.poiInterfaceLDP = AsnUtil.intValue((Boolean)mo.getLdpEnable());
    }

    public void encodePoiLabelAdvertiseMode(MplsInterface mo, QAsnInterfaceMplsInfo asn, IAsnTranslationContext context) throws VMFException {
    }

    public void encodePoRSVPTE(MplsInterface mo, QAsnInterfaceMplsInfo asn, IAsnTranslationContext context) throws VMFException {
        asn.poRSVPTE = 1;
    }

    public void encodePoRSVPTEAuthMode(MplsInterface mo, QAsnInterfaceMplsInfo asn, IAsnTranslationContext context) throws VMFException {
    }

    public void encodePoRSVPTEHello(MplsInterface mo, QAsnInterfaceMplsInfo asn, IAsnTranslationContext context) throws VMFException {
        RsvpInterface rsvpInterface = (RsvpInterface)mo.getKeyRefMos(RsvpInterface.class).iterator().next();
        asn.poRSVPTEHello = AsnUtil.intValue((Boolean)rsvpInterface.getHelloEnable());
    }

    public void encodeITunnelStatus(MplsInterface mo, QAsnInterfaceMplsInfo asn, IAsnTranslationContext context) {
        if (!MplsUtil.isPtn()) {
            return;
        }
        asn.iTunnelStatus = AsnUtil.intValue((Boolean)mo.getMplsTEEnable());
    }

    public void decodeITunnelStatus(QAsnInterfaceMplsInfo asn, MplsInterface mo, IAsnTranslationContext context) throws VMFException {
        if (!MplsUtil.isPtn()) {
            return;
        }
        String key = CommonUtil.composeTmpKey((Object[])new Object[]{mo.getDevID(), mo.getVrID(), mo.getInterfaceName()});
        context.addProperty(key, (Object)asn.iTunnelStatus);
        boolean teEnable = AsnUtil.parseBoolean((Integer)asn.iTunnelStatus);
        mo.setMplsTEEnable(AsnTranslatorUtil.parseBoolean((Boolean)teEnable, (String)"mplsTEEnable", (Object[][])QAsnInterfaceMplsInfoTranslator.z_mplsInterfaceMasks, (VmfMO)mo, (IAsnTranslationContext)context));
        IMOChangeRecord record = context.getTransactionContext().addChangeRecord(TeLink.class);
        TeLink ifm = (TeLink)mo.getKeyRefMos(TeLink.class).iterator().next();
        Collection ifms = MplsDao.newInstance().queryByKey(TeLink.class, Arrays.asList(ifm), false);
        if (1 == asn.iTunnelStatus) {
            if (CollectionUtils.isEmpty((Collection)ifms)) {
                record.addCreate((Object)ifm);
            }
        } else if (0 == asn.iTunnelStatus && !CollectionUtils.isEmpty((Collection)ifms)) {
            record.addDelete((Object)ifm);
        }
    }

    private static final class PORSVPTE_ENUM {
        private static final int ENABLE = 1;

        private PORSVPTE_ENUM() {
        }
    }
}

