/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.vmf.adapter.mpls.translation.asn.spec;

import com.huawei.network.qasn.m_q_ip_tunnel_model.QAsnIgpAttr;
import com.huawei.vmf.adapter.common.exception.VMFException;
import com.huawei.vmf.adapter.common.utilty.AsnUtil;
import com.huawei.vmf.adapter.framework.transaction.Context;
import com.huawei.vmf.adapter.framework.translation.asn.AbstractAsnSpecTranslator;
import com.huawei.vmf.adapter.framework.translation.asn.AsnTranslatorUtil;
import com.huawei.vmf.adapter.framework.translation.asn.IAsnTranslationContext;
import com.huawei.vmf.adapter.fservice.model.VmfMO;
import com.huawei.vmf.adapter.fservice.mpls.model.RsvpTeTunnelAdv;
import com.huawei.vmf.adapter.mpls.translation.asn.QAsnIgpAttrTranslator;

public class QAsnIgpAttrSpecTranslator
extends AbstractAsnSpecTranslator<QAsnIgpAttrTranslator> {
    public void decodeIAdvertiseEnable(QAsnIgpAttr asn, RsvpTeTunnelAdv mo, IAsnTranslationContext context) throws VMFException {
        boolean advertiseEnable = false;
        if (1 == asn.iAdvertiseEnable) {
            advertiseEnable = true;
        }
        mo.setAdvertiseEnable(AsnTranslatorUtil.parseBoolean((Boolean)advertiseEnable, (String)"advertiseEnable", (Object[][])QAsnIgpAttrTranslator.z_rsvpTeTunnelAdvMasks, (VmfMO)mo, (IAsnTranslationContext)context));
    }

    public void decodeIAdvertiseHoldTime(QAsnIgpAttr asn, RsvpTeTunnelAdv mo, IAsnTranslationContext context) throws VMFException {
        long advertiseHoldTime = AsnUtil.parseOverflowIntToLong((int)asn.iAdvertiseHoldTime);
        mo.setAdvertiseHoldTime(AsnTranslatorUtil.longValue((Long)advertiseHoldTime, (String)"advertiseHoldTime", (Object[][])QAsnIgpAttrTranslator.z_qasnIgpAttrMasks, (VmfMO)mo, (IAsnTranslationContext)context));
    }

    public void decodeIIgpMetricValue(QAsnIgpAttr asn, RsvpTeTunnelAdv mo, IAsnTranslationContext context) throws VMFException {
        Context ctx = context.getTransactionContext();
        if (asn.iIgpMetricType == RsvpTeTunnelAdv.IGP_METRIC_TYPE_ENUM.ABSOLUTE) {
            mo.setAbsoluteIgpMetricValue(AsnTranslatorUtil.integerValue((int)asn.iIgpMetricValue, (String)"absoluteIgpMetricValue", (Object[][])QAsnIgpAttrTranslator.z_rsvpTeTunnelAdvMasks, (VmfMO)mo, (IAsnTranslationContext)context));
            AsnTranslatorUtil.addModifyDbNull((Context)ctx, (VmfMO)mo, (String[])new String[]{"relativeIgpMetricValue"});
        } else {
            mo.setRelativeIgpMetricValue(AsnTranslatorUtil.integerValue((int)asn.iIgpMetricValue, (String)"relativeIgpMetricValue", (Object[][])QAsnIgpAttrTranslator.z_rsvpTeTunnelAdvMasks, (VmfMO)mo, (IAsnTranslationContext)context));
            AsnTranslatorUtil.addModifyDbNull((Context)ctx, (VmfMO)mo, (String[])new String[]{"absoluteIgpMetricValue"});
        }
    }

    public void encodeIAdvertiseEnable(RsvpTeTunnelAdv mo, QAsnIgpAttr asn, IAsnTranslationContext context) throws VMFException {
        Boolean advertiseEnable = mo.getAdvertiseEnable();
        if (null == advertiseEnable) {
            return;
        }
        asn.iAdvertiseEnable = advertiseEnable != false ? 1 : 0;
    }

    public void encodeIAdvertiseHoldTime(RsvpTeTunnelAdv mo, QAsnIgpAttr asn, IAsnTranslationContext context) throws VMFException {
        asn.iAdvertiseHoldTime = AsnUtil.intValue((Long)mo.getAdvertiseHoldTime());
    }

    public void encodeIIgpMetricValue(RsvpTeTunnelAdv mo, QAsnIgpAttr asn, IAsnTranslationContext context) throws VMFException {
        asn.iIgpMetricValue = RsvpTeTunnelAdv.IGP_METRIC_TYPE_ENUM.ABSOLUTE.equals(mo.getIgpMetricType()) ? AsnUtil.intValue((Integer)mo.getAbsoluteIgpMetricValue()) : AsnUtil.intValue((Integer)mo.getRelativeIgpMetricValue());
    }

    private static final class IADVERTISEENABLE_ENUM {
        private static final int DISABLE = 0;
        private static final int ENABLE = 1;

        private IADVERTISEENABLE_ENUM() {
        }
    }
}

