/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.vmf.adapter.mpls.translation.asn.spec;

import com.huawei.network.qasn.m_q_ip_tunnel_model.QAsnHopLimitAttr;
import com.huawei.vmf.adapter.common.exception.VMFException;
import com.huawei.vmf.adapter.common.utilty.AsnUtil;
import com.huawei.vmf.adapter.framework.translation.asn.AbstractAsnSpecTranslator;
import com.huawei.vmf.adapter.framework.translation.asn.AsnTranslatorUtil;
import com.huawei.vmf.adapter.framework.translation.asn.IAsnTranslationContext;
import com.huawei.vmf.adapter.fservice.model.VmfMO;
import com.huawei.vmf.adapter.fservice.mpls.model.RsvpTeTunnel;
import com.huawei.vmf.adapter.fservice.mpls.model.RsvpTeTunnelAdv;
import com.huawei.vmf.adapter.fservice.mpls.model.RsvpTeTunnelPathConstraint;
import com.huawei.vmf.adapter.mpls.translation.asn.QAsnHopLimitAttrTranslator;

public class QAsnHopLimitAttrSpecTranslator
extends AbstractAsnSpecTranslator<QAsnHopLimitAttrTranslator> {
    private static final int BEST_EFFORT = 2;
    private static final int HOPLIMIT_ADD = 1;
    private static final int HOPLIMIT_DEL = 2;
    private static final int PRIMARY = 0;
    private static final int RI_ITYPE_CHG = 4;
    private static final int RI_IVALUE_CHG = 8;
    private static final int SECONDARY = 1;

    public void decodeIType(QAsnHopLimitAttr asn, RsvpTeTunnel mo, IAsnTranslationContext context) throws VMFException {
        RsvpTeTunnelPathConstraint constraint = this.getPathConstraint(mo);
    }

    public void decodeIValue(QAsnHopLimitAttr asn, RsvpTeTunnel mo, IAsnTranslationContext context) throws VMFException {
        RsvpTeTunnelAdv rsvpTeTunnelAdv = (RsvpTeTunnelAdv)context.getProperty(RsvpTeTunnelAdv.class.getName());
        RsvpTeTunnelPathConstraint constraint = mo.getRsvpTeTunnelPathConstraint();
        if (asn.iType == 0) {
            constraint.setPrimaryHopLimit(AsnTranslatorUtil.longValue((int)asn.iValue, (String)"primaryHopLimit", (Object[][])null, (VmfMO)constraint, (IAsnTranslationContext)context));
        } else if (asn.iType == 1) {
            if (Boolean.TRUE.equals(rsvpTeTunnelAdv.getHotStandbyEnable())) {
                constraint.setHotStandbyHopLimit(AsnTranslatorUtil.longValue((int)asn.iValue, (String)"hotStandbyHopLimit", (Object[][])null, (VmfMO)constraint, (IAsnTranslationContext)context));
            } else if (Boolean.TRUE.equals(rsvpTeTunnelAdv.getOrdinaryEnable())) {
                constraint.setOrdinaryHopLimit(AsnTranslatorUtil.longValue((int)asn.iValue, (String)"ordinaryHopLimit", (Object[][])null, (VmfMO)constraint, (IAsnTranslationContext)context));
            }
        } else if (asn.iType == 2) {
            constraint.setBestEffortHopLimit(AsnTranslatorUtil.longValue((int)asn.iValue, (String)"bestEffortHopLimit", (Object[][])null, (VmfMO)constraint, (IAsnTranslationContext)context));
        }
    }

    public void decodeKeyProperties(QAsnHopLimitAttr asn, RsvpTeTunnel mo, IAsnTranslationContext context) throws VMFException {
    }

    public void decodeQAsnHopLimitAttrSpecKeys(QAsnHopLimitAttr asn, RsvpTeTunnel mo, IAsnTranslationContext context) throws VMFException {
    }

    public void encodeIType(RsvpTeTunnel mo, QAsnHopLimitAttr asn, IAsnTranslationContext context) throws VMFException {
    }

    public void encodeIValue(RsvpTeTunnel mo, QAsnHopLimitAttr asn, IAsnTranslationContext context) throws VMFException {
        RsvpTeTunnelPathConstraint constraint = mo.getRsvpTeTunnelPathConstraint();
        if (constraint == null) {
            return;
        }
        if (null != constraint.getHotStandbyHopLimit()) {
            asn.iType = 1;
            asn.iValue = AsnUtil.intValue((Long)constraint.getHotStandbyHopLimit());
        }
        if (null != constraint.getPrimaryHopLimit()) {
            asn.iType = 0;
            asn.iValue = AsnUtil.intValue((Long)constraint.getPrimaryHopLimit());
        }
        if (null != constraint.getBestEffortHopLimit()) {
            asn.iType = 2;
            asn.iValue = AsnUtil.intValue((Long)constraint.getBestEffortHopLimit());
        }
    }

    public void encodeKeyProperties(RsvpTeTunnel mo, QAsnHopLimitAttr asn, IAsnTranslationContext context) throws VMFException {
    }

    private RsvpTeTunnelPathConstraint getPathConstraint(RsvpTeTunnel mo) {
        RsvpTeTunnelPathConstraint constraint = mo.getRsvpTeTunnelPathConstraint();
        if (constraint == null) {
            constraint = new RsvpTeTunnelPathConstraint();
            mo.setRsvpTeTunnelPathConstraint(constraint);
        }
        return mo.getRsvpTeTunnelPathConstraint();
    }
}

