/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.vmf.adapter.mpls.translation.asn.spec;

import com.huawei.network.qasn.m_q_ip_resquery.QAsnEmlNeMplsTunnelInfo;
import com.huawei.vmf.adapter.common.exception.VMFException;
import com.huawei.vmf.adapter.common.utilty.StringUtil;
import com.huawei.vmf.adapter.framework.translation.asn.IAsnTranslationContext;
import com.huawei.vmf.adapter.framework.translation.asn.OnlyEncodeAsnTranslator;
import com.huawei.vmf.adapter.fservice.ifm.model.Interface;
import com.huawei.vmf.adapter.fservice.mpls.model.RsvpTeTunnel;
import com.huawei.vmf.adapter.fservice.mpls.model.RsvpTeTunnelAdv;
import com.huawei.vmf.adapter.mpls.common.MplsUtil;
import java.math.BigInteger;
import java.util.Collection;
import org.springframework.util.CollectionUtils;

public class QAsnEmlNeMplsTunnelInfoTranslator
extends OnlyEncodeAsnTranslator<QAsnEmlNeMplsTunnelInfo, RsvpTeTunnel> {
    private static final BigInteger EXIST_BACKUP = BigInteger.valueOf(1L);
    private static final BigInteger NO_EXIST_BACKUP = BigInteger.valueOf(0L);

    public void encode(RsvpTeTunnel mo, QAsnEmlNeMplsTunnelInfo asn, IAsnTranslationContext context) throws VMFException {
        Interface ifm = null;
        ifm = CollectionUtils.isEmpty((Collection)mo.getKeyRefMos(Interface.class)) ? MplsUtil.translate2Interface(mo) : (Interface)mo.getKeyRefMos(Interface.class).iterator().next();
        asn.iIfIndex = this.bigIntegerValue(ifm.getIfIndex());
        RsvpTeTunnelAdv adv = mo.getRsvpTeTunnelAdv();
        if (adv != null) {
            boolean ordinaryEnable;
            boolean hotStandbyEnable = adv.getHotStandbyEnable() != null && adv.getHotStandbyEnable() != false;
            boolean bl = ordinaryEnable = adv.getOrdinaryEnable() != null && adv.getOrdinaryEnable() != false;
            asn.isExistBackup = hotStandbyEnable || ordinaryEnable ? EXIST_BACKUP : NO_EXIST_BACKUP;
        } else {
            asn.isExistBackup = this.bigIntegerValue(0);
        }
        asn.iTunnelID = this.bigIntegerValue(mo.getMplsTunnelIndex());
        asn.strTunnelName = StringUtil.globalByte((String)mo.getTunnelName());
    }

    public Class<QAsnEmlNeMplsTunnelInfo> getAsnClass() {
        return QAsnEmlNeMplsTunnelInfo.class;
    }

    public Class<RsvpTeTunnel> getMoClass() {
        return RsvpTeTunnel.class;
    }
}

