/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.vmf.adapter.mpls.translation.asn.spec;

import com.huawei.network.qasn.m_q_common.QAsnUniResID;
import com.huawei.network.qasn.m_q_common.QAsnUniResIDList;
import com.huawei.network.qasn.m_q_ip_tunnel_model.QAsnBypassAttr;
import com.huawei.vmf.adapter.common.exception.VMFException;
import com.huawei.vmf.adapter.framework.notify.IMOChangeRecord;
import com.huawei.vmf.adapter.framework.notify.PropertyChangeItem;
import com.huawei.vmf.adapter.framework.translation.asn.AbstractAsnSpecTranslator;
import com.huawei.vmf.adapter.framework.translation.asn.IAsnTranslationContext;
import com.huawei.vmf.adapter.fservice.ifm.fdn.InterfaceFdnParser;
import com.huawei.vmf.adapter.fservice.ifm.model.Interface;
import com.huawei.vmf.adapter.fservice.model.EOperationType;
import com.huawei.vmf.adapter.fservice.model.VmfMO;
import com.huawei.vmf.adapter.fservice.mpls.model.BypassProtectIF;
import com.huawei.vmf.adapter.fservice.mpls.model.RsvpTeTunnelAdv;
import com.huawei.vmf.adapter.fservice.service.IFdnParser;
import com.huawei.vmf.adapter.mpls.common.MplsUtil;
import com.huawei.vmf.adapter.mpls.dao.MplsDao;
import com.huawei.vmf.adapter.mpls.translation.asn.QAsnBypassAttrTranslator;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import org.springframework.util.CollectionUtils;

public class QAsnBypassAttrSpecTranslator
extends AbstractAsnSpecTranslator<QAsnBypassAttrTranslator> {
    private IFdnParser<Interface> fdnParser = new InterfaceFdnParser();

    public void decodeIProtectBandWidthType(QAsnBypassAttr asn, RsvpTeTunnelAdv mo, IAsnTranslationContext context) throws VMFException {
    }

    public void decodeLstProtectInterface(QAsnBypassAttr asn, RsvpTeTunnelAdv mo, IAsnTranslationContext context) {
        Collection<BypassProtectIF> dbBypassProtectIFs;
        List<BypassProtectIF> bypassProtectIFs = this.parseIfms(asn, mo);
        mo.addBypassProtectIFs(bypassProtectIFs);
        if (EOperationType.PREDEPLOY.equals((Object)context.getOperType()) || EOperationType.CREATE.equals((Object)context.getOperType())) {
            return;
        }
        if (asn.poOperMask == null || (asn.poOperMask & 8) == 0) {
            return;
        }
        try {
            dbBypassProtectIFs = this.queryIfms(mo);
        }
        catch (VMFException e) {
            this.getLogger().error("Query BypassProtectIF failed! RsvpTeTunnelAdv=" + mo, (Throwable)e);
            return;
        }
        IMOChangeRecord record = context.getTransactionContext().addChangeRecord(BypassProtectIF.class);
        for (BypassProtectIF bypassProtectIF : bypassProtectIFs) {
            if (dbBypassProtectIFs.contains(bypassProtectIF)) continue;
            record.addCreate((Object)bypassProtectIF);
        }
        for (BypassProtectIF dbBypassProtectIF : dbBypassProtectIFs) {
            if (bypassProtectIFs.contains(dbBypassProtectIF)) {
                mo.getBypassProtectIFs().remove(dbBypassProtectIF);
                continue;
            }
            record.addDelete((Object)dbBypassProtectIF);
            if (mo.getBypassProtectIFs() == null) {
                mo.setBypassProtectIFs(new ArrayList());
            }
            mo.getBypassProtectIFs().add(dbBypassProtectIF);
        }
        if (record.hasChanges()) {
            IMOChangeRecord advReord = context.getTransactionContext().addChangeRecord(RsvpTeTunnelAdv.class);
            advReord.addModify((Object)mo, new PropertyChangeItem("bypassProtectIFs"));
        }
    }

    public void encodeIProtectBandWidthType(RsvpTeTunnelAdv mo, QAsnBypassAttr asn, IAsnTranslationContext context) throws VMFException {
        asn.iProtectBandWidthType = -1;
        asn.iProtectBWUnlimit = -1;
        asn.iProtectBandWidth = -1;
    }

    public void encodeLstProtectInterface(RsvpTeTunnelAdv mo, QAsnBypassAttr asn, IAsnTranslationContext context) {
        Collection bypassProtectIFs = mo.getBypassProtectIFs();
        if (CollectionUtils.isEmpty((Collection)bypassProtectIFs)) {
            return;
        }
        for (BypassProtectIF bpifm : bypassProtectIFs) {
            if (null == bpifm) continue;
            Interface ifm = MplsUtil.translate2Interface(bpifm.getDevID(), bpifm.getVrID(), bpifm.getBypassProtectIFName());
            QAsnUniResID uniResID = this.fdnParser.getUniResID((VmfMO)ifm);
            if (null == asn.lstProtectInterface) {
                asn.lstProtectInterface = new QAsnUniResIDList();
            }
            asn.lstProtectInterface.add((Object)uniResID);
        }
    }

    protected List<BypassProtectIF> parseIfms(QAsnBypassAttr asn, RsvpTeTunnelAdv mo) {
        ArrayList<BypassProtectIF> bypassProtectIFs = new ArrayList<BypassProtectIF>();
        if (CollectionUtils.isEmpty((Collection)asn.lstProtectInterface)) {
            return bypassProtectIFs;
        }
        for (Object protectInterface : asn.lstProtectInterface) {
            if (null == protectInterface) continue;
            Interface indexMo = (Interface)this.fdnParser.getIndexMo((QAsnUniResID)protectInterface);
            BypassProtectIF bypassProtectIF = new BypassProtectIF();
            bypassProtectIF.setDevID(mo.getDevID());
            bypassProtectIF.setVrID(mo.getVrID());
            bypassProtectIF.setTunnelName(mo.getTunnelName());
            bypassProtectIF.setBypassProtectIFName(indexMo.getIfName());
            bypassProtectIFs.add(bypassProtectIF);
        }
        return bypassProtectIFs;
    }

    protected Collection<BypassProtectIF> queryIfms(RsvpTeTunnelAdv mo) throws VMFException {
        MplsDao dao = MplsDao.newInstance();
        BypassProtectIF condition = new BypassProtectIF();
        condition.setDevID(mo.getDevID());
        condition.setVrID(mo.getVrID());
        condition.setTunnelName(mo.getTunnelName());
        String[] fieldNames = new String[]{"devID", "vrID", "tunnelName"};
        Collection dbBypassProtectIFs = dao.queryByFields(BypassProtectIF.class, fieldNames, Arrays.asList(condition), false);
        return dbBypassProtectIFs;
    }
}

