/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.vmf.adapter.mpls.translation.asn.spec;

import com.huawei.network.qasn.m_q_ip_tunnel_model.QAsnBackupAttr;
import com.huawei.vmf.adapter.common.utilty.AsnUtil;
import com.huawei.vmf.adapter.framework.translation.asn.AbstractAsnSpecTranslator;
import com.huawei.vmf.adapter.framework.translation.asn.AsnTranslatorUtil;
import com.huawei.vmf.adapter.framework.translation.asn.IAsnTranslationContext;
import com.huawei.vmf.adapter.fservice.model.VmfMO;
import com.huawei.vmf.adapter.fservice.mpls.model.RsvpTeTunnelAdv;
import com.huawei.vmf.adapter.mpls.translation.asn.QAsnBackupAttrTranslator;

public class QAsnBackupAttrSpecTranslator
extends AbstractAsnSpecTranslator<QAsnBackupAttrTranslator> {
    public void decodeIBackupType(QAsnBackupAttr asn, RsvpTeTunnelAdv mo, IAsnTranslationContext context) {
        if (asn == null) {
            return;
        }
        mo.setHotStandbyEnable(AsnTranslatorUtil.parseBoolean((Boolean)(ASN_BACKUPTYPE.HOTSTANDBY == asn.iBackupType ? 1 : 0), (String)"hotStandbyEnable", (Object[][])QAsnBackupAttrTranslator.z_rsvpTeTunnelAdvMasks, (VmfMO)mo, (IAsnTranslationContext)context));
        mo.setOrdinaryEnable(AsnTranslatorUtil.parseBoolean((Boolean)(ASN_BACKUPTYPE.ORDINARY == asn.iBackupType ? 1 : 0), (String)"ordinaryEnable", (Object[][])QAsnBackupAttrTranslator.z_rsvpTeTunnelAdvMasks, (VmfMO)mo, (IAsnTranslationContext)context));
    }

    public void decodePoEnableOverlapPath(QAsnBackupAttr asn, RsvpTeTunnelAdv mo, IAsnTranslationContext context) {
        mo.setHsbPathOverlap(AsnTranslatorUtil.parseBoolean((Integer)asn.poEnableOverlapPath, (String)"hsbPathOverlap", (Object[][])QAsnBackupAttrTranslator.z_rsvpTeTunnelAdvMasks, (VmfMO)mo, (IAsnTranslationContext)context));
    }

    public void decodePoRevertiveMode(QAsnBackupAttr asn, RsvpTeTunnelAdv mo, IAsnTranslationContext context) {
        mo.setHsbRevertiveMode(AsnTranslatorUtil.integerValue((Integer)asn.poRevertiveMode, (String)"hsbRevertiveMode", (Object[][])QAsnBackupAttrTranslator.z_rsvpTeTunnelAdvMasks, (VmfMO)mo, (IAsnTranslationContext)context));
    }

    public void encodeIBackupType(RsvpTeTunnelAdv mo, QAsnBackupAttr asn, IAsnTranslationContext context) {
        Boolean hotStandbyEnable = mo.getHotStandbyEnable();
        Boolean ordinaryEnable = mo.getOrdinaryEnable();
        if (null == hotStandbyEnable || null == ordinaryEnable) {
            return;
        }
        if (!hotStandbyEnable.booleanValue() && !ordinaryEnable.booleanValue()) {
            asn.iBackupType = ASN_BACKUPTYPE.DISABLE;
        } else if (hotStandbyEnable.booleanValue()) {
            asn.iBackupType = ASN_BACKUPTYPE.HOTSTANDBY;
        } else if (ordinaryEnable.booleanValue()) {
            asn.iBackupType = ASN_BACKUPTYPE.ORDINARY;
        }
    }

    public void encodePoEnableOverlapPath(RsvpTeTunnelAdv mo, QAsnBackupAttr asn, IAsnTranslationContext context) {
        asn.poEnableOverlapPath = AsnUtil.intValue((Boolean)mo.getHsbPathOverlap());
    }

    public void encodePoRevertiveMode(RsvpTeTunnelAdv mo, QAsnBackupAttr asn, IAsnTranslationContext context) {
        asn.poRevertiveMode = Boolean.TRUE.equals(mo.getHotStandbyEnable()) ? Integer.valueOf(AsnUtil.intValue((Integer)mo.getHsbRevertiveMode())) : Integer.valueOf(-1);
    }

    public static final class REVERTIVEMMODE {
        public static final Integer NOT_REVERTIVE = 2;
        public static final Integer REVERTIVE = 1;
    }

    public static final class ASN_BACKUPTYPE {
        public static final Integer DISABLE = 0;
        public static final Integer HOTSTANDBY = 1;
        public static final Integer ORDINARY = 2;
    }
}

