/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.vmf.adapter.mpls.translation.asn.spec;

import com.huawei.network.qasn.m_q_ip_tunnel_model.QAsnAffinityAttr;
import com.huawei.vmf.adapter.common.exception.VMFException;
import com.huawei.vmf.adapter.common.utilty.AsnUtil;
import com.huawei.vmf.adapter.common.utilty.StringUtil;
import com.huawei.vmf.adapter.framework.translation.asn.AbstractAsnSpecTranslator;
import com.huawei.vmf.adapter.framework.translation.asn.IAsnTranslationContext;
import com.huawei.vmf.adapter.fservice.mpls.model.RsvpTeTunnel;
import com.huawei.vmf.adapter.fservice.mpls.model.RsvpTeTunnelAdv;
import com.huawei.vmf.adapter.fservice.mpls.model.RsvpTeTunnelPathConstraint;
import com.huawei.vmf.adapter.mpls.translation.asn.QAsnAffinityAttrTranslator;
import org.apache.commons.lang.ArrayUtils;

public class QAsnAffinityAttrSpecTranslator
extends AbstractAsnSpecTranslator<QAsnAffinityAttrTranslator> {
    private static final int HEX = 16;
    private static final String HEX_PREFIX = "0X";

    public void decodeIType(QAsnAffinityAttr asn, RsvpTeTunnel mo, IAsnTranslationContext context) throws VMFException {
    }

    public void decodeKeyProperties(QAsnAffinityAttr asn, RsvpTeTunnel mo, IAsnTranslationContext context) throws VMFException {
    }

    public void decodeQAsnAffinityAttrSpecKeys(QAsnAffinityAttr asn, RsvpTeTunnel mo, IAsnTranslationContext context) throws VMFException {
    }

    public void decodeStrMask(QAsnAffinityAttr asn, RsvpTeTunnel mo, IAsnTranslationContext context) throws VMFException {
    }

    public void decodeStrValue(QAsnAffinityAttr asn, RsvpTeTunnel mo, IAsnTranslationContext context) throws VMFException {
        if (ArrayUtils.isEmpty((byte[])asn.strValue) || ArrayUtils.isEmpty((byte[])asn.strMask) || -1 == asn.iType) {
            return;
        }
        RsvpTeTunnelPathConstraint constraint = mo.getRsvpTeTunnelPathConstraint();
        if (constraint == null) {
            constraint = new RsvpTeTunnelPathConstraint();
            mo.setRsvpTeTunnelPathConstraint(constraint);
        }
        String includeAny = String.valueOf(AsnUtil.parseInt((byte[])asn.strValue) & AsnUtil.parseInt((byte[])asn.strMask));
        String excludeAny = String.valueOf(~AsnUtil.parseInt((byte[])asn.strValue).intValue() & AsnUtil.parseInt((byte[])asn.strMask));
        if (1 == asn.iType) {
            constraint.setPrimaryIncludeAny(includeAny);
            constraint.setPrimaryExcludeAny(excludeAny);
        } else if (2 == asn.iType) {
            RsvpTeTunnelAdv rsvpTeTunnelAdv = mo.getRsvpTeTunnelAdv();
            if (null == rsvpTeTunnelAdv) {
                return;
            }
            Boolean hotStandbyEnable = rsvpTeTunnelAdv.getHotStandbyEnable();
            Boolean ordinaryEnable = rsvpTeTunnelAdv.getOrdinaryEnable();
            if (Boolean.TRUE.equals(hotStandbyEnable)) {
                constraint.setHotStandbyIncludeAny(includeAny);
                constraint.setHotStandbyExcludeAny(excludeAny);
            }
            if (Boolean.TRUE.equals(ordinaryEnable)) {
                constraint.setOrdinaryIncludeAny(includeAny);
                constraint.setOrdinaryExcludeAny(excludeAny);
            }
        } else if (3 == asn.iType) {
            constraint.setBestEffortIncludeAny(includeAny);
            constraint.setBestEffortExcludeAny(excludeAny);
        }
    }

    public void encodeIType(RsvpTeTunnel mo, QAsnAffinityAttr asn, IAsnTranslationContext context) throws VMFException {
    }

    public void encodeKeyProperties(RsvpTeTunnel mo, QAsnAffinityAttr asn, IAsnTranslationContext context) throws VMFException {
    }

    public void encodeStrMask(RsvpTeTunnel mo, QAsnAffinityAttr asn, IAsnTranslationContext context) throws VMFException {
    }

    public void encodeStrValue(RsvpTeTunnel mo, QAsnAffinityAttr asn, IAsnTranslationContext context) throws VMFException {
        RsvpTeTunnelPathConstraint constraint = mo.getRsvpTeTunnelPathConstraint();
        if (constraint == null) {
            return;
        }
        if (!StringUtil.isEmpty((String)constraint.getPrimaryIncludeAny()) && !StringUtil.isEmpty((String)constraint.getPrimaryExcludeAny())) {
            asn.iType = 1;
            asn.strValue = StringUtil.globalByte((String)constraint.getPrimaryIncludeAny());
            Long strMask = Long.valueOf(this.removeHexPrefix(constraint.getPrimaryIncludeAny()), 16) | Long.valueOf(this.removeHexPrefix(constraint.getPrimaryExcludeAny()), 16);
            asn.strMask = StringUtil.globalByte((String)this.addHexPrefix(Long.toHexString(strMask)));
        }
    }

    protected int parseInt(byte[] bytes) {
        String s = StringUtil.globalString((byte[])bytes);
        if (s.startsWith(HEX_PREFIX) || s.startsWith(HEX_PREFIX.toLowerCase())) {
            s = s.substring(2);
        }
        return Integer.parseInt(s, 16);
    }

    private String addHexPrefix(String str) {
        if (!StringUtil.isEmpty((String)str)) {
            return HEX_PREFIX + str;
        }
        return "0X0";
    }

    private RsvpTeTunnelPathConstraint getPathConstraint(RsvpTeTunnel mo) {
        RsvpTeTunnelPathConstraint constraint = mo.getRsvpTeTunnelPathConstraint();
        if (constraint == null) {
            constraint = new RsvpTeTunnelPathConstraint();
            mo.setRsvpTeTunnelPathConstraint(constraint);
        }
        return mo.getRsvpTeTunnelPathConstraint();
    }

    private String removeHexPrefix(String str) {
        if (StringUtil.isEmpty((String)str)) {
            return "";
        }
        if (str.toUpperCase().startsWith(HEX_PREFIX)) {
            return str.substring(HEX_PREFIX.length());
        }
        return str;
    }

    private static final class ITYPE_ENUM {
        private static final int BEST_EFFORT = 3;
        private static final int PRIMARY = 1;
        private static final int SECONDARY = 2;

        private ITYPE_ENUM() {
        }
    }
}

