/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.vmf.adapter.mpls.translation.asn;

import com.huawei.network.qasn.m_q_ip_tunnel_model.QAsnTunnelPGInfo;
import com.huawei.vmf.adapter.common.exception.VMFException;
import com.huawei.vmf.adapter.framework.translation.asn.AbstractAsnTranslator;
import com.huawei.vmf.adapter.framework.translation.asn.IAsnTranslationContext;
import com.huawei.vmf.adapter.fservice.model.EOperationType;
import com.huawei.vmf.adapter.fservice.model.VmfMO;
import com.huawei.vmf.adapter.fservice.mpls.model.TunnelGroup;
import com.huawei.vmf.adapter.mpls.translation.asn.spec.QAsnTunnelPGInfoSpecTranslator;

public class QAsnTunnelPGInfoTranslator
extends AbstractAsnTranslator<QAsnTunnelPGInfo, TunnelGroup> {
    public static final int RI_IHOLDOFFTIME_CHG = 1;
    public static final int RI_IREVERTIVEMODE_CHG = 8;
    public static final int RI_IWTRTIME_CHG = 16;
    public static final int UNDEPLOY_ID = 0;
    public static final Object[][] z_qasnTunnelPGInfoMasks = new Object[0][];
    public static final Object[][] z_rsvpTeTunnelMasks = new Object[0][];
    public static final Object[][] z_tunnelGroupMasks = new Object[][]{{"holdoffValue", 1}, {"wtrValue", 16}, {"revertiveMode", 8}};
    private static final int HALF_OF_ONE_MINITE = 30;
    private QAsnTunnelPGInfoSpecTranslator qasnTunnelPGInfoSpecTranslator = new QAsnTunnelPGInfoSpecTranslator();

    public void decode(QAsnTunnelPGInfo asn, TunnelGroup mo, IAsnTranslationContext context) throws VMFException {
        if (asn == null || mo == null) {
            return;
        }
        this.qasnTunnelPGInfoSpecTranslator.decodeKeyProperties(asn, mo, context);
        this.decodeTunnelGroup(asn, mo, context);
        this.qasnTunnelPGInfoSpecTranslator.decodeKeyRefMoRsvpTeTunnel(asn, mo, context);
        if (this.isDelete(0, asn.poOperMask, context)) {
            return;
        }
    }

    public void decodeTunnelGroup(QAsnTunnelPGInfo asn, TunnelGroup mo, IAsnTranslationContext context) throws VMFException {
        mo.setWorkingTunnel(this.strValue(asn.strPrimaryTunnelIfName));
        this.qasnTunnelPGInfoSpecTranslator.decodeQAsnTunnelPGInfoSpecKeys(asn, mo, context);
        context.addProperty(TunnelGroup.class.getName(), (Object)mo);
        EOperationType operType = this.setAddOrDeleted((VmfMO)mo, 0, 0, asn.poOperMask, context);
        if (operType.equals((Object)EOperationType.DELETE)) {
            return;
        }
        if (null == asn.poDeployStatus) {
            mo.setDeployStatus(Integer.valueOf(0));
        } else {
            mo.setDeployStatus(asn.poDeployStatus);
        }
        mo.setHoldoffValue(this.longValue(asn.iHoldOffTime, "holdoffValue", z_tunnelGroupMasks, (VmfMO)mo, context));
        mo.setSwitchResult(this.integerValue(asn.iSwitchResult, "switchResult", z_tunnelGroupMasks, (VmfMO)mo, context));
        mo.setWtrValue(Long.valueOf(this.longValue(asn.iWtrTime, "wtrValue", z_tunnelGroupMasks, (VmfMO)mo, context) / 30L));
        this.qasnTunnelPGInfoSpecTranslator.decodeIRevertiveMode(asn, mo, context);
        this.setChanged((VmfMO)mo, z_tunnelGroupMasks, asn.poOperMask, context);
    }

    public void encode(TunnelGroup mo, QAsnTunnelPGInfo asn, IAsnTranslationContext context) throws VMFException {
        if (asn == null || mo == null) {
            return;
        }
        context.addProperty(TunnelGroup.class.getName(), (Object)mo);
        this.qasnTunnelPGInfoSpecTranslator.encodeKeyProperties(mo, asn, context);
        this.encodeTunnelGroup(mo, asn, context);
        this.qasnTunnelPGInfoSpecTranslator.encodeKeyRefMoRsvpTeTunnel(mo, asn, context);
        this.qasnTunnelPGInfoSpecTranslator.encodeIRevertiveMode(mo, asn, context);
        asn.poOperResult = this.getAsnOperResult((VmfMO)mo, context);
    }

    public void encodeTunnelGroup(TunnelGroup mo, QAsnTunnelPGInfo asn, IAsnTranslationContext context) throws VMFException {
        int mask = 0;
        asn.strPrimaryTunnelIfName = this.getBytes(mo.getWorkingTunnel());
        asn.iHoldOffTime = this.intValue(mo.getHoldoffValue());
        asn.iSwitchResult = this.intValue(mo.getSwitchResult());
        asn.iWtrTime = this.intValue(mo.getWtrValue()) * 30;
        asn.iProtocolStatus = 1;
        asn.poOperMask = this.getOperMask(asn.poOperMask, mask |= this.setChangeMask((VmfMO)mo, context, z_tunnelGroupMasks));
    }

    public Class<QAsnTunnelPGInfo> getAsnClass() {
        return QAsnTunnelPGInfo.class;
    }

    public Class<TunnelGroup> getMoClass() {
        return TunnelGroup.class;
    }
}

