/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.vmf.adapter.mpls.translation.asn;

import com.huawei.network.qasn.m_q_ip_tunnel_model.QAsnTunnelOAMInfo;
import com.huawei.vmf.adapter.common.exception.VMFException;
import com.huawei.vmf.adapter.framework.notify.IMOChangeRecord;
import com.huawei.vmf.adapter.framework.translation.asn.AbstractAsnTranslator;
import com.huawei.vmf.adapter.framework.translation.asn.IAsnTranslationContext;
import com.huawei.vmf.adapter.fservice.model.EOperationType;
import com.huawei.vmf.adapter.fservice.model.VmfMO;
import com.huawei.vmf.adapter.fservice.mpls.model.MplsOamTunnel;
import com.huawei.vmf.adapter.mpls.translation.asn.spec.QAsnTunnelOAMInfoSpecTranslator;
import java.util.Arrays;

public class QAsnTunnelOAMInfoTranslator
extends AbstractAsnTranslator<QAsnTunnelOAMInfo, MplsOamTunnel> {
    public static final Object[][] z_mplsOamTunnelMasks = new Object[0][];
    public static final Object[][] z_qasnTunnelOAMInfoMasks = new Object[0][];
    private QAsnTunnelOAMInfoSpecTranslator qasnTunnelOAMInfoSpecTranslator = new QAsnTunnelOAMInfoSpecTranslator();

    public void decode(QAsnTunnelOAMInfo asn, MplsOamTunnel mo, IAsnTranslationContext context) throws VMFException {
        if (asn == null || mo == null) {
            return;
        }
        this.qasnTunnelOAMInfoSpecTranslator.decodeKeyProperties(asn, mo, context);
        EOperationType operType = this.setAddOrDeleted((VmfMO)mo, 0, 0, asn.poOperMask, context);
        if (operType.equals((Object)EOperationType.DELETE)) {
            return;
        }
        this.decodeMplsOamTunnel(asn, mo, context);
        this.qasnTunnelOAMInfoSpecTranslator.decodeICVFFDStatus(asn, mo, context);
        if (operType.equals((Object)EOperationType.MODIFY)) {
            IMOChangeRecord changeRecord = context.getTransactionContext().getChangeRecord(MplsOamTunnel.class);
            changeRecord.addModify((Object)mo, Arrays.asList("oamActiveState", "detectMode", "localInvalidTime", "detectPktType", "detectFrequence", "oamLossSd", "oamLossSf", "bdiFrequence", "receiveEnable", "sendEnable"));
        }
    }

    public void decodeMplsOamTunnel(QAsnTunnelOAMInfo asn, MplsOamTunnel mo, IAsnTranslationContext context) throws VMFException {
        mo.setDetectMode(this.integerValue(asn.iDectectMode, "detectMode", z_mplsOamTunnelMasks, (VmfMO)mo, context));
        mo.setLocalInvalidTime(this.longValue(asn.iOvertime, "localInvalidTime", z_mplsOamTunnelMasks, (VmfMO)mo, context));
        mo.setDetectPktType(this.integerValue(asn.iDectectType, "detectPktType", z_mplsOamTunnelMasks, (VmfMO)mo, context));
        mo.setDetectFrequence(this.integerValue(asn.iFrequency, "detectFrequence", z_mplsOamTunnelMasks, (VmfMO)mo, context));
        mo.setOamLossSd(this.integerValue(asn.iSDValue, "oamLossSd", z_mplsOamTunnelMasks, (VmfMO)mo, context));
        mo.setOamLossSf(this.integerValue(asn.iSFValue, "oamLossSf", z_mplsOamTunnelMasks, (VmfMO)mo, context));
        mo.setBdiFrequence(this.integerValue(asn.iBDIFrequency, "bdiFrequence", z_mplsOamTunnelMasks, (VmfMO)mo, context));
        mo.setOamActiveState(this.integerValue(asn.iOAMEnable, "oamActiveState", z_mplsOamTunnelMasks, (VmfMO)mo, context));
    }

    public void encode(MplsOamTunnel mo, QAsnTunnelOAMInfo asn, IAsnTranslationContext context) throws VMFException {
        if (asn == null || mo == null) {
            return;
        }
        this.qasnTunnelOAMInfoSpecTranslator.encodeKeyProperties(mo, asn, context);
        this.encodeMplsOamTunnel(mo, asn, context);
        this.qasnTunnelOAMInfoSpecTranslator.encodeIOAMEnable(mo, asn, context);
        this.qasnTunnelOAMInfoSpecTranslator.encodeICVFFDStatus(mo, asn, context);
        asn.poIDeployStatus = mo.getDeployStatus();
        asn.poIRunStatus = mo.getLocalDetectStatus();
        asn.poOperResult = this.getAsnOperResult((VmfMO)mo, context);
    }

    public void encodeMplsOamTunnel(MplsOamTunnel mo, QAsnTunnelOAMInfo asn, IAsnTranslationContext context) throws VMFException {
        int mask = 0;
        asn.iDectectMode = this.intValue(mo.getDetectMode());
        asn.iOvertime = this.intValue(mo.getLocalInvalidTime());
        asn.iDectectType = this.intValue(mo.getDetectPktType());
        asn.iFrequency = this.intValue(mo.getDetectFrequence());
        asn.iSDValue = this.intValue(mo.getOamLossSd());
        asn.iSFValue = this.intValue(mo.getOamLossSf());
        asn.iBDIFrequency = this.intValue(mo.getBdiFrequence());
        asn.poOperMask = this.getOperMask(asn.poOperMask, mask |= this.setChangeMask((VmfMO)mo, context, z_mplsOamTunnelMasks));
    }

    public Class<QAsnTunnelOAMInfo> getAsnClass() {
        return QAsnTunnelOAMInfo.class;
    }

    public Class<MplsOamTunnel> getMoClass() {
        return MplsOamTunnel.class;
    }
}

