/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.vmf.adapter.mpls.translation.asn;

import com.huawei.network.qasn.m_q_ip_tunnel_model.QAsnTunnelKeyInfo;
import com.huawei.vmf.adapter.common.exception.VMFException;
import com.huawei.vmf.adapter.framework.translation.asn.AbstractAsnTranslator;
import com.huawei.vmf.adapter.framework.translation.asn.IAsnTranslationContext;
import com.huawei.vmf.adapter.fservice.model.EOperationType;
import com.huawei.vmf.adapter.fservice.model.VmfMO;
import com.huawei.vmf.adapter.fservice.mpls.model.RsvpTeTunnel;
import com.huawei.vmf.adapter.mpls.translation.asn.spec.QAsnTunnelKeyInfoSpecTranslator;

public class QAsnTunnelKeyInfoTranslator
extends AbstractAsnTranslator<QAsnTunnelKeyInfo, RsvpTeTunnel> {
    public static final Object[][] z_qasnTunnelKeyInfoMasks = new Object[0][];
    public static final Object[][] z_rsvpTeTunnelMasks = new Object[0][];
    private QAsnTunnelKeyInfoSpecTranslator qasnTunnelKeyInfoSpecTranslator = new QAsnTunnelKeyInfoSpecTranslator();

    public void decode(QAsnTunnelKeyInfo asn, RsvpTeTunnel mo, IAsnTranslationContext context) throws VMFException {
        if (asn == null || mo == null) {
            return;
        }
        this.qasnTunnelKeyInfoSpecTranslator.decodeKeyProperties(asn, mo, context);
        this.decodeRsvpTeTunnel(asn, mo, context);
        if (this.isDelete(0, null, context)) {
            return;
        }
        this.qasnTunnelKeyInfoSpecTranslator.decodeIPosition(asn, mo, context);
    }

    public void decodeRsvpTeTunnel(QAsnTunnelKeyInfo asn, RsvpTeTunnel mo, IAsnTranslationContext context) throws VMFException {
        mo.setTunnelName(this.strValue(asn.strTunnelName));
        context.addProperty(RsvpTeTunnel.class.getName(), (Object)mo);
        EOperationType operType = this.setAddOrDeleted((VmfMO)mo, 0, 0, context);
        if (operType.equals((Object)EOperationType.DELETE)) {
            return;
        }
        mo.setMplsTunnelIngressLSRId(this.strValue(asn.strIngressLsrID, "mplsTunnelIngressLSRId", z_rsvpTeTunnelMasks, (VmfMO)mo, context));
        mo.setMplsTunnelEgressLSRId(this.strValue(asn.strEgressLsrID, "mplsTunnelEgressLSRId", z_rsvpTeTunnelMasks, (VmfMO)mo, context));
        mo.setMplsTunnelIndex(this.integerValue(asn.iTunnelID, "mplsTunnelIndex", z_rsvpTeTunnelMasks, (VmfMO)mo, context));
    }

    public void encode(RsvpTeTunnel mo, QAsnTunnelKeyInfo asn, IAsnTranslationContext context) throws VMFException {
        if (asn == null || mo == null) {
            return;
        }
        this.qasnTunnelKeyInfoSpecTranslator.encodeKeyProperties(mo, asn, context);
        this.encodeRsvpTeTunnel(mo, asn, context);
        this.qasnTunnelKeyInfoSpecTranslator.encodeIPosition(mo, asn, context);
    }

    public void encodeRsvpTeTunnel(RsvpTeTunnel mo, QAsnTunnelKeyInfo asn, IAsnTranslationContext context) throws VMFException {
        int mask = 0;
        asn.strTunnelName = this.getBytes(mo.getTunnelName());
        asn.strIngressLsrID = this.getBytes(mo.getMplsTunnelIngressLSRId());
        asn.strEgressLsrID = this.getBytes(mo.getMplsTunnelEgressLSRId());
        asn.iTunnelID = this.intValue(mo.getMplsTunnelIndex());
        asn.iSignalType = this.translateSignalType(mo.getSignalProtocol());
        mask |= this.setChangeMask((VmfMO)mo, context, z_rsvpTeTunnelMasks);
    }

    public Class<QAsnTunnelKeyInfo> getAsnClass() {
        return QAsnTunnelKeyInfo.class;
    }

    public Class<RsvpTeTunnel> getMoClass() {
        return RsvpTeTunnel.class;
    }

    private int translateSignalType(Integer sigalProtocol) {
        if (sigalProtocol == RsvpTeTunnel.SIGNAL_PROTOCOL_ENUM.CRSTATIC) {
            return 1;
        }
        if (sigalProtocol == RsvpTeTunnel.SIGNAL_PROTOCOL_ENUM.RSVPTE) {
            return 4;
        }
        return 0;
    }
}

