/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.vmf.adapter.mpls.translation.asn;

import com.huawei.network.qasn.m_q_ip_tunnel_model.QAsnTunnelIdentifier;
import com.huawei.vmf.adapter.common.exception.VMFException;
import com.huawei.vmf.adapter.framework.translation.asn.AbstractAsnTranslator;
import com.huawei.vmf.adapter.framework.translation.asn.IAsnTranslationContext;
import com.huawei.vmf.adapter.fservice.model.EOperationType;
import com.huawei.vmf.adapter.fservice.model.VmfMO;
import com.huawei.vmf.adapter.fservice.mpls.model.RsvpTeLsp;
import com.huawei.vmf.adapter.mpls.translation.asn.spec.QAsnTunnelIdentifierSpecTranslator;

public class QAsnTunnelIdentifierTranslator
extends AbstractAsnTranslator<QAsnTunnelIdentifier, RsvpTeLsp> {
    public static final Object[][] z_qasnTunnelIdentifierMasks = new Object[0][];
    public static final Object[][] z_rsvpTeLspMasks = new Object[0][];
    private QAsnTunnelIdentifierSpecTranslator qasnTunnelIdentifierSpecTranslator = new QAsnTunnelIdentifierSpecTranslator();

    public void decode(QAsnTunnelIdentifier asn, RsvpTeLsp mo, IAsnTranslationContext context) throws VMFException {
        if (asn == null || mo == null) {
            return;
        }
        this.qasnTunnelIdentifierSpecTranslator.decodeKeyProperties(asn, mo, context);
        this.decodeRsvpTeLsp(asn, mo, context);
        if (this.isDelete(0, null, context)) {
            return;
        }
        this.qasnTunnelIdentifierSpecTranslator.decodeITransportType(asn, mo, context);
        this.qasnTunnelIdentifierSpecTranslator.decodeISignalType(asn, mo, context);
        this.qasnTunnelIdentifierSpecTranslator.decodePoPosition(asn, mo, context);
    }

    public void decodeRsvpTeLsp(QAsnTunnelIdentifier asn, RsvpTeLsp mo, IAsnTranslationContext context) throws VMFException {
        mo.setMplsTunnelIngressLSRId(this.strValue(asn.poIngressLsrID));
        mo.setMplsTunnelEgressLSRId(this.strValue(asn.poEgressLsrID));
        mo.setMplsSessionID(Integer.valueOf(this.intValue(asn.poTunnelID)));
        this.qasnTunnelIdentifierSpecTranslator.decodeQAsnTunnelIdentifierSpecKeys(asn, mo, context);
        context.addProperty(RsvpTeLsp.class.getName(), (Object)mo);
        EOperationType operType = this.setAddOrDeleted((VmfMO)mo, 0, 0, context);
        if (operType.equals((Object)EOperationType.DELETE)) {
            return;
        }
        mo.setTunnelName(this.strValue(asn.poTnlIfName, "tunnelName", z_rsvpTeLspMasks, (VmfMO)mo, context));
    }

    public void encode(RsvpTeLsp mo, QAsnTunnelIdentifier asn, IAsnTranslationContext context) throws VMFException {
        if (asn == null || mo == null) {
            return;
        }
        this.qasnTunnelIdentifierSpecTranslator.encodeKeyProperties(mo, asn, context);
        this.encodeRsvpTeLsp(mo, asn, context);
        this.qasnTunnelIdentifierSpecTranslator.encodeITransportType(mo, asn, context);
        this.qasnTunnelIdentifierSpecTranslator.encodeISignalType(mo, asn, context);
        this.qasnTunnelIdentifierSpecTranslator.encodePoPosition(mo, asn, context);
    }

    public void encodeRsvpTeLsp(RsvpTeLsp mo, QAsnTunnelIdentifier asn, IAsnTranslationContext context) throws VMFException {
        int mask = 0;
        asn.poIngressLsrID = this.getBytes(mo.getMplsTunnelIngressLSRId());
        asn.poEgressLsrID = this.getBytes(mo.getMplsTunnelEgressLSRId());
        asn.poTunnelID = this.intValue(mo.getMplsSessionID());
        asn.poTnlIfName = this.getBytes(mo.getTunnelName());
        mask |= this.setChangeMask((VmfMO)mo, context, z_rsvpTeLspMasks);
    }

    public Class<QAsnTunnelIdentifier> getAsnClass() {
        return QAsnTunnelIdentifier.class;
    }

    public Class<RsvpTeLsp> getMoClass() {
        return RsvpTeLsp.class;
    }
}

