/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.vmf.adapter.mpls.translation.asn;

import com.huawei.network.qasn.m_q_ip_tunnel_model.QAsnTunnelBase;
import com.huawei.vmf.adapter.common.exception.VMFException;
import com.huawei.vmf.adapter.framework.translation.asn.AbstractAsnTranslator;
import com.huawei.vmf.adapter.framework.translation.asn.IAsnTranslationContext;
import com.huawei.vmf.adapter.fservice.model.EOperationType;
import com.huawei.vmf.adapter.fservice.model.VmfMO;
import com.huawei.vmf.adapter.fservice.mpls.model.RsvpTeTunnel;
import com.huawei.vmf.adapter.mpls.translation.asn.spec.QAsnTunnelBaseSpecTranslator;

public class QAsnTunnelBaseTranslator
extends AbstractAsnTranslator<QAsnTunnelBase, RsvpTeTunnel> {
    public static final int RI_IBACKUPSTATUS_CHG = 128;
    public static final int RI_ICOMMIT_CHG = 8;
    public static final int RI_IDEPLOYSTATUS_CHG = 16;
    public static final int RI_IENABLESTATUS_CHG = 2;
    public static final int RI_IFRRSTATUS_CHG = 32;
    public static final int RI_IPOLICYBINDING_CHG = 64;
    public static final int RI_IRUNSTATUS_CHG = 4;
    public static final int RI_STRDESCRIPTION_CHG = 1;
    public static final int RI_STRUSERLABEL_CHG = 256;
    public static final Object[][] z_qasnTunnelBaseMasks = new Object[][]{{"strDescription", 1}, {"iEnableStatus", 2}, {"iRunStatus", 4}, {"iCommit", 8}, {"iDeployStatus", 16}, {"iFRRStatus", 32}, {"iPolicyBinding", 64}, {"iBackupStatus", 128}, {"userLabel", 256}};
    public static final Object[][] z_rsvpTeTunnelMasks = new Object[][]{{"adminStatus", 2}, {"operStatus", 4}, {"resvForBinding", 64}, {"tunnelState", 128}};
    private QAsnTunnelBaseSpecTranslator qasnTunnelBaseSpecTranslator = new QAsnTunnelBaseSpecTranslator();

    public void decode(QAsnTunnelBase asn, RsvpTeTunnel mo, IAsnTranslationContext context) throws VMFException {
        if (asn == null || mo == null) {
            return;
        }
        this.qasnTunnelBaseSpecTranslator.decodeKeyProperties(asn, mo, context);
        this.decodeRsvpTeTunnel(asn, mo, context);
        if (this.isDelete(0, asn.poOperMask, context)) {
            return;
        }
        this.qasnTunnelBaseSpecTranslator.decodeStrDestinationIP(asn, mo, context);
        this.qasnTunnelBaseSpecTranslator.decodeIBackupStatus(asn, mo, context);
        this.qasnTunnelBaseSpecTranslator.decodePoTnlIfIP(asn, mo, context);
    }

    public void decodeRsvpTeTunnel(QAsnTunnelBase asn, RsvpTeTunnel mo, IAsnTranslationContext context) throws VMFException {
        mo.setTunnelName(this.strValue(asn.strTunnelName));
        context.addProperty(RsvpTeTunnel.class.getName(), (Object)mo);
        EOperationType operType = this.setAddOrDeleted((VmfMO)mo, 0, 0, asn.poOperMask, context);
        if (operType.equals((Object)EOperationType.DELETE)) {
            return;
        }
        mo.setMplsTunnelIngressLSRId(this.strValue(asn.strIngressLsrID, "mplsTunnelIngressLSRId", z_rsvpTeTunnelMasks, (VmfMO)mo, context));
        mo.setMplsTunnelIndex(this.integerValue(asn.iTunnelID, "mplsTunnelIndex", z_rsvpTeTunnelMasks, (VmfMO)mo, context));
        mo.setAdminStatus(this.integerValue(asn.iEnableStatus, "adminStatus", z_rsvpTeTunnelMasks, (VmfMO)mo, context));
        mo.setOperStatus(this.integerValue(asn.iRunStatus, "operStatus", z_rsvpTeTunnelMasks, (VmfMO)mo, context));
        mo.setResvForBinding(this.parseBoolean(asn.iPolicyBinding, "resvForBinding", z_rsvpTeTunnelMasks, (VmfMO)mo, context));
        mo.setUserDefinedName(this.strValue(asn.poTunnelAliasName, "userDefinedName", z_rsvpTeTunnelMasks, (VmfMO)mo, context));
        mo.setDeployStatus(this.integerValue(asn.iDeployStatus, "iDeployStatus", null, (VmfMO)mo, context));
        if (EOperationType.PREDEPLOY.equals((Object)context.getOperType()) && 1 != asn.iDeployStatus) {
            mo.setDeployStatus(Integer.valueOf(0));
        }
        mo.setUserLabel(this.strValue(asn.userLabel, "userLabel", null, (VmfMO)mo, context));
        this.setChanged((VmfMO)mo, z_rsvpTeTunnelMasks, asn.poOperMask, context);
    }

    public void encode(RsvpTeTunnel mo, QAsnTunnelBase asn, IAsnTranslationContext context) throws VMFException {
        if (asn == null || mo == null) {
            return;
        }
        this.qasnTunnelBaseSpecTranslator.encodeKeyProperties(mo, asn, context);
        this.encodeRsvpTeTunnel(mo, asn, context);
        this.qasnTunnelBaseSpecTranslator.encodeITransportType(mo, asn, context);
        this.qasnTunnelBaseSpecTranslator.encodeISignalType(mo, asn, context);
        this.qasnTunnelBaseSpecTranslator.encodeStrEgressLsrID(mo, asn, context);
        this.qasnTunnelBaseSpecTranslator.encodeIPosition(mo, asn, context);
        this.qasnTunnelBaseSpecTranslator.encodeIBindingTnlIf(mo, asn, context);
        this.qasnTunnelBaseSpecTranslator.encodeIFRRStatus(mo, asn, context);
        this.qasnTunnelBaseSpecTranslator.encodeIBackupStatus(mo, asn, context);
        this.qasnTunnelBaseSpecTranslator.encodePoDirection(mo, asn, context);
        this.qasnTunnelBaseSpecTranslator.encodePoTnlIfIP(mo, asn, context);
        asn.poOperResult = this.getAsnOperResult((VmfMO)mo, context);
    }

    public void encodeRsvpTeTunnel(RsvpTeTunnel mo, QAsnTunnelBase asn, IAsnTranslationContext context) throws VMFException {
        int mask = 0;
        asn.strTunnelName = this.getBytes(mo.getTunnelName());
        asn.strIngressLsrID = this.getBytes(mo.getMplsTunnelIngressLSRId());
        asn.iTunnelID = this.intValue(mo.getMplsTunnelIndex());
        asn.strDestinationIP = this.getBytes(mo.getMplsTunnelEgressLSRId());
        asn.iEnableStatus = this.intValue(mo.getAdminStatus());
        asn.iRunStatus = this.intValue(mo.getOperStatus());
        asn.iPolicyBinding = this.intValue(mo.getResvForBinding());
        asn.poTunnelAliasName = this.getBytes(mo.getUserDefinedName());
        asn.poOperMask = this.getOperMask(asn.poOperMask, mask |= this.setChangeMask((VmfMO)mo, context, z_rsvpTeTunnelMasks));
        asn.iDeployStatus = mo.getDeployStatus();
        asn.userLabel = this.getBytes(mo.getUserLabel());
    }

    public Class<QAsnTunnelBase> getAsnClass() {
        return QAsnTunnelBase.class;
    }

    public Class<RsvpTeTunnel> getMoClass() {
        return RsvpTeTunnel.class;
    }
}

