/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.vmf.adapter.mpls.translation.asn;

import com.huawei.network.qasn.m_q_ip_tunnel_model.QAsnTunnelBase;
import com.huawei.vmf.adapter.common.exception.VMFException;
import com.huawei.vmf.adapter.framework.translation.asn.AbstractAsnTranslator;
import com.huawei.vmf.adapter.framework.translation.asn.IAsnTranslationContext;
import com.huawei.vmf.adapter.fservice.model.EOperationType;
import com.huawei.vmf.adapter.fservice.model.VmfMO;
import com.huawei.vmf.adapter.fservice.mpls.model.RsvpTeTunnel;
import com.huawei.vmf.adapter.fservice.mpls.model.StaticTunnel;
import com.huawei.vmf.adapter.mpls.translation.asn.spec.QAsnTunnelBaseForStaticTunnelSpecTranslator;

public class QAsnTunnelBaseForStaticTunnelTranslator
extends AbstractAsnTranslator<QAsnTunnelBase, StaticTunnel> {
    public static final int RI_IBACKUPSTATUS_CHG = 128;
    public static final int RI_ICOMMIT_CHG = 8;
    public static final int RI_IDEPLOYSTATUS_CHG = 16;
    public static final int RI_IENABLESTATUS_CHG = 2;
    public static final int RI_IFRRSTATUS_CHG = 32;
    public static final int RI_IPOLICYBINDING_CHG = 64;
    public static final int RI_IRUNSTATUS_CHG = 4;
    public static final int RI_STRDESCRIPTION_CHG = 1;
    public static final int RI_STRUSERLABEL_CHG = 256;
    public static final Object[][] z_qasnTunnelBaseMasks = new Object[][]{{"strDescription", 1}, {"iEnableStatus", 2}, {"iRunStatus", 4}, {"iCommit", 8}, {"iDeployStatus", 16}, {"iFRRStatus", 32}, {"iPolicyBinding", 64}, {"iBackupStatus", 128}, {"userLabel", 256}};
    public static final Object[][] z_staticTunnelMasks = new Object[][]{{"tunnelDescription", 1}, {"tunnelEnableStatus", 2}, {"iRunStatus", 4}, {"iCommit", 8}, {"deployStatus", 16}, {"iFRRStatus", 32}, {"iPolicyBinding", 64}, {"iBackupStatus", 128}, {"userLabel", 256}};
    private QAsnTunnelBaseForStaticTunnelSpecTranslator qasnTunnelBaseSpecTranslator = new QAsnTunnelBaseForStaticTunnelSpecTranslator();

    public void decode(QAsnTunnelBase asn, StaticTunnel mo, IAsnTranslationContext context) throws VMFException {
        if (asn == null || mo == null) {
            return;
        }
        this.qasnTunnelBaseSpecTranslator.decodeKeyProperties(asn, mo, context);
        this.decodeStaticTunnel(asn, mo, context);
        if (this.isDelete(0, asn.poOperMask, context)) {
            return;
        }
        this.qasnTunnelBaseSpecTranslator.decodeITransportType(asn, mo, context);
        this.qasnTunnelBaseSpecTranslator.decodeISignalType(asn, mo, context);
        this.qasnTunnelBaseSpecTranslator.decodeIPosition(asn, mo, context);
        this.qasnTunnelBaseSpecTranslator.decodeIBindingTnlIf(asn, mo, context);
        this.qasnTunnelBaseSpecTranslator.decodeStrDescription(asn, mo, context);
        this.qasnTunnelBaseSpecTranslator.decodeUserLabel(asn, mo, context);
        this.qasnTunnelBaseSpecTranslator.decodePoDirection(asn, mo, context);
        this.setChanged((VmfMO)mo, z_staticTunnelMasks, asn.poOperMask, context);
    }

    public void decodeStaticTunnel(QAsnTunnelBase asn, StaticTunnel mo, IAsnTranslationContext context) throws VMFException {
        context.addProperty(StaticTunnel.class.getName(), (Object)mo);
        mo.setIngressLsrId(this.strValue(asn.strIngressLsrID, "ingressLsrId", z_staticTunnelMasks, (VmfMO)mo, context));
        mo.setEgressLsrId(this.strValue(asn.strEgressLsrID, "egressLsrId", z_staticTunnelMasks, (VmfMO)mo, context));
        mo.setTunnelId(this.integerValue(asn.iTunnelID, "tunnelId", z_staticTunnelMasks, (VmfMO)mo, context));
        mo.setLsrRole(this.integerValue(asn.iPosition, "lsrRole", z_staticTunnelMasks, (VmfMO)mo, context));
        this.qasnTunnelBaseSpecTranslator.decodeStrTunnelName(asn, mo, context);
        EOperationType operType = this.setAddOrDeleted((VmfMO)mo, 0, 0, asn.poOperMask, context);
        if (operType.equals((Object)EOperationType.DELETE)) {
            return;
        }
        mo.setDeployStatus(this.integerValue(asn.iDeployStatus, "iDeployStatus", null, (VmfMO)mo, context));
        mo.setUserLabel(this.strValue(asn.userLabel, "userLabel", null, (VmfMO)mo, context));
    }

    public void encode(StaticTunnel mo, QAsnTunnelBase asn, IAsnTranslationContext context) throws VMFException {
        if (asn == null || mo == null) {
            return;
        }
        context.addProperty(StaticTunnel.class.getName(), (Object)mo);
        this.qasnTunnelBaseSpecTranslator.encodeKeyProperties(mo, asn, context);
        this.encodeStaticTunnel(mo, asn, context);
        this.qasnTunnelBaseSpecTranslator.encodeITransportType(mo, asn, context);
        this.qasnTunnelBaseSpecTranslator.encodeISignalType(mo, asn, context);
        this.qasnTunnelBaseSpecTranslator.encodeIPosition(mo, asn, context);
        this.qasnTunnelBaseSpecTranslator.encodeIBindingTnlIf(mo, asn, context);
        this.qasnTunnelBaseSpecTranslator.encodeStrDescription(mo, asn, context);
        this.qasnTunnelBaseSpecTranslator.encodeUserLabel(mo, asn, context);
        this.qasnTunnelBaseSpecTranslator.encodePoDirection(mo, asn, context);
        this.qasnTunnelBaseSpecTranslator.encodeStrTunnelName(mo, asn, context);
        asn.poOperResult = this.getAsnOperResult((VmfMO)mo, context);
    }

    public void encodeStaticTunnel(StaticTunnel mo, QAsnTunnelBase asn, IAsnTranslationContext context) throws VMFException {
        int mask = 0;
        asn.strIngressLsrID = this.getBytes(mo.getIngressLsrId());
        asn.strEgressLsrID = this.getBytes(mo.getEgressLsrId());
        asn.iTunnelID = this.intValue(mo.getTunnelId());
        asn.poOperMask = this.getOperMask(asn.poOperMask, mask |= this.setChangeMask((VmfMO)mo, context, z_staticTunnelMasks));
        asn.iDeployStatus = mo.getDeployStatus();
        asn.userLabel = this.getBytes(mo.getUserLabel());
        asn.iEnableStatus = RsvpTeTunnel.ADMIN_STATUS_ENUM.UP;
    }

    public Class<QAsnTunnelBase> getAsnClass() {
        return QAsnTunnelBase.class;
    }

    public Class<StaticTunnel> getMoClass() {
        return StaticTunnel.class;
    }
}

