/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.vmf.adapter.mpls.translation.asn;

import com.huawei.network.qasn.m_q_ip_spring_model.QAsnSPRingTnlBandwith;
import com.huawei.vmf.adapter.common.exception.VMFException;
import com.huawei.vmf.adapter.common.utilty.AsnUtil;
import com.huawei.vmf.adapter.framework.dao.DaoFactory;
import com.huawei.vmf.adapter.framework.notify.IMOChangeRecord;
import com.huawei.vmf.adapter.framework.transaction.Context;
import com.huawei.vmf.adapter.framework.translation.asn.AbstractAsnTranslator;
import com.huawei.vmf.adapter.framework.translation.asn.IAsnTranslationContext;
import com.huawei.vmf.adapter.fservice.model.EOperationType;
import com.huawei.vmf.adapter.fservice.model.VmfMO;
import com.huawei.vmf.adapter.fservice.mpls.model.MplsRing;
import com.huawei.vmf.adapter.fservice.mpls.model.RingPayload;
import com.huawei.vmf.adapter.mpls.dao.MplsDao;
import com.huawei.vmf.adapter.mpls.translation.asn.spec.QAsnSPRingTnlBandwithSpecTranslator;
import java.util.ArrayList;
import java.util.Collection;
import org.springframework.util.CollectionUtils;

public class QAsnSPRingTnlBandwithTranslator
extends AbstractAsnTranslator<QAsnSPRingTnlBandwith, RingPayload> {
    public static final Object[][] z_qasnSPRingTnlBandwithMasks = new Object[0][];
    public static final Object[][] z_ringPayloadMasks = new Object[0][];
    private QAsnSPRingTnlBandwithSpecTranslator qasnSPRingTnlBandwithSpecTranslator = new QAsnSPRingTnlBandwithSpecTranslator();

    public void decode(QAsnSPRingTnlBandwith asn, RingPayload mo, IAsnTranslationContext context) throws VMFException {
        if (asn == null || mo == null) {
            return;
        }
        this.decodeRingPayload(asn, mo, context);
        if (this.isDelete(0, asn.poOperMask, context)) {
            return;
        }
        this.qasnSPRingTnlBandwithSpecTranslator.decodePoEastCir(asn, mo, context);
        this.qasnSPRingTnlBandwithSpecTranslator.decodePoWestCir(asn, mo, context);
        this.qasnSPRingTnlBandwithSpecTranslator.decodePir(asn, mo, context);
        if (0L == AsnUtil.longValue((byte[])asn.pir) && (0L == AsnUtil.longValue((byte[])asn.poEastCir) || 0L == AsnUtil.longValue((byte[])asn.poWestCir))) {
            IMOChangeRecord record = context.getTransactionContext().addChangeRecord(RingPayload.class);
            record.addDelete((Object)mo);
        }
    }

    public void decodeRingPayload(QAsnSPRingTnlBandwith asn, RingPayload mo, IAsnTranslationContext context) throws VMFException {
        MplsRing mplsRing = (MplsRing)context.getProperty(MplsRing.class.getName());
        mo.setDevID(mplsRing.getDevID());
        mo.setVrID(mplsRing.getVrID());
        mo.setRingId(mplsRing.getRingId());
        mo.setTunnelId(Integer.valueOf(this.intValue(asn.tnlID)));
        mo.setIngressLsrId(this.strValue(asn.srcLsrID));
        mo.setEgressLsrId(this.strValue(asn.snkLsrID));
        context.addProperty(RingPayload.class.getName(), (Object)mo);
        EOperationType operType = this.setAddOrDeleted((VmfMO)mo, 0, 0, asn.poOperMask, context);
        if (operType.equals((Object)EOperationType.DELETE)) {
            return;
        }
        ArrayList<RingPayload> mapNodes = new ArrayList<RingPayload>();
        mapNodes.add(mo);
        Collection dbMapNodes = DaoFactory.getInstance().getDefaultDao(DaoFactory.VMF_DB, null).queryByKey(RingPayload.class, mapNodes, false);
        if (CollectionUtils.isEmpty((Collection)dbMapNodes)) {
            Context ctx = new Context();
            IMOChangeRecord record = ctx.addChangeRecord(RingPayload.class);
            record.addCreate((Object)mo);
            MplsDao.newInstance(ctx).merge(RingPayload.class, false);
        }
        this.setChanged((VmfMO)mo, z_ringPayloadMasks, asn.poOperMask, context);
    }

    public void encode(RingPayload mo, QAsnSPRingTnlBandwith asn, IAsnTranslationContext context) throws VMFException {
        if (asn == null || mo == null) {
            return;
        }
        context.addProperty(RingPayload.class.getName(), (Object)mo);
        this.encodeRingPayload(mo, asn, context);
        this.qasnSPRingTnlBandwithSpecTranslator.encodePoEastCir(mo, asn, context);
        this.qasnSPRingTnlBandwithSpecTranslator.encodePoWestCir(mo, asn, context);
        this.qasnSPRingTnlBandwithSpecTranslator.encodePir(mo, asn, context);
        asn.poResult = this.getAsnOperResult((VmfMO)mo, context);
    }

    public void encodeRingPayload(RingPayload mo, QAsnSPRingTnlBandwith asn, IAsnTranslationContext context) throws VMFException {
        int mask = 0;
        asn.tnlID = this.intValue(mo.getTunnelId());
        asn.srcLsrID = this.getBytes(mo.getIngressLsrId());
        asn.snkLsrID = this.getBytes(mo.getEgressLsrId());
        asn.poOperMask = this.getOperMask(asn.poOperMask, mask |= this.setChangeMask((VmfMO)mo, context, z_ringPayloadMasks));
    }

    public Class<QAsnSPRingTnlBandwith> getAsnClass() {
        return QAsnSPRingTnlBandwith.class;
    }

    public Class<RingPayload> getMoClass() {
        return RingPayload.class;
    }
}

