/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.vmf.adapter.mpls.translation.asn;

import com.huawei.network.qasn.m_q_ip_spring_model.QAsnSPRingPathBase;
import com.huawei.vmf.adapter.common.exception.VMFException;
import com.huawei.vmf.adapter.framework.translation.asn.AbstractAsnTranslator;
import com.huawei.vmf.adapter.framework.translation.asn.IAsnTranslationContext;
import com.huawei.vmf.adapter.fservice.model.EOperationType;
import com.huawei.vmf.adapter.fservice.model.VmfMO;
import com.huawei.vmf.adapter.fservice.mpls.model.MplsRing;
import com.huawei.vmf.adapter.fservice.mpls.model.RingSinkNode;

public class QAsnSPRingPathBaseTranslator
extends AbstractAsnTranslator<QAsnSPRingPathBase, RingSinkNode> {
    public static final int RI_SPR_EASTWORK_INLABEL_CHG = 1;
    public static final int RI_SPR_WESTWORK_INLABEL_CHG = 2;
    public static final int RI_SPR_EASTPROTECT_INLABEL_CHG = 4;
    public static final int RI_SPR_WESTPROTECT_INLABEL_CHG = 8;
    public static final int RI_SPR_EASTWORK_OUTLABEL_CHG = 16;
    public static final int RI_SPR_WESTWORK_OUTLABEL_CHG = 32;
    public static final int RI_SPR_EASTPROTECT_OUTLABEL_CHG = 64;
    public static final int RI_SPR_WESTPROTECT_OUTLABEL_CHG = 128;
    public static final Object[][] z_qasnSPRingPathBaseMasks = new Object[][]{{"eastInWorkLabel", 1}, {"westInWorkLabel", 2}, {"eastInProtectLabel", 4}, {"westInProtectLabel", 8}, {"eastOutWorkLabel", 16}, {"westOutWorkLabel", 32}, {"eastOutProtectLabel", 64}, {"westOutProtectLabel", 128}};
    public static final Object[][] z_ringSinkNodeMasks = new Object[][]{{"workingEastInLabel", 1}, {"workingWestInLabel", 2}, {"protectionEastInLabel", 4}, {"protectionWestInLabel", 8}, {"workingEastOutLabel", 16}, {"workingWestOutLabel", 32}, {"protectionEastOutLabel", 64}, {"protectionWestOutLabel", 128}};

    public void decode(QAsnSPRingPathBase asn, RingSinkNode mo, IAsnTranslationContext context) throws VMFException {
        if (asn == null || mo == null) {
            return;
        }
        this.decodeRingSinkNode(asn, mo, context);
        if (this.isDelete(0, asn.poOperMask, context)) {
            return;
        }
    }

    public void decodeRingSinkNode(QAsnSPRingPathBase asn, RingSinkNode mo, IAsnTranslationContext context) throws VMFException {
        MplsRing mplsRing = (MplsRing)context.getProperty(MplsRing.class.getName());
        mo.setDevID(mplsRing.getDevID());
        mo.setVrID(mplsRing.getVrID());
        mo.setRingId(mplsRing.getRingId());
        mo.setSinkNodeId(Integer.valueOf(this.intValue(asn.destNodeID)));
        context.addProperty(RingSinkNode.class.getName(), (Object)mo);
        EOperationType operType = this.setAddOrDeleted((VmfMO)mo, 0, 0, asn.poOperMask, context);
        if (operType.equals((Object)EOperationType.DELETE)) {
            return;
        }
        mo.setWorkingEastInLabel(Long.valueOf(asn.westInWorkLabel));
        mo.setProtectionEastInLabel(Long.valueOf(asn.westInProtectLabel));
        mo.setWorkingWestInLabel(Long.valueOf(asn.eastInWorkLabel));
        mo.setProtectionWestInLabel(Long.valueOf(asn.eastInProtectLabel));
        mo.setWorkingEastOutLabel(Long.valueOf(asn.eastOutWorkLabel));
        mo.setProtectionEastOutLabel(Long.valueOf(asn.eastOutProtectLabel));
        mo.setWorkingWestOutLabel(Long.valueOf(asn.westOutWorkLabel));
        mo.setProtectionWestOutLabel(Long.valueOf(asn.westOutProtectLabel));
        this.setChanged((VmfMO)mo, z_ringSinkNodeMasks, asn.poOperMask, context);
    }

    public void encode(RingSinkNode mo, QAsnSPRingPathBase asn, IAsnTranslationContext context) throws VMFException {
        if (asn == null || mo == null) {
            return;
        }
        context.addProperty(RingSinkNode.class.getName(), (Object)mo);
        this.encodeRingSinkNode(mo, asn, context);
    }

    public void encodeRingSinkNode(RingSinkNode mo, QAsnSPRingPathBase asn, IAsnTranslationContext context) throws VMFException {
        int mask = 0;
        asn.destNodeID = this.intValue(mo.getSinkNodeId());
        asn.eastInWorkLabel = this.intValue(mo.getWorkingWestInLabel());
        asn.eastInProtectLabel = this.intValue(mo.getProtectionWestInLabel());
        asn.westInWorkLabel = this.intValue(mo.getWorkingEastInLabel());
        asn.westInProtectLabel = this.intValue(mo.getProtectionEastInLabel());
        asn.eastOutWorkLabel = this.intValue(mo.getWorkingEastOutLabel());
        asn.eastOutProtectLabel = this.intValue(mo.getProtectionEastOutLabel());
        asn.westOutWorkLabel = this.intValue(mo.getWorkingWestOutLabel());
        asn.westOutProtectLabel = this.intValue(mo.getProtectionWestOutLabel());
        asn.poOperMask = this.getOperMask(asn.poOperMask, mask |= this.setChangeMask((VmfMO)mo, context, z_ringSinkNodeMasks));
    }

    public Class<QAsnSPRingPathBase> getAsnClass() {
        return QAsnSPRingPathBase.class;
    }

    public Class<RingSinkNode> getMoClass() {
        return RingSinkNode.class;
    }
}

