/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.vmf.adapter.mpls.translation.asn;

import com.huawei.network.qasn.m_q_ip_spring_model.QAsnSPRingOAMBase;
import com.huawei.vmf.adapter.common.exception.VMFException;
import com.huawei.vmf.adapter.framework.translation.asn.AbstractAsnTranslator;
import com.huawei.vmf.adapter.framework.translation.asn.IAsnTranslationContext;
import com.huawei.vmf.adapter.fservice.model.EOperationType;
import com.huawei.vmf.adapter.fservice.model.VmfMO;
import com.huawei.vmf.adapter.fservice.mpls.model.Ring;
import com.huawei.vmf.adapter.mpls.translation.asn.spec.QAsnSPRingOAMBaseSpecTranslator;

public class QAsnSPRingOAMBaseTranslator
extends AbstractAsnTranslator<QAsnSPRingOAMBase, Ring> {
    public static final int RI_SPR_OAMENABLE_CHG = 1;
    public static final int RI_SPR_OAMFREQUENCY_CHG = 2;
    public static final int RI_SPR_OAMMODE_CHG = 4;
    public static final int RI_SPR_OAMSF_CHG = 8;
    public static final int RI_SPR_OAMSD_CHG = 16;
    public static final int RI_SPR_OAMEXP_CHG = 32;
    public static final Object[][] z_qasnSPRingOAMBaseMasks = new Object[][]{{"enable", 1}, {"frequency", 2}, {"mode", 4}, {"sf", 8}, {"sd", 16}, {"exp", 32}};
    public static final Object[][] z_ringMasks = new Object[][]{{"oamActiveState", 1}, {"detectFrequence", 2}, {"ringId", 4}, {"oamLossSf", 8}, {"oamLossSd", 16}};
    private QAsnSPRingOAMBaseSpecTranslator qasnSPRingOAMBaseSpecTranslator = new QAsnSPRingOAMBaseSpecTranslator();

    public void decode(QAsnSPRingOAMBase asn, Ring mo, IAsnTranslationContext context) throws VMFException {
        if (asn == null || mo == null) {
            return;
        }
        this.qasnSPRingOAMBaseSpecTranslator.decodeKeyProperties(asn, mo, context);
        this.decodeRing(asn, mo, context);
        if (this.isDelete(0, asn.poOperMask, context)) {
            return;
        }
        this.qasnSPRingOAMBaseSpecTranslator.decodeEnable(asn, mo, context);
        this.qasnSPRingOAMBaseSpecTranslator.decodeFrequency(asn, mo, context);
        this.qasnSPRingOAMBaseSpecTranslator.decodeMode(asn, mo, context);
    }

    public void decodeRing(QAsnSPRingOAMBase asn, Ring mo, IAsnTranslationContext context) throws VMFException {
        this.qasnSPRingOAMBaseSpecTranslator.decodeQAsnSPRingOAMBaseSpecKeys(asn, mo, context);
        context.addProperty(Ring.class.getName(), (Object)mo);
        EOperationType operType = this.setAddOrDeleted((VmfMO)mo, 0, 0, asn.poOperMask, context);
        if (operType.equals((Object)EOperationType.DELETE)) {
            return;
        }
        mo.setOamLossSf(this.bigIntegerValue(asn.sf, "oamLossSf", z_ringMasks, (VmfMO)mo, context));
        mo.setOamLossSd(this.bigIntegerValue(asn.sd, "oamLossSf", z_ringMasks, (VmfMO)mo, context));
        this.setChanged((VmfMO)mo, z_ringMasks, asn.poOperMask, context);
    }

    public void encode(Ring mo, QAsnSPRingOAMBase asn, IAsnTranslationContext context) throws VMFException {
        if (asn == null || mo == null) {
            return;
        }
        context.addProperty(Ring.class.getName(), (Object)mo);
        this.qasnSPRingOAMBaseSpecTranslator.encodeKeyProperties(mo, asn, context);
        this.encodeRing(mo, asn, context);
        this.qasnSPRingOAMBaseSpecTranslator.encodeEnable(mo, asn, context);
        this.qasnSPRingOAMBaseSpecTranslator.encodeFrequency(mo, asn, context);
        this.qasnSPRingOAMBaseSpecTranslator.encodeMode(mo, asn, context);
    }

    public void encodeRing(Ring mo, QAsnSPRingOAMBase asn, IAsnTranslationContext context) throws VMFException {
        int mask = 0;
        this.qasnSPRingOAMBaseSpecTranslator.encodeSf(mo, asn, context);
        this.qasnSPRingOAMBaseSpecTranslator.encodeSd(mo, asn, context);
        asn.poOperMask = this.getOperMask(asn.poOperMask, mask |= this.setChangeMask((VmfMO)mo, context, z_ringMasks));
    }

    public Class<QAsnSPRingOAMBase> getAsnClass() {
        return QAsnSPRingOAMBase.class;
    }

    public Class<Ring> getMoClass() {
        return Ring.class;
    }
}

