/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.vmf.adapter.mpls.translation.asn;

import com.huawei.network.qasn.m_q_ip_spring_model.QAsnNodeIDAndLSRIDPare;
import com.huawei.network.qasn.m_q_ip_spring_model.QAsnNodeIDAndLSRIDPareList;
import com.huawei.network.qasn.m_q_ip_spring_model.QAsnSPRingBaseInfo;
import com.huawei.vmf.adapter.common.exception.VMFException;
import com.huawei.vmf.adapter.framework.dao.DaoFactory;
import com.huawei.vmf.adapter.framework.notify.IMOChangeRecord;
import com.huawei.vmf.adapter.framework.notify.PropertyChangeItem;
import com.huawei.vmf.adapter.framework.transaction.Context;
import com.huawei.vmf.adapter.framework.translation.asn.AbstractAsnTranslator;
import com.huawei.vmf.adapter.framework.translation.asn.IAsnTranslationContext;
import com.huawei.vmf.adapter.framework.translation.asn.IAsnTranslator;
import com.huawei.vmf.adapter.fservice.model.EOperationType;
import com.huawei.vmf.adapter.fservice.model.VmfMO;
import com.huawei.vmf.adapter.fservice.mpls.model.MplsRing;
import com.huawei.vmf.adapter.fservice.mpls.model.RingMapNode;
import com.huawei.vmf.adapter.mpls.dao.MplsDao;
import com.huawei.vmf.adapter.mpls.translation.asn.QAsnNodeIDAndLSRIDPareTranslator;
import com.huawei.vmf.adapter.mpls.translation.asn.spec.QAsnSPRingBaseInfoSpecTranslator;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Vector;
import org.springframework.util.CollectionUtils;

public class QAsnSPRingBaseInfoTranslator
extends AbstractAsnTranslator<QAsnSPRingBaseInfo, MplsRing> {
    private IAsnTranslator<QAsnNodeIDAndLSRIDPare, RingMapNode> qasnNodeIDAndLSRIDPareTranslator = new QAsnNodeIDAndLSRIDPareTranslator();
    public static final int RI_SPR_NAME_CHG = 1;
    public static final int RI_SPR_EASTNEXTHOP_CHG = 2;
    public static final int RI_SPR_WESTNEXTHOP_CHG = 4;
    public static final int RI_SPR_EASTPORT_CHG = 8;
    public static final int RI_SPR_WESTPORT_CHG = 16;
    public static final int RI_SPR_MTU_CHG = 32;
    public static final int RI_SPR_EASTWORKEXP_CHG = 64;
    public static final int RI_SPR_WESTWORKEXP_CHG = 128;
    public static final int RI_SPR_EASTPROTECTEXP_CHG = 256;
    public static final int RI_SPR_WESTPROTECTEXP_CHG = 512;
    public static final int RI_SPR_PIR_CHG = 1024;
    public static final int RI_SPR_CIR_CHG = 2048;
    public static final int RI_SPR_PBS_CHG = 4096;
    public static final int RI_SPR_CBS_CHG = 8192;
    public static final int RI_SPR_EASTREMAINCIR_CHG = 16384;
    public static final int RI_SPR_WESTREMAINCIR_CHG = 32768;
    public static final Object[][] z_qasnSPRingBaseInfoMasks = new Object[][]{{"name", 1}, {"eastNextHop", 2}, {"westNextHop", 4}, {"eastPort", 8}, {"westPort", 16}, {"mtu", 32}, {"eastWorkExp", 64}, {"westWorkExp", 128}, {"eastProtectExp", 256}, {"westProtectExp", 512}, {"pir", 1024}, {"cir", 2048}, {"pbs", 4096}, {"cbs", 8192}, {"eastRemainCir", 16384}, {"westRemainCir", 32768}};
    public static final Object[][] z_mplsRingMasks = new Object[][]{{"ringName", 1}, {"eastNextHop", 2}, {"westNextHop", 4}, {"eastOutIf", 8}, {"westOutIf", 16}, {"ringMtu", 32}, {"ringWorkingExp", 64}, {"ringWorkingExp", 128}, {"ringProtectionExp", 256}, {"ringProtectionExp", 512}, {"ringPir", 1024}, {"ringCir", 2048}, {"ringPbs", 4096}, {"ringCbs", 8192}, {"eastBwAvailable", 16384}, {"westBwAvailable", 32768}};
    private QAsnSPRingBaseInfoSpecTranslator qasnSPRingBaseInfoSpecTranslator = new QAsnSPRingBaseInfoSpecTranslator();

    public void decode(QAsnSPRingBaseInfo asn, MplsRing mo, IAsnTranslationContext context) throws VMFException {
        if (asn == null || mo == null) {
            return;
        }
        this.qasnSPRingBaseInfoSpecTranslator.decodeKeyProperties(asn, mo, context);
        this.decodeMplsRing(asn, mo, context);
        if (this.isDelete(0, asn.poOperMask, context)) {
            return;
        }
        this.qasnSPRingBaseInfoSpecTranslator.decodeEastWorkExp(asn, mo, context);
        this.qasnSPRingBaseInfoSpecTranslator.decodeWestWorkExp(asn, mo, context);
        this.qasnSPRingBaseInfoSpecTranslator.decodeEastProtectExp(asn, mo, context);
        this.qasnSPRingBaseInfoSpecTranslator.decodeWestProtectExp(asn, mo, context);
        this.qasnSPRingBaseInfoSpecTranslator.decodeEastRemainCir(asn, mo, context);
        this.qasnSPRingBaseInfoSpecTranslator.decodeWestRemainCir(asn, mo, context);
        this.setChanged((VmfMO)mo, z_mplsRingMasks, asn.poOperMask, context);
    }

    public void decodeMplsRing(QAsnSPRingBaseInfo asn, MplsRing mo, IAsnTranslationContext context) throws VMFException {
        mo.setRingId(Integer.valueOf(this.intValue(asn.ringID)));
        context.addProperty(MplsRing.class.getName(), (Object)mo);
        EOperationType operType = this.setAddOrDeleted((VmfMO)mo, 0, 0, asn.poOperMask, context);
        if (operType.equals((Object)EOperationType.DELETE)) {
            return;
        }
        mo.setRingName(this.strValue(asn.name, "ringName", z_mplsRingMasks, (VmfMO)mo, context));
        mo.setRingNodeId(this.integerValue(asn.nodeID, "ringNodeId", z_mplsRingMasks, (VmfMO)mo, context));
        IMOChangeRecord recorder = context.getTransactionContext().addChangeRecord(MplsRing.class);
        recorder.addModify((Object)mo, new PropertyChangeItem("ringNodeId", null, null));
        mo.setRingMode(this.integerValue(asn.type, "ringMode", z_mplsRingMasks, (VmfMO)mo, context));
        mo.setEastNextHop(this.strValue(asn.eastNextHop, "eastNextHop", z_mplsRingMasks, (VmfMO)mo, context));
        mo.setWestNextHop(this.strValue(asn.westNextHop, "westNextHop", z_mplsRingMasks, (VmfMO)mo, context));
        mo.setRingMtu(this.longValue(asn.mtu, "ringMtu", z_mplsRingMasks, (VmfMO)mo, context));
        mo.setRingCir(this.longValue(asn.cir, "ringCir", z_mplsRingMasks, (VmfMO)mo, context));
        mo.setRingPir(this.longValue(asn.pir, "ringPir", z_mplsRingMasks, (VmfMO)mo, context));
        mo.setRingCbs(this.longValue(asn.cbs, "ringCbs", z_mplsRingMasks, (VmfMO)mo, context));
        mo.setRingPbs(this.longValue(asn.pbs, "ringPbs", z_mplsRingMasks, (VmfMO)mo, context));
        this.decodeRingMemberList(asn, mo, context);
    }

    private void decodeRingMemberList(QAsnSPRingBaseInfo asn, MplsRing mo, IAsnTranslationContext context) throws VMFException {
        if (null == asn.ringMemberList) {
            return;
        }
        mo.addRingMapNodes(this.qasnNodeIDAndLSRIDPareTranslator.decode((Collection)asn.ringMemberList, context));
        if (CollectionUtils.isEmpty((Collection)mo.getRingMapNodes())) {
            return;
        }
        int count = 1;
        for (RingMapNode ringMapNode : mo.getRingMapNodes()) {
            ringMapNode.setHopId(Long.valueOf(count));
            ++count;
        }
        this.setChanged((VmfMO)mo, "ringMapNodes", mo.getRingMapNodes(), context);
        RingMapNode localNode = new RingMapNode();
        localNode.setDevID(mo.getDevID());
        localNode.setVrID(mo.getVrID());
        localNode.setRingId(mo.getRingId());
        localNode.setNodeId(Integer.valueOf(this.intValue(asn.nodeID)));
        localNode.setHopId(Long.valueOf(0L));
        localNode.setLsrId("--");
        ArrayList<RingMapNode> mapNodes = new ArrayList<RingMapNode>();
        mapNodes.add(localNode);
        Collection dbMapNodes = DaoFactory.getInstance().getDefaultDao(DaoFactory.VMF_DB, null).queryByKey(RingMapNode.class, mapNodes, false);
        if (CollectionUtils.isEmpty((Collection)dbMapNodes)) {
            Context ctx = new Context();
            IMOChangeRecord record = ctx.addChangeRecord(RingMapNode.class);
            record.addCreate((Object)localNode);
            MplsDao.newInstance(ctx).merge(RingMapNode.class, false);
        }
    }

    public void encode(MplsRing mo, QAsnSPRingBaseInfo asn, IAsnTranslationContext context) throws VMFException {
        if (asn == null || mo == null) {
            return;
        }
        context.addProperty(MplsRing.class.getName(), (Object)mo);
        this.qasnSPRingBaseInfoSpecTranslator.encodeKeyProperties(mo, asn, context);
        this.encodeMplsRing(mo, asn, context);
        this.qasnSPRingBaseInfoSpecTranslator.encodeEastWorkExp(mo, asn, context);
        this.qasnSPRingBaseInfoSpecTranslator.encodeWestWorkExp(mo, asn, context);
        this.qasnSPRingBaseInfoSpecTranslator.encodeEastProtectExp(mo, asn, context);
        this.qasnSPRingBaseInfoSpecTranslator.encodeWestProtectExp(mo, asn, context);
        this.qasnSPRingBaseInfoSpecTranslator.encodeEastRemainCir(mo, asn, context);
        this.qasnSPRingBaseInfoSpecTranslator.encodeWestRemainCir(mo, asn, context);
        asn.poResult = this.getAsnOperResult((VmfMO)mo, context);
    }

    public void encodeMplsRing(MplsRing mo, QAsnSPRingBaseInfo asn, IAsnTranslationContext context) throws VMFException {
        int mask = 0;
        asn.ringID = this.intValue(mo.getRingId());
        asn.name = this.getBytes(mo.getRingName());
        asn.nodeID = this.intValue(mo.getRingNodeId());
        asn.type = this.intValue(mo.getRingMode());
        asn.eastNextHop = this.getBytes(mo.getEastNextHop());
        asn.westNextHop = this.getBytes(mo.getWestNextHop());
        asn.mtu = this.intValue(mo.getRingMtu());
        asn.cir = this.getBytes(mo.getRingCir());
        asn.pir = this.getBytes(mo.getRingPir());
        asn.cbs = this.getBytes(mo.getRingCbs());
        asn.pbs = this.getBytes(mo.getRingPbs());
        mask |= this.setChangeMask((VmfMO)mo, context, z_mplsRingMasks);
        this.encodeRingMemberList(mo, asn, context);
        asn.poOperMask = this.getOperMask(asn.poOperMask, mask |= this.getChangeMask((Vector)asn.ringMemberList, z_qasnSPRingBaseInfoMasks, "ringMemberList"));
    }

    private void encodeRingMemberList(MplsRing mo, QAsnSPRingBaseInfo asn, IAsnTranslationContext context) throws VMFException {
        if (null == mo.getRingMapNodes()) {
            return;
        }
        if (null == asn.ringMemberList) {
            asn.ringMemberList = new QAsnNodeIDAndLSRIDPareList();
        }
        asn.ringMemberList.addAll(this.qasnNodeIDAndLSRIDPareTranslator.encode(mo.getRingMapNodes(), context));
    }

    public Class<QAsnSPRingBaseInfo> getAsnClass() {
        return QAsnSPRingBaseInfo.class;
    }

    public Class<MplsRing> getMoClass() {
        return MplsRing.class;
    }
}

