/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.vmf.adapter.mpls.translation.asn;

import com.huawei.network.qasn.m_q_ip_spring_model.QAsnSPRingAPSBase;
import com.huawei.vmf.adapter.common.exception.VMFException;
import com.huawei.vmf.adapter.framework.translation.asn.AbstractAsnTranslator;
import com.huawei.vmf.adapter.framework.translation.asn.IAsnTranslationContext;
import com.huawei.vmf.adapter.fservice.model.EOperationType;
import com.huawei.vmf.adapter.fservice.model.VmfMO;
import com.huawei.vmf.adapter.fservice.mpls.model.MplsRing;
import com.huawei.vmf.adapter.mpls.translation.asn.spec.QAsnSPRingAPSBaseSpecTranslator;

public class QAsnSPRingAPSBaseTranslator
extends AbstractAsnTranslator<QAsnSPRingAPSBase, MplsRing> {
    public static final int RI_SPR_APSEASTENABLE_CHG = 1;
    public static final int RI_SPR_APSWESTENABLE_CHG = 2;
    public static final int RI_SPR_APSWESTWTR_CHG = 4;
    public static final int RI_SPR_APSWESTHOLDOFF_CHG = 8;
    public static final Object[][] z_qasnSPRingAPSBaseMasks = new Object[][]{{"eastEnable", 1}, {"westEnable", 2}, {"wtr", 4}, {"holdoff", 8}};
    public static final Object[][] z_mplsRingMasks = new Object[][]{{"apsEastEnable", 1}, {"apsWestEnable", 2}, {"wtrValue", 4}, {"holdoffValue", 8}};
    private QAsnSPRingAPSBaseSpecTranslator qasnSPRingAPSBaseSpecTranslator = new QAsnSPRingAPSBaseSpecTranslator();

    public void decode(QAsnSPRingAPSBase asn, MplsRing mo, IAsnTranslationContext context) throws VMFException {
        if (asn == null || mo == null) {
            return;
        }
        this.qasnSPRingAPSBaseSpecTranslator.decodeKeyProperties(asn, mo, context);
        this.decodeMplsRing(asn, mo, context);
        if (this.isDelete(0, asn.poOperMask, context)) {
            return;
        }
        this.qasnSPRingAPSBaseSpecTranslator.decodeEastEnable(asn, mo, context);
        this.qasnSPRingAPSBaseSpecTranslator.decodeWestEnable(asn, mo, context);
    }

    public void decodeMplsRing(QAsnSPRingAPSBase asn, MplsRing mo, IAsnTranslationContext context) throws VMFException {
        this.qasnSPRingAPSBaseSpecTranslator.decodeQAsnSPRingAPSBaseSpecKeys(asn, mo, context);
        context.addProperty(MplsRing.class.getName(), (Object)mo);
        EOperationType operType = this.setAddOrDeleted((VmfMO)mo, 0, 0, asn.poOperMask, context);
        if (operType.equals((Object)EOperationType.DELETE)) {
            return;
        }
        mo.setWtrValue(this.integerValue(asn.wtr, "wtrValue", z_mplsRingMasks, (VmfMO)mo, context));
        mo.setHoldoffValue(this.integerValue(asn.holdoff, "holdoffValue", z_mplsRingMasks, (VmfMO)mo, context));
        this.setChanged((VmfMO)mo, z_mplsRingMasks, asn.poOperMask, context);
    }

    public void encode(MplsRing mo, QAsnSPRingAPSBase asn, IAsnTranslationContext context) throws VMFException {
        if (asn == null || mo == null) {
            return;
        }
        context.addProperty(MplsRing.class.getName(), (Object)mo);
        this.qasnSPRingAPSBaseSpecTranslator.encodeKeyProperties(mo, asn, context);
        this.encodeMplsRing(mo, asn, context);
        this.qasnSPRingAPSBaseSpecTranslator.encodeEastEnable(mo, asn, context);
        this.qasnSPRingAPSBaseSpecTranslator.encodeWestEnable(mo, asn, context);
    }

    public void encodeMplsRing(MplsRing mo, QAsnSPRingAPSBase asn, IAsnTranslationContext context) throws VMFException {
        int mask = 0;
        asn.wtr = this.intValue(mo.getWtrValue());
        asn.holdoff = this.intValue(mo.getHoldoffValue());
        asn.poOperMask = this.getOperMask(asn.poOperMask, mask |= this.setChangeMask((VmfMO)mo, context, z_mplsRingMasks));
    }

    public Class<QAsnSPRingAPSBase> getAsnClass() {
        return QAsnSPRingAPSBase.class;
    }

    public Class<MplsRing> getMoClass() {
        return MplsRing.class;
    }
}

