/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.vmf.adapter.mpls.translation.asn;

import com.huawei.network.qasn.m_q_ip_tunnel_model.QAsnCreateAttr;
import com.huawei.network.qasn.m_q_ip_tunnel_model.QAsnIgpAttr;
import com.huawei.network.qasn.m_q_ip_tunnel_model.QAsnOptimizationAttr;
import com.huawei.network.qasn.m_q_ip_tunnel_model.QAsnPathConstraintAttr;
import com.huawei.network.qasn.m_q_ip_tunnel_model.QAsnReverseLspAttr;
import com.huawei.network.qasn.m_q_ip_tunnel_model.QAsnRsvpTeAttr;
import com.huawei.vmf.adapter.common.exception.VMFException;
import com.huawei.vmf.adapter.common.utilty.AsnUtil;
import com.huawei.vmf.adapter.framework.notify.IMOChangeRecord;
import com.huawei.vmf.adapter.framework.translation.asn.AbstractAsnTranslator;
import com.huawei.vmf.adapter.framework.translation.asn.IAsnTranslationContext;
import com.huawei.vmf.adapter.framework.translation.asn.IAsnTranslator;
import com.huawei.vmf.adapter.fservice.model.EOperationType;
import com.huawei.vmf.adapter.fservice.model.VmfMO;
import com.huawei.vmf.adapter.fservice.mpls.model.ReverseRsvpTeLsp;
import com.huawei.vmf.adapter.fservice.mpls.model.RsvpTeTunnel;
import com.huawei.vmf.adapter.fservice.mpls.model.RsvpTeTunnelAdv;
import com.huawei.vmf.adapter.fservice.mpls.model.RsvpTeTunnelBitError;
import com.huawei.vmf.adapter.mpls.common.MplsUtil;
import com.huawei.vmf.adapter.mpls.translation.asn.QAsnCreateAttrTranslator;
import com.huawei.vmf.adapter.mpls.translation.asn.QAsnIgpAttrTranslator;
import com.huawei.vmf.adapter.mpls.translation.asn.QAsnOptimizationAttrTranslator;
import com.huawei.vmf.adapter.mpls.translation.asn.QAsnPathConstraintAttrTranslator;
import com.huawei.vmf.adapter.mpls.translation.asn.spec.QAsnRsvpTeAttrSpecTranslator;
import java.util.Collection;
import java.util.List;
import net.commustru.fstru.FStruct;
import org.springframework.util.CollectionUtils;

public class QAsnRsvpTeAttrTranslator
extends AbstractAsnTranslator<QAsnRsvpTeAttr, RsvpTeTunnel> {
    public static final int RI_OCREATEATTR_CHG = 4;
    public static final int RI_OIGPATTR_CHG = 8;
    public static final int RI_OOPTIMIZATIONATTR_CHG = 2;
    public static final int RI_OPATHCONSTRAINTATTR_CHG = 1;
    public static final int TUNNEL_RSVPTE_EnableBitErrThreshold_CHG = 64;
    public static final int TUNNEL_RSVPTE_ErrorDetectMode_CHG = 16;
    public static final int TUNNEL_RSVPTE_ResumeThresholdValue_CHG = 512;
    public static final int TUNNEL_RSVPTE_ResumeUnitValue_CHG = 1024;
    public static final int TUNNEL_RSVPTE_ReverseLspAttr_CHG = 32;
    public static final int TUNNEL_RSVPTE_SwitchThresholdValue_CHG = 128;
    public static final int TUNNEL_RSVPTE_SwitchUnitValue_CHG = 256;
    public static final Object[][] z_qasnRsvpTeAttrMasks = new Object[][]{{"oPathConstraintAttr", 1}, {"oOptimizationAttr", 2}, {"oCreateAttr", 4}, {"oIgpAttr", 8}};
    public static final Object[][] z_rsvpTeTunnelAdvMasks = new Object[0][];
    public static final Object[][] z_rsvpTeTunnelBitErrorMasks = new Object[][]{{"tunnelBitErrMode", 16}, {"tunnelBitErrSwitch", 64}, {"switchThresholdCoeValue", 128}, {"switchThresholdPowValue", 256}, {"resumeThresholdCoeValue", 512}, {"resumeThresholdPowValue", 1024}};
    public static final Object[][] z_rsvpTeTunnelMasks = new Object[0][];
    private IAsnTranslator<QAsnCreateAttr, RsvpTeTunnelAdv> qasnCreateAttrTranslator = new QAsnCreateAttrTranslator();
    private IAsnTranslator<QAsnIgpAttr, RsvpTeTunnelAdv> qasnIgpAttrTranslator = new QAsnIgpAttrTranslator();
    private IAsnTranslator<QAsnOptimizationAttr, RsvpTeTunnelAdv> qasnOptimizationAttrTranslator = new QAsnOptimizationAttrTranslator();
    private IAsnTranslator<QAsnPathConstraintAttr, RsvpTeTunnel> qasnPathConstraintAttrTranslator = new QAsnPathConstraintAttrTranslator();
    private QAsnRsvpTeAttrSpecTranslator qasnRsvpTeAttrSpecTranslator = new QAsnRsvpTeAttrSpecTranslator();

    public void decode(QAsnRsvpTeAttr asn, RsvpTeTunnel mo, IAsnTranslationContext context) throws VMFException {
        if (asn == null || mo == null) {
            return;
        }
        this.qasnRsvpTeAttrSpecTranslator.decodeKeyProperties(asn, mo, context);
        this.decodeRsvpTeTunnel(asn, mo, context);
        RsvpTeTunnelAdv rsvpTeTunnelAdv = mo.getRsvpTeTunnelAdv();
        if (null == rsvpTeTunnelAdv) {
            rsvpTeTunnelAdv = new RsvpTeTunnelAdv();
            mo.setRsvpTeTunnelAdv(rsvpTeTunnelAdv);
        }
        this.decodeRsvpTeTunnelAdv(asn, rsvpTeTunnelAdv, context);
        this.setChanged((VmfMO)mo, "rsvpTeTunnelAdv", (VmfMO)rsvpTeTunnelAdv, context);
        if (this.isDelete(0, asn.poOperMask, context)) {
            return;
        }
        RsvpTeTunnelBitError rsvpTeTunnelBitError = mo.getRsvpTeTunnelBitError();
        if (null == rsvpTeTunnelBitError) {
            rsvpTeTunnelBitError = new RsvpTeTunnelBitError();
            mo.setRsvpTeTunnelBitError(rsvpTeTunnelBitError);
        }
        this.decodeRsvpTeTunnelBitError(asn, rsvpTeTunnelBitError, context);
        this.setChanged((VmfMO)mo, "rsvpTeTunnelBitError", (VmfMO)rsvpTeTunnelBitError, context);
    }

    public void decodeRsvpTeTunnel(QAsnRsvpTeAttr asn, RsvpTeTunnel mo, IAsnTranslationContext context) throws VMFException {
        this.qasnRsvpTeAttrSpecTranslator.decodeQAsnRsvpTeAttrSpecKeys(asn, mo, context);
        if (this.isDelete(0, asn.poOperMask, context)) {
            return;
        }
        this.decodeOPathConstraintAttr(asn, mo, context);
        this.setChanged((VmfMO)mo, z_rsvpTeTunnelMasks, asn.poOperMask, context);
    }

    public void decodeRsvpTeTunnelAdv(QAsnRsvpTeAttr asn, RsvpTeTunnelAdv mo, IAsnTranslationContext context) throws VMFException {
        RsvpTeTunnel rsvpTeTunnel = (RsvpTeTunnel)context.getProperty(RsvpTeTunnel.class.getName());
        mo.setDevID(rsvpTeTunnel.getDevID());
        mo.setVrID(rsvpTeTunnel.getVrID());
        mo.setTunnelName(rsvpTeTunnel.getTunnelName());
        context.addProperty(RsvpTeTunnelAdv.class.getName(), (Object)mo);
        EOperationType operType = this.setAddOrDeleted((VmfMO)mo, 0, 0, asn.poOperMask, context);
        if (operType.equals((Object)EOperationType.DELETE)) {
            return;
        }
        this.decodeOOptimizationAttr(asn, mo, context);
        this.decodeOCreateAttr(asn, mo, context);
        this.decodeOIgpAttr(asn, mo, context);
        this.setChanged((VmfMO)mo, z_rsvpTeTunnelAdvMasks, asn.poOperMask, context);
    }

    public void decodeRsvpTeTunnelBitError(QAsnRsvpTeAttr asn, RsvpTeTunnelBitError mo, IAsnTranslationContext context) throws VMFException {
        RsvpTeTunnel rsvpTeTunnel = (RsvpTeTunnel)context.getProperty(RsvpTeTunnel.class.getName());
        mo.setDevID(rsvpTeTunnel.getDevID());
        mo.setVrID(rsvpTeTunnel.getVrID());
        mo.setTunnelName(rsvpTeTunnel.getTunnelName());
        context.addProperty(RsvpTeTunnelBitError.class.getName(), (Object)mo);
        EOperationType operType = this.setAddOrDeleted((VmfMO)mo, 0, 0, asn.poOperMask, context);
        if (operType.equals((Object)EOperationType.DELETE)) {
            return;
        }
        mo.setTunnelBitErrSwitch(this.parseBoolean(asn.poErrorDetectMode, "tunnelBitErrSwitch", z_rsvpTeTunnelBitErrorMasks, (VmfMO)mo, context));
        if (asn.poErrorDetectMode != null && asn.poErrorDetectMode != RsvpTeTunnelBitError.TUNNEL_BIT_ERR_MODE_ENUM.BIDIRECTIONAL && asn.poErrorDetectMode != RsvpTeTunnelBitError.TUNNEL_BIT_ERR_MODE_ENUM.UNIDIRECTIONAL) {
            asn.poErrorDetectMode = null;
        }
        mo.setTunnelBitErrMode(this.integerValue(asn.poErrorDetectMode, "tunnelBitErrMode", z_rsvpTeTunnelBitErrorMasks, (VmfMO)mo, context));
        mo.setResumeThresholdCoeValue(this.integerValue(asn.poResumeThresholdValue, "resumeThresholdCoeValue", z_rsvpTeTunnelBitErrorMasks, (VmfMO)mo, context));
        mo.setResumeThresholdPowValue(this.integerValue(asn.poResumeUnitValue, "resumeThresholdPowValue", z_rsvpTeTunnelBitErrorMasks, (VmfMO)mo, context));
        mo.setSwitchThresholdCoeValue(this.integerValue(asn.poSwitchThresholdValue, "switchThresholdCoeValue", z_rsvpTeTunnelBitErrorMasks, (VmfMO)mo, context));
        mo.setSwitchThresholdPowValue(this.integerValue(asn.poSwitchUnitValue, "switchThresholdPowValue", z_rsvpTeTunnelBitErrorMasks, (VmfMO)mo, context));
        this.qasnRsvpTeAttrSpecTranslator.decodeKeyRefMoReverseRsvpTeLsp(asn, rsvpTeTunnel, context);
        this.setChanged((VmfMO)mo, z_rsvpTeTunnelBitErrorMasks, asn.poOperMask, context);
        if (Boolean.FALSE.equals(mo.getTunnelBitErrSwitch()) && MplsUtil.isModify(context, (VmfMO)mo, "tunnelBitErrSwitch")) {
            MplsUtil.cancelModify(context, (VmfMO)mo, "tunnelBitErrMode");
        }
    }

    public void encode(RsvpTeTunnel mo, QAsnRsvpTeAttr asn, IAsnTranslationContext context) throws VMFException {
        RsvpTeTunnelBitError rsvpTeTunnelBitError;
        if (asn == null || mo == null) {
            return;
        }
        this.qasnRsvpTeAttrSpecTranslator.encodeKeyProperties(mo, asn, context);
        this.encodeRsvpTeTunnel(mo, asn, context);
        RsvpTeTunnelAdv rsvpTeTunnelAdv = mo.getRsvpTeTunnelAdv();
        if (null != rsvpTeTunnelAdv) {
            this.encodeRsvpTeTunnelAdv(rsvpTeTunnelAdv, asn, context);
        }
        if (null != (rsvpTeTunnelBitError = mo.getRsvpTeTunnelBitError())) {
            this.encodeRsvpTeTunnelBitError(rsvpTeTunnelBitError, asn, context);
        }
        this.encodeReverseLspAttr(mo, asn, context);
    }

    public void encodeRsvpTeTunnel(RsvpTeTunnel mo, QAsnRsvpTeAttr asn, IAsnTranslationContext context) throws VMFException {
        int mask = 0;
        mask |= this.setChangeMask((VmfMO)mo, context, z_rsvpTeTunnelMasks);
        this.encodeOPathConstraintAttr(mo, asn, context);
        asn.poOperMask = this.getOperMask(asn.poOperMask, mask |= this.setChangeMask(asn.oPathConstraintAttr.poOperMask, z_qasnRsvpTeAttrMasks, "oPathConstraintAttr"));
    }

    public void encodeRsvpTeTunnelAdv(RsvpTeTunnelAdv mo, QAsnRsvpTeAttr asn, IAsnTranslationContext context) throws VMFException {
        int mask = 0;
        mask |= this.setChangeMask((VmfMO)mo, context, z_rsvpTeTunnelAdvMasks);
        this.encodeOOptimizationAttr(mo, asn, context);
        mask |= this.setChangeMask(asn.oOptimizationAttr.poOperMask, z_qasnRsvpTeAttrMasks, "oOptimizationAttr");
        this.encodeOCreateAttr(mo, asn, context);
        mask |= this.setChangeMask(asn.oCreateAttr.poOperMask, z_qasnRsvpTeAttrMasks, "oCreateAttr");
        this.encodeOIgpAttr(mo, asn, context);
        asn.poOperMask = this.getOperMask(asn.poOperMask, mask |= this.setChangeMask(asn.oIgpAttr.poOperMask, z_qasnRsvpTeAttrMasks, "oIgpAttr"));
    }

    public void encodeRsvpTeTunnelBitError(RsvpTeTunnelBitError mo, QAsnRsvpTeAttr asn, IAsnTranslationContext context) throws VMFException {
        int mask = 0;
        mask |= this.setChangeMask((VmfMO)mo, context, z_rsvpTeTunnelBitErrorMasks);
        if (null != mo.getTunnelBitErrSwitch() && mo.getTunnelBitErrSwitch().booleanValue()) {
            asn.poErrorDetectMode = this.intValue(mo.getTunnelBitErrMode());
            if (null != mo.getSwitchThresholdCoeValue()) {
                asn.poEnableBitErrThreshold = 1;
                asn.poSwitchThresholdValue = this.intValue(mo.getSwitchThresholdCoeValue());
                asn.poSwitchUnitValue = this.intValue(mo.getSwitchThresholdPowValue());
                asn.poResumeThresholdValue = this.intValue(mo.getResumeThresholdCoeValue());
                asn.poResumeUnitValue = this.intValue(mo.getResumeThresholdPowValue());
            }
        } else {
            asn.poErrorDetectMode = null;
        }
        asn.poOperMask = this.getOperMask(asn.poOperMask, mask);
    }

    public Class<QAsnRsvpTeAttr> getAsnClass() {
        return QAsnRsvpTeAttr.class;
    }

    public Class<RsvpTeTunnel> getMoClass() {
        return RsvpTeTunnel.class;
    }

    private void decodeOCreateAttr(QAsnRsvpTeAttr asn, RsvpTeTunnelAdv mo, IAsnTranslationContext context) throws VMFException {
        if (null == asn.oCreateAttr) {
            return;
        }
        this.qasnCreateAttrTranslator.decode((FStruct)asn.oCreateAttr, (Object)mo, context);
    }

    private void decodeOIgpAttr(QAsnRsvpTeAttr asn, RsvpTeTunnelAdv mo, IAsnTranslationContext context) throws VMFException {
        if (null == asn.oIgpAttr) {
            return;
        }
        this.qasnIgpAttrTranslator.decode((FStruct)asn.oIgpAttr, (Object)mo, context);
    }

    private void decodeOOptimizationAttr(QAsnRsvpTeAttr asn, RsvpTeTunnelAdv mo, IAsnTranslationContext context) throws VMFException {
        if (null == asn.oOptimizationAttr) {
            return;
        }
        this.qasnOptimizationAttrTranslator.decode((FStruct)asn.oOptimizationAttr, (Object)mo, context);
    }

    private void decodeOPathConstraintAttr(QAsnRsvpTeAttr asn, RsvpTeTunnel mo, IAsnTranslationContext context) throws VMFException {
        if (null == asn.oPathConstraintAttr) {
            return;
        }
        this.qasnPathConstraintAttrTranslator.decode((FStruct)asn.oPathConstraintAttr, (Object)mo, context);
    }

    private void encodeOCreateAttr(RsvpTeTunnelAdv mo, QAsnRsvpTeAttr asn, IAsnTranslationContext context) throws VMFException {
        if (null == asn.oCreateAttr) {
            asn.oCreateAttr = new QAsnCreateAttr();
            AsnUtil.setDefaultAsnValue((FStruct)asn.oCreateAttr);
        }
        this.qasnCreateAttrTranslator.encode((Object)mo, (FStruct)asn.oCreateAttr, context);
    }

    private void encodeOIgpAttr(RsvpTeTunnelAdv mo, QAsnRsvpTeAttr asn, IAsnTranslationContext context) throws VMFException {
        if (null == asn.oIgpAttr) {
            asn.oIgpAttr = new QAsnIgpAttr();
            AsnUtil.setDefaultAsnValue((FStruct)asn.oIgpAttr);
        }
        this.qasnIgpAttrTranslator.encode((Object)mo, (FStruct)asn.oIgpAttr, context);
    }

    private void encodeOOptimizationAttr(RsvpTeTunnelAdv mo, QAsnRsvpTeAttr asn, IAsnTranslationContext context) throws VMFException {
        if (null == asn.oOptimizationAttr) {
            asn.oOptimizationAttr = new QAsnOptimizationAttr();
            AsnUtil.setDefaultAsnValue((FStruct)asn.oOptimizationAttr);
        }
        this.qasnOptimizationAttrTranslator.encode((Object)mo, (FStruct)asn.oOptimizationAttr, context);
    }

    private void encodeOPathConstraintAttr(RsvpTeTunnel mo, QAsnRsvpTeAttr asn, IAsnTranslationContext context) throws VMFException {
        if (null == asn.oPathConstraintAttr) {
            asn.oPathConstraintAttr = new QAsnPathConstraintAttr();
            AsnUtil.setDefaultAsnValue((FStruct)asn.oPathConstraintAttr);
        }
        this.qasnPathConstraintAttrTranslator.encode((Object)mo, (FStruct)asn.oPathConstraintAttr, context);
    }

    private void encodeReverseLspAttr(RsvpTeTunnel mo, QAsnRsvpTeAttr asn, IAsnTranslationContext context) {
        List reverseRsvpTeLsps = mo.getKeyRefMos(ReverseRsvpTeLsp.class);
        if (CollectionUtils.isEmpty((Collection)reverseRsvpTeLsps)) {
            return;
        }
        ReverseRsvpTeLsp reverseRsvpTeLsp = (ReverseRsvpTeLsp)reverseRsvpTeLsps.iterator().next();
        if (reverseRsvpTeLsp == null) {
            return;
        }
        asn.poReverseLspAttr = new QAsnReverseLspAttr();
        asn.poReverseLspAttr.iTunnelID = AsnUtil.intValue((Integer)reverseRsvpTeLsp.getReverseLspTunnelId());
        asn.poReverseLspAttr.strPeerLsrID = AsnUtil.getBytes((String)reverseRsvpTeLsp.getReverseLspIngressLsrId());
        if (context.getTransactionContext() == null) {
            return;
        }
        IMOChangeRecord changeRecord = context.getTransactionContext().getChangeRecord(ReverseRsvpTeLsp.class);
        if (changeRecord == null) {
            return;
        }
        if (changeRecord.isDeleted((Object)reverseRsvpTeLsp)) {
            asn.poReverseLspAttr = null;
        }
        if (!changeRecord.isChanged((Object)reverseRsvpTeLsp)) {
            return;
        }
        asn.poOperMask = this.getOperMask(asn.poOperMask, 32);
    }
}

