/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.vmf.adapter.mpls.translation.asn;

import com.huawei.network.qasn.m_q_ip_common_model.QAsnPwOamAttr;
import com.huawei.vmf.adapter.common.exception.VMFException;
import com.huawei.vmf.adapter.framework.translation.asn.AbstractAsnTranslator;
import com.huawei.vmf.adapter.framework.translation.asn.IAsnTranslationContext;
import com.huawei.vmf.adapter.fservice.model.EOperationType;
import com.huawei.vmf.adapter.fservice.model.VmfMO;
import com.huawei.vmf.adapter.fservice.mpls.model.MplsOamPw;
import com.huawei.vmf.adapter.mpls.translation.asn.spec.QAsnPwOamAttrSpecTranslator;

public class QAsnPwOamAttrTranslator
extends AbstractAsnTranslator<QAsnPwOamAttr, MplsOamPw> {
    public static final int PWOAMATTR_OAMSTATE_CHG = 1;
    public static final int PWOAMATTR_CHECKWAY_CHG = 2;
    public static final int PWOAMATTR_CHECKMSGTYPE_CHG = 4;
    public static final int PWOAMATTR_CHECKFREQUE_CHG = 8;
    public static final int PWOAMATTR_SF_CHG = 16;
    public static final int PWOAMATTR_SD_CHG = 32;
    public static final int PWOAMATTR_RECVLSRID_CHG = 64;
    public static final int PWOAMATTR_SENDPWID_CHG = 128;
    public static final Object[][] z_qasnPwOamAttrMasks = new Object[][]{{"oamState", 1}, {"checkWay", 2}, {"checkMsgType", 4}, {"checkFreque", 8}, {"sf", 16}, {"sd", 32}, {"recvLsrID", 64}, {"sendPwID", 128}};
    public static final Object[][] z_mplsOamPwMasks = new Object[][]{{"oamActiveState", 1}, {"detectMode", 2}, {"detectPktType", 4}, {"detectFrequence", 8}, {"oamLossSf", 16}, {"oamLossSd", 32}, {"remoteLsrId", 64}, {"vcId", 128}};
    private QAsnPwOamAttrSpecTranslator qasnPwOamAttrSpecTranslator = new QAsnPwOamAttrSpecTranslator();
    private String fdn;

    public QAsnPwOamAttrTranslator() {
    }

    public QAsnPwOamAttrTranslator(String fdn) {
        this.fdn = fdn;
    }

    public void decode(QAsnPwOamAttr asn, MplsOamPw mo, IAsnTranslationContext context) throws VMFException {
        if (asn == null || mo == null) {
            return;
        }
        this.qasnPwOamAttrSpecTranslator.decodeKeyProperties(asn, mo, context, this.fdn);
        this.decodeMplsOamPw(asn, mo, context);
        if (this.isDelete(0, asn.poOperBit, context)) {
            return;
        }
        this.qasnPwOamAttrSpecTranslator.decodeCheckWay(asn, mo, context);
        this.qasnPwOamAttrSpecTranslator.decodeCheckMsgType(asn, mo, context);
        this.qasnPwOamAttrSpecTranslator.decodeCheckFreque(asn, mo, context);
        this.qasnPwOamAttrSpecTranslator.decodePwState(asn, mo, context);
        this.qasnPwOamAttrSpecTranslator.decodeDefectType(asn, mo, context);
    }

    public void decodeMplsOamPw(QAsnPwOamAttr asn, MplsOamPw mo, IAsnTranslationContext context) throws VMFException {
        mo.setVcId(Long.valueOf(this.longValue(asn.sendPwID)));
        mo.setPeerIp(null != asn.poPeerIP ? this.strValue(asn.poPeerIP) : this.strValue(asn.recvLsrID));
        this.qasnPwOamAttrSpecTranslator.decodeQAsnPwOamAttrSpecKeys(asn, mo, context);
        context.addProperty(MplsOamPw.class.getName(), (Object)mo);
        EOperationType operType = this.setAddOrDeleted((VmfMO)mo, 0, 0, asn.poOperBit, context);
        if (operType.equals((Object)EOperationType.DELETE)) {
            return;
        }
        mo.setOamActiveState(this.integerValue(asn.oamState, "oamActiveState", z_mplsOamPwMasks, (VmfMO)mo, context));
        if (-1 != asn.sf) {
            mo.setOamLossSf(this.longValue(asn.sf, "oamLossSf", z_mplsOamPwMasks, (VmfMO)mo, context));
        } else {
            mo.setOamLossSf(Long.valueOf(-1L));
        }
        if (-1 != asn.sd) {
            mo.setOamLossSd(this.longValue(asn.sd, "oamLossSd", z_mplsOamPwMasks, (VmfMO)mo, context));
        } else {
            mo.setOamLossSd(Long.valueOf(-1L));
        }
        mo.setFdn(this.fdn);
        mo.setDetectPktType(this.integerValue(asn.checkMsgType, "detectPktType", z_mplsOamPwMasks, (VmfMO)mo, context));
        mo.setDetectMode(this.integerValue(asn.checkWay, "detectMode", z_mplsOamPwMasks, (VmfMO)mo, context));
        mo.setRemoteLsrId(this.strValue(asn.recvLsrID, "remoteLsrId", z_mplsOamPwMasks, (VmfMO)mo, context));
        mo.setLocalInvalidTime(this.longValue(asn.forbidTime, "localInvalidTime", z_mplsOamPwMasks, (VmfMO)mo, context));
        mo.setLocalDefectLocation(this.strValue(asn.defectLocation, "localDefectLocation", z_mplsOamPwMasks, (VmfMO)mo, context));
        mo.setRemoteVcId(this.longValue(asn.poPeerPWID, "remoteVcId", z_mplsOamPwMasks, (VmfMO)mo, context));
        mo.setRemoteVcType(this.integerValue(asn.poRemotePWType, "remoteVcType", z_mplsOamPwMasks, (VmfMO)mo, context));
        mo.setDetectFrequence(this.integerValue(asn.checkFreque, "detectFrequence", z_mplsOamPwMasks, (VmfMO)mo, context));
        mo.setLocalDefectType(Integer.valueOf(-1));
        mo.setLocalDetectStatus(Integer.valueOf(-1));
        this.setChanged((VmfMO)mo, z_mplsOamPwMasks, asn.poOperBit, context);
    }

    public void encode(MplsOamPw mo, QAsnPwOamAttr asn, IAsnTranslationContext context) throws VMFException {
        if (asn == null || mo == null) {
            return;
        }
        context.addProperty(MplsOamPw.class.getName(), (Object)mo);
        this.qasnPwOamAttrSpecTranslator.encodeKeyProperties(mo, asn, context);
        this.encodeMplsOamPw(mo, asn, context);
        this.qasnPwOamAttrSpecTranslator.encodeCheckWay(mo, asn, context);
        this.qasnPwOamAttrSpecTranslator.encodeCheckMsgType(mo, asn, context);
        this.qasnPwOamAttrSpecTranslator.encodeCheckFreque(mo, asn, context);
        this.qasnPwOamAttrSpecTranslator.encodePwState(mo, asn, context);
        this.qasnPwOamAttrSpecTranslator.encodeDefectType(mo, asn, context);
    }

    public void encodeMplsOamPw(MplsOamPw mo, QAsnPwOamAttr asn, IAsnTranslationContext context) throws VMFException {
        int mask = 0;
        asn.sendPwID = this.intValue(mo.getVcId());
        asn.poPeerIP = this.getBytes(mo.getPeerIp());
        asn.oamState = this.intValue(mo.getOamActiveState());
        asn.sf = this.intValue(mo.getOamLossSf());
        asn.sd = this.intValue(mo.getOamLossSd());
        asn.recvLsrID = this.getBytes(mo.getRemoteLsrId());
        asn.forbidTime = this.intValue(mo.getLocalInvalidTime());
        asn.defectLocation = this.intValue(mo.getLocalDefectLocation());
        asn.poPeerPWID = this.intValue(mo.getRemoteVcId());
        asn.poRemotePWType = this.intValue(mo.getRemoteVcType());
        asn.checkMsgType = this.intValue(mo.getDetectPktType());
        asn.checkWay = this.intValue(mo.getDetectMode());
        asn.checkFreque = this.intValue(mo.getDetectFrequence());
        asn.poOperBit = this.getOperMask(asn.poOperBit, mask |= this.setChangeMask((VmfMO)mo, context, z_mplsOamPwMasks));
    }

    public Class<QAsnPwOamAttr> getAsnClass() {
        return QAsnPwOamAttr.class;
    }

    public Class<MplsOamPw> getMoClass() {
        return MplsOamPw.class;
    }
}

