/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.vmf.adapter.mpls.translation.asn;

import com.huawei.network.qasn.m_q_ip_tunnel_model.QAsnAffinityAttr;
import com.huawei.network.qasn.m_q_ip_tunnel_model.QAsnHopLimitAttr;
import com.huawei.network.qasn.m_q_ip_tunnel_model.QAsnPathConstraintAttr;
import com.huawei.network.qasn.m_q_ip_tunnel_model.QAsnTunnelExPathAttr;
import com.huawei.vmf.adapter.common.exception.VMFException;
import com.huawei.vmf.adapter.framework.translation.asn.AbstractAsnTranslator;
import com.huawei.vmf.adapter.framework.translation.asn.IAsnTranslationContext;
import com.huawei.vmf.adapter.framework.translation.asn.IAsnTranslator;
import com.huawei.vmf.adapter.fservice.model.EOperationType;
import com.huawei.vmf.adapter.fservice.model.VmfMO;
import com.huawei.vmf.adapter.fservice.mpls.model.RsvpTeTunnel;
import com.huawei.vmf.adapter.fservice.mpls.model.RsvpTeTunnelPathConstraint;
import com.huawei.vmf.adapter.mpls.translation.asn.QAsnAffinityAttrTranslator;
import com.huawei.vmf.adapter.mpls.translation.asn.QAsnHopLimitAttrTranslator;
import com.huawei.vmf.adapter.mpls.translation.asn.QAsnTunnelExPathAttrTranslator;
import com.huawei.vmf.adapter.mpls.translation.asn.spec.QAsnPathConstraintAttrSpecTranslator;
import java.util.Vector;

public class QAsnPathConstraintAttrTranslator
extends AbstractAsnTranslator<QAsnPathConstraintAttr, RsvpTeTunnel> {
    public static final int RI_ITIEBREAKINGTYPE_CHG = 8;
    public static final int RI_LSTAFFINITYATTR_CHG = 4;
    public static final int RI_LSTHOPLIMITATTR_CHG = 16;
    public static final int RI_LSTTUNNELEXPATHATTR_CHG = 1;
    public static final int RI_LSTTUNNELEXPATHHOPATTR_CHG = 2;
    public static final Object[][] z_explicitPathMasks = new Object[0][];
    public static final Object[][] z_qasnPathConstraintAttrMasks = new Object[][]{{"lstTunnelExPathAttr", 1}, {"lstTunnelExpathHopAttr", 2}, {"lstAffinityAttr", 4}, {"iTieBreakingType", 8}, {"lstHopLimitAttr", 16}};
    public static final Object[][] z_rsvpTeTunnelMasks = new Object[][]{{"com.huawei.vmf.adapter.fservice.mpls.model.RsvpTeTunnel", 1}, {"com.huawei.vmf.adapter.fservice.mpls.model.RsvpTeTunnel", 4}, {"com.huawei.vmf.adapter.fservice.mpls.model.RsvpTeTunnel", 16}};
    public static final Object[][] z_rsvpTeTunnelPathConstraintMasks = new Object[][]{{"tieBreaking", 8}};
    private IAsnTranslator<QAsnAffinityAttr, RsvpTeTunnel> qasnAffinityAttrTranslator = new QAsnAffinityAttrTranslator();
    private IAsnTranslator<QAsnHopLimitAttr, RsvpTeTunnel> qasnHopLimitAttrTranslator = new QAsnHopLimitAttrTranslator();
    private QAsnPathConstraintAttrSpecTranslator qasnPathConstraintAttrSpecTranslator = new QAsnPathConstraintAttrSpecTranslator();
    private IAsnTranslator<QAsnTunnelExPathAttr, RsvpTeTunnel> qasnTunnelExPathAttrTranslator = new QAsnTunnelExPathAttrTranslator();

    public void decode(QAsnPathConstraintAttr asn, RsvpTeTunnel mo, IAsnTranslationContext context) throws VMFException {
        if (asn == null || mo == null) {
            return;
        }
        this.qasnPathConstraintAttrSpecTranslator.decodeKeyProperties(asn, mo, context);
        this.decodeRsvpTeTunnel(asn, mo, context);
        this.qasnPathConstraintAttrSpecTranslator.decodeKeyRefMoExplicitPath(asn, mo, context);
        if (this.isDelete(0, asn.poOperMask, context)) {
            return;
        }
        RsvpTeTunnelPathConstraint rsvpTeTunnelPathConstraint = mo.getRsvpTeTunnelPathConstraint();
        if (null == rsvpTeTunnelPathConstraint) {
            rsvpTeTunnelPathConstraint = new RsvpTeTunnelPathConstraint();
            mo.setRsvpTeTunnelPathConstraint(rsvpTeTunnelPathConstraint);
        }
        this.decodeRsvpTeTunnelPathConstraint(asn, rsvpTeTunnelPathConstraint, context);
        this.setChanged((VmfMO)mo, "rsvpTeTunnelPathConstraint", (VmfMO)rsvpTeTunnelPathConstraint, context);
        if (this.isDelete(0, asn.poOperMask, context)) {
            return;
        }
    }

    public void decodeRsvpTeTunnel(QAsnPathConstraintAttr asn, RsvpTeTunnel mo, IAsnTranslationContext context) throws VMFException {
        this.qasnPathConstraintAttrSpecTranslator.decodeQAsnPathConstraintAttrSpecKeys(asn, mo, context);
        if (this.isDelete(0, asn.poOperMask, context)) {
            return;
        }
        this.decodeLstTunnelExPathAttr(asn, mo, context);
        this.decodeLstAffinityAttr(asn, mo, context);
        this.decodeLstHopLimitAttr(asn, mo, context);
        this.setChanged((VmfMO)mo, z_rsvpTeTunnelMasks, asn.poOperMask, context);
    }

    public void decodeRsvpTeTunnelPathConstraint(QAsnPathConstraintAttr asn, RsvpTeTunnelPathConstraint mo, IAsnTranslationContext context) throws VMFException {
        RsvpTeTunnel rsvpTeTunnel = (RsvpTeTunnel)context.getProperty(RsvpTeTunnel.class.getName());
        mo.setDevID(rsvpTeTunnel.getDevID());
        mo.setVrID(rsvpTeTunnel.getVrID());
        mo.setTunnelName(rsvpTeTunnel.getTunnelName());
        context.addProperty(RsvpTeTunnelPathConstraint.class.getName(), (Object)mo);
        EOperationType operType = this.setAddOrDeleted((VmfMO)mo, 0, 0, asn.poOperMask, context);
        if (operType.equals((Object)EOperationType.DELETE)) {
            return;
        }
        mo.setTieBreaking(this.integerValue(asn.iTieBreakingType, "tieBreaking", z_rsvpTeTunnelPathConstraintMasks, (VmfMO)mo, context));
        this.setChanged((VmfMO)mo, z_rsvpTeTunnelPathConstraintMasks, asn.poOperMask, context);
    }

    public void encode(RsvpTeTunnel mo, QAsnPathConstraintAttr asn, IAsnTranslationContext context) throws VMFException {
        if (asn == null || mo == null) {
            return;
        }
        this.qasnPathConstraintAttrSpecTranslator.encodeKeyProperties(mo, asn, context);
        this.encodeRsvpTeTunnel(mo, asn, context);
        this.qasnPathConstraintAttrSpecTranslator.encodeKeyRefMoExplicitPath(mo, asn, context);
        RsvpTeTunnelPathConstraint rsvpTeTunnelPathConstraint = mo.getRsvpTeTunnelPathConstraint();
        if (null != rsvpTeTunnelPathConstraint) {
            this.encodeRsvpTeTunnelPathConstraint(rsvpTeTunnelPathConstraint, asn, context);
        }
    }

    public void encodeRsvpTeTunnel(RsvpTeTunnel mo, QAsnPathConstraintAttr asn, IAsnTranslationContext context) throws VMFException {
        int mask = 0;
        mask |= this.setChangeMask((VmfMO)mo, context, z_rsvpTeTunnelMasks);
        this.encodeLstTunnelExPathAttr(mo, asn, context);
        mask |= this.getChangeMask((Vector)asn.lstTunnelExPathAttr, z_qasnPathConstraintAttrMasks, "lstTunnelExPathAttr");
        this.encodeLstAffinityAttr(mo, asn, context);
        mask |= this.getChangeMask((Vector)asn.lstAffinityAttr, z_qasnPathConstraintAttrMasks, "lstAffinityAttr");
        this.encodeLstHopLimitAttr(mo, asn, context);
        asn.poOperMask = this.getOperMask(asn.poOperMask, mask |= this.getChangeMask((Vector)asn.lstHopLimitAttr, z_qasnPathConstraintAttrMasks, "lstHopLimitAttr"));
    }

    public void encodeRsvpTeTunnelPathConstraint(RsvpTeTunnelPathConstraint mo, QAsnPathConstraintAttr asn, IAsnTranslationContext context) throws VMFException {
        int mask = 0;
        asn.iTieBreakingType = this.intValue(mo.getTieBreaking());
        asn.poOperMask = this.getOperMask(asn.poOperMask, mask |= this.setChangeMask((VmfMO)mo, context, z_rsvpTeTunnelPathConstraintMasks));
    }

    public Class<QAsnPathConstraintAttr> getAsnClass() {
        return QAsnPathConstraintAttr.class;
    }

    public Class<RsvpTeTunnel> getMoClass() {
        return RsvpTeTunnel.class;
    }

    private void decodeLstAffinityAttr(QAsnPathConstraintAttr asn, RsvpTeTunnel mo, IAsnTranslationContext context) throws VMFException {
        this.qasnPathConstraintAttrSpecTranslator.decodeLstAffinityAttr(asn, mo, context);
    }

    private void decodeLstHopLimitAttr(QAsnPathConstraintAttr asn, RsvpTeTunnel mo, IAsnTranslationContext context) throws VMFException {
        this.qasnPathConstraintAttrSpecTranslator.decodeLstHopLimitAttr(asn, mo, context);
    }

    private void decodeLstTunnelExPathAttr(QAsnPathConstraintAttr asn, RsvpTeTunnel mo, IAsnTranslationContext context) throws VMFException {
        this.qasnPathConstraintAttrSpecTranslator.decodeLstTunnelExPathAttr(asn, mo, context);
    }

    private void encodeLstAffinityAttr(RsvpTeTunnel mo, QAsnPathConstraintAttr asn, IAsnTranslationContext context) throws VMFException {
        this.qasnPathConstraintAttrSpecTranslator.encodeLstAffinityAttr(mo, asn, context);
    }

    private void encodeLstHopLimitAttr(RsvpTeTunnel mo, QAsnPathConstraintAttr asn, IAsnTranslationContext context) throws VMFException {
        this.qasnPathConstraintAttrSpecTranslator.encodeLstHopLimitAttr(mo, asn, context);
    }

    private void encodeLstTunnelExPathAttr(RsvpTeTunnel mo, QAsnPathConstraintAttr asn, IAsnTranslationContext context) throws VMFException {
        this.qasnPathConstraintAttrSpecTranslator.encodeLstTunnelExPathAttr(mo, asn, context);
    }
}

