/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.vmf.adapter.mpls.translation.asn;

import com.huawei.network.qasn.m_q_ip_tunnel_model.QAsnBWReoptimizationAttr;
import com.huawei.network.qasn.m_q_ip_tunnel_model.QAsnOptimizationAttr;
import com.huawei.vmf.adapter.common.exception.VMFException;
import com.huawei.vmf.adapter.common.utilty.AsnUtil;
import com.huawei.vmf.adapter.framework.translation.asn.AbstractAsnTranslator;
import com.huawei.vmf.adapter.framework.translation.asn.IAsnTranslationContext;
import com.huawei.vmf.adapter.framework.translation.asn.IAsnTranslator;
import com.huawei.vmf.adapter.fservice.model.EOperationType;
import com.huawei.vmf.adapter.fservice.model.VmfMO;
import com.huawei.vmf.adapter.fservice.mpls.model.RsvpTeTunnel;
import com.huawei.vmf.adapter.fservice.mpls.model.RsvpTeTunnelAdv;
import com.huawei.vmf.adapter.mpls.translation.asn.QAsnBWReoptimizationAttrTranslator;
import com.huawei.vmf.adapter.mpls.translation.asn.spec.QAsnOptimizationAttrSpecTranslator;
import net.commustru.fstru.FStruct;

public class QAsnOptimizationAttrTranslator
extends AbstractAsnTranslator<QAsnOptimizationAttr, RsvpTeTunnelAdv> {
    public static final int RI_IFREQUENCY_CHG = 4;
    public static final int RI_IREOPTIMIZATIONENABLE_CHG = 2;
    public static final int RI_IROUTEPINNINGENABLE_CHG = 1;
    public static final int RI_OBWREOPTIMIZATION_CHG = 8;
    public static final Object[][] z_qasnOptimizationAttrMasks = new Object[][]{{"iRoutePinningEnable", 1}, {"iReoptimizationEnable", 2}, {"iFrequency", 4}, {"oBWReoptimization", 8}};
    public static final Object[][] z_rsvpTeTunnelAdvMasks = new Object[][]{{"reoptimization", 2}, {"reoptiFrequency", 4}};
    private IAsnTranslator<QAsnBWReoptimizationAttr, RsvpTeTunnelAdv> qasnBWReoptimizationAttrTranslator = new QAsnBWReoptimizationAttrTranslator();
    private QAsnOptimizationAttrSpecTranslator qasnOptimizationAttrSpecTranslator = new QAsnOptimizationAttrSpecTranslator();

    public void decode(QAsnOptimizationAttr asn, RsvpTeTunnelAdv mo, IAsnTranslationContext context) throws VMFException {
        if (asn == null || mo == null) {
            return;
        }
        this.decodeRsvpTeTunnelAdv(asn, mo, context);
        if (this.isDelete(0, asn.poOperMask, context)) {
            return;
        }
        this.qasnOptimizationAttrSpecTranslator.decodeIRoutePinningEnable(asn, mo, context);
        this.qasnOptimizationAttrSpecTranslator.decodeIReoptimizationEnable(asn, mo, context);
    }

    public void decodeRsvpTeTunnelAdv(QAsnOptimizationAttr asn, RsvpTeTunnelAdv mo, IAsnTranslationContext context) throws VMFException {
        RsvpTeTunnel rsvpTeTunnel = (RsvpTeTunnel)context.getProperty(RsvpTeTunnel.class.getName());
        mo.setDevID(rsvpTeTunnel.getDevID());
        mo.setVrID(rsvpTeTunnel.getVrID());
        mo.setTunnelName(rsvpTeTunnel.getTunnelName());
        context.addProperty(RsvpTeTunnelAdv.class.getName(), (Object)mo);
        EOperationType operType = this.setAddOrDeleted((VmfMO)mo, 0, 0, asn.poOperMask, context);
        if (operType.equals((Object)EOperationType.DELETE)) {
            return;
        }
        this.decodeOBWReoptimization(asn, mo, context);
        this.setChanged((VmfMO)mo, z_rsvpTeTunnelAdvMasks, asn.poOperMask, context);
    }

    public void encode(RsvpTeTunnelAdv mo, QAsnOptimizationAttr asn, IAsnTranslationContext context) throws VMFException {
        if (asn == null || mo == null) {
            return;
        }
        this.encodeRsvpTeTunnelAdv(mo, asn, context);
        this.qasnOptimizationAttrSpecTranslator.encodeIRoutePinningEnable(mo, asn, context);
        this.qasnOptimizationAttrSpecTranslator.encodeIReoptimizationEnable(mo, asn, context);
    }

    public void encodeRsvpTeTunnelAdv(RsvpTeTunnelAdv mo, QAsnOptimizationAttr asn, IAsnTranslationContext context) throws VMFException {
        int mask = 0;
        asn.iFrequency = this.intValue(mo.getReoptiFrequency());
        mask |= this.setChangeMask((VmfMO)mo, context, z_rsvpTeTunnelAdvMasks);
        this.encodeOBWReoptimization(mo, asn, context);
        asn.poOperMask = this.getOperMask(asn.poOperMask, mask |= this.setChangeMask(asn.oBWReoptimization.poOperMask, z_qasnOptimizationAttrMasks, "oBWReoptimization"));
    }

    public Class<QAsnOptimizationAttr> getAsnClass() {
        return QAsnOptimizationAttr.class;
    }

    public Class<RsvpTeTunnelAdv> getMoClass() {
        return RsvpTeTunnelAdv.class;
    }

    private void decodeOBWReoptimization(QAsnOptimizationAttr asn, RsvpTeTunnelAdv mo, IAsnTranslationContext context) throws VMFException {
        if (null == asn.oBWReoptimization) {
            return;
        }
        this.qasnBWReoptimizationAttrTranslator.decode((FStruct)asn.oBWReoptimization, (Object)mo, context);
    }

    private void encodeOBWReoptimization(RsvpTeTunnelAdv mo, QAsnOptimizationAttr asn, IAsnTranslationContext context) throws VMFException {
        if (null == asn.oBWReoptimization) {
            asn.oBWReoptimization = new QAsnBWReoptimizationAttr();
            AsnUtil.setDefaultAsnValue((FStruct)asn.oBWReoptimization);
        }
        this.qasnBWReoptimizationAttrTranslator.encode((Object)mo, (FStruct)asn.oBWReoptimization, context);
    }
}

