/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.vmf.adapter.mpls.translation.asn;

import com.huawei.network.qasn.m_q_ip_common_model.QAsnMplsInfo;
import com.huawei.vmf.adapter.common.exception.VMFException;
import com.huawei.vmf.adapter.extendpoint.mpls.translation.asn.IQAsnMplsCommonCfgTranslator;
import com.huawei.vmf.adapter.framework.translation.asn.AbstractAsnTranslator;
import com.huawei.vmf.adapter.framework.translation.asn.IAsnTranslationContext;
import com.huawei.vmf.adapter.fservice.model.VmfMO;
import com.huawei.vmf.adapter.fservice.mpls.model.MplsCommonCfg;
import com.huawei.vmf.adapter.mpls.translation.asn.spec.QAsnMplsInfoSpecTranslator;
import com.huawei.vmf.common.extendpoint.ExtendPointServiceMgr;

public class QAsnMplsInfoTranslator
extends AbstractAsnTranslator<QAsnMplsInfo, MplsCommonCfg> {
    public static final int LDP_PEER_MASK = 128;
    public static final Object[][] z_ldpInstanceMasks = new Object[0][];
    public static final Object[][] z_mplsCommonCfgMasks = new Object[0][];
    public static final Object[][] z_mplsTeSiteMasks = new Object[0][];
    public static final Object[][] z_qasnMplsInfoMasks = new Object[0][];
    private static final Integer ENABLE_VALUE = 1;
    private QAsnMplsInfoSpecTranslator qasnMplsInfoSpecTranslator = new QAsnMplsInfoSpecTranslator();

    public void decode(QAsnMplsInfo asn, MplsCommonCfg mo, IAsnTranslationContext context) throws VMFException {
        if (asn == null || mo == null) {
            return;
        }
        this.qasnMplsInfoSpecTranslator.decodeKeyProperties(asn, mo, context);
        this.decodeMplsCommonCfg(asn, mo, context);
        this.qasnMplsInfoSpecTranslator.decodeKeyRefMoMplsTeSite(asn, mo, context);
        this.qasnMplsInfoSpecTranslator.decodeKeyRefMoLdpInstance(asn, mo, context);
        if (this.isDelete(0, asn.poOperbit, context)) {
            return;
        }
        this.qasnMplsInfoSpecTranslator.decodeIL2VPN(asn, mo, context);
    }

    public void decodeMplsCommonCfg(QAsnMplsInfo asn, MplsCommonCfg mo, IAsnTranslationContext context) throws VMFException {
        mo.setMplsEnable(this.enableValue(asn.iMpls, "mplsEnable", z_mplsCommonCfgMasks, mo, context));
        mo.setLdpEnable(this.enableValue(asn.iMplsLdp, "ldpEnable", z_mplsCommonCfgMasks, mo, context));
        mo.setTeEnable(this.enableValue(asn.iMplsTe, "teEnable", z_mplsCommonCfgMasks, mo, context));
        mo.setRsvpTeEnable(this.enableValue(asn.iRsvpTe, "rsvpTeEnable", z_mplsCommonCfgMasks, mo, context));
        mo.setMplsLsrID(this.strValue(asn.poiLSRID, "mplsLsrID", z_mplsCommonCfgMasks, (VmfMO)mo, context));
        mo.setNullLableType(this.integerValue(asn.poiPHPMode, "nullLableType", z_mplsCommonCfgMasks, (VmfMO)mo, context));
        this.setChanged((VmfMO)mo, z_mplsCommonCfgMasks, asn.poOperbit, context);
    }

    public void encode(MplsCommonCfg mo, QAsnMplsInfo asn, IAsnTranslationContext context) throws VMFException {
        if (asn == null || mo == null) {
            return;
        }
        this.qasnMplsInfoSpecTranslator.encodeKeyProperties(mo, asn, context);
        this.encodeMplsCommonCfg(mo, asn, context);
        this.qasnMplsInfoSpecTranslator.encodeKeyRefMoMplsTeSite(mo, asn, context);
        this.qasnMplsInfoSpecTranslator.encodeKeyRefMoLdpInstance(mo, asn, context);
        this.qasnMplsInfoSpecTranslator.encodeIL2VPN(mo, asn, context);
    }

    public void encodeMplsCommonCfg(MplsCommonCfg mo, QAsnMplsInfo asn, IAsnTranslationContext context) throws VMFException {
        int mask = 0;
        Object extPoint = ExtendPointServiceMgr.getInstance().getExtendPoitService(IQAsnMplsCommonCfgTranslator.class);
        if (null != extPoint) {
            asn.iMpls = this.intValue(((IQAsnMplsCommonCfgTranslator)extPoint).getMplsEnable());
            asn.iMplsTe = this.intValue(((IQAsnMplsCommonCfgTranslator)extPoint).getTeEnable());
        } else {
            asn.iMpls = this.intValue(mo.getMplsEnable());
            asn.iMplsTe = this.intValue(mo.getTeEnable());
        }
        asn.iMplsLdp = this.intValue(mo.getLdpEnable());
        asn.iRsvpTe = this.intValue(mo.getRsvpTeEnable());
        asn.poiLSRID = this.getBytes(mo.getMplsLsrID());
        asn.poiPHPMode = this.intValue(mo.getNullLableType());
        asn.poOperbit = this.getOperMask(asn.poOperbit, mask |= this.setChangeMask((VmfMO)mo, context, z_mplsCommonCfgMasks));
    }

    public Class<QAsnMplsInfo> getAsnClass() {
        return QAsnMplsInfo.class;
    }

    public Class<MplsCommonCfg> getMoClass() {
        return MplsCommonCfg.class;
    }

    private <T extends VmfMO> Boolean enableValue(Integer asnAttrValue, String moAttrName, Object[][] moAttrMasks, T mo, IAsnTranslationContext context) {
        if (ENABLE_VALUE.equals(asnAttrValue)) {
            return this.parseBoolean(asnAttrValue, moAttrName, moAttrMasks, mo, context);
        }
        return this.parseBoolean(asnAttrValue);
    }
}

