/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.vmf.adapter.mpls.translation.asn;

import com.huawei.network.qasn.m_q_ip_tunnel_model.QAsnMplsBFDAttr;
import com.huawei.vmf.adapter.common.utilty.StringUtil;
import com.huawei.vmf.adapter.framework.capability.AttrCapabilityInfo;
import com.huawei.vmf.adapter.framework.capability.CapabilityInfo;
import com.huawei.vmf.adapter.framework.translation.asn.AbstractAsnTranslator;
import com.huawei.vmf.adapter.framework.translation.asn.IAsnTranslationContext;
import com.huawei.vmf.adapter.fservice.model.EOperationType;
import com.huawei.vmf.adapter.fservice.model.VmfMO;
import com.huawei.vmf.adapter.fservice.mpls.model.RsvpTeTunnel;
import com.huawei.vmf.adapter.fservice.mpls.model.RsvpTeTunnelBfd;
import com.huawei.vmf.adapter.mpls.common.MplsUtil;
import com.huawei.vmf.adapter.mpls.translation.asn.spec.QAsnMplsBFDAttrSpecTranslator;
import com.huawei.vmf.common.exception.VMFException;
import org.apache.commons.lang.ObjectUtils;

public class QAsnMplsBFDAttrTranslator
extends AbstractAsnTranslator<QAsnMplsBFDAttr, RsvpTeTunnelBfd> {
    private static final int DEFAULT_BFD_INTERVAL = 10;
    public static final int DETECTMULTIPIER_CHG = 1;
    public static final int ENABLETYPE_CHG = 8;
    public static final int MINRCVINTERVAL_CHG = 2;
    public static final int MINSENDINTERVAL_CHG = 4;
    public static final Object[][] z_qasnMplsBFDAttrMasks = new Object[0][];
    public static final Object[][] z_rsvpTeTunnelBfdMasks = new Object[][]{{"mplsTeTunnelBfdMinTx", 4}, {"mplsTeTunnelBfdMinnRx", 2}, {"mplsTeTunnelBfdEnable", 8}, {"mplsTeTunnelBfdDetectMultiplier", 1}};
    private QAsnMplsBFDAttrSpecTranslator qasnMplsBFDAttrSpecTranslator = new QAsnMplsBFDAttrSpecTranslator();

    public void decode(QAsnMplsBFDAttr asn, RsvpTeTunnelBfd mo, IAsnTranslationContext context) throws com.huawei.vmf.adapter.common.exception.VMFException {
        if (asn == null || mo == null) {
            return;
        }
        this.decodeRsvpTeTunnelBfd(asn, mo, context);
        if (this.isDelete(0, asn.poOperMask, context)) {
            return;
        }
        this.qasnMplsBFDAttrSpecTranslator.decodeEnableType(asn, mo, context);
    }

    public void decodeRsvpTeTunnelBfd(QAsnMplsBFDAttr asn, RsvpTeTunnelBfd mo, IAsnTranslationContext context) throws com.huawei.vmf.adapter.common.exception.VMFException {
        RsvpTeTunnel rsvpTeTunnel = (RsvpTeTunnel)context.getProperty(RsvpTeTunnel.class.getName());
        mo.setDevID(rsvpTeTunnel.getDevID());
        mo.setVrID(rsvpTeTunnel.getVrID());
        mo.setTunnelName(rsvpTeTunnel.getTunnelName());
        context.addProperty(RsvpTeTunnelBfd.class.getName(), (Object)mo);
        EOperationType operType = this.setAddOrDeleted((VmfMO)mo, 0, 0, asn.poOperMask, context);
        if (operType.equals((Object)EOperationType.DELETE)) {
            return;
        }
        mo.setMplsTeTunnelBfdDetectMultiplier(this.longValue(asn.detectMultiplier, "mplsTeTunnelBfdDetectMultiplier", z_rsvpTeTunnelBfdMasks, (VmfMO)mo, context));
        mo.setMplsTeTunnelBfdMinnRx(this.longValue(asn.minReceiveInterval, "mplsTeTunnelBfdMinnRx", z_rsvpTeTunnelBfdMasks, (VmfMO)mo, context));
        mo.setMplsTeTunnelBfdMinTx(this.longValue(asn.minSendInterval, "mplsTeTunnelBfdMinTx", z_rsvpTeTunnelBfdMasks, (VmfMO)mo, context));
        this.setChanged((VmfMO)mo, z_rsvpTeTunnelBfdMasks, asn.poOperMask, context);
    }

    public void encode(RsvpTeTunnelBfd mo, QAsnMplsBFDAttr asn, IAsnTranslationContext context) throws com.huawei.vmf.adapter.common.exception.VMFException {
        if (asn == null || mo == null) {
            return;
        }
        this.encodeRsvpTeTunnelBfd(mo, asn, context);
        this.qasnMplsBFDAttrSpecTranslator.encodeEnableType(mo, asn, context);
    }

    public void encodeRsvpTeTunnelBfd(RsvpTeTunnelBfd mo, QAsnMplsBFDAttr asn, IAsnTranslationContext context) throws com.huawei.vmf.adapter.common.exception.VMFException {
        Integer defaultV;
        int mask = 0;
        asn.detectMultiplier = this.intValue(mo.getMplsTeTunnelBfdDetectMultiplier());
        CapabilityInfo capInfo = this.getBfdCapInfo(mo);
        asn.minReceiveInterval = null == mo.getMplsTeTunnelBfdMinnRx() || -1L == mo.getMplsTeTunnelBfdMinnRx() ? ((defaultV = this.getBfdIntegerAttrDefaultValue(capInfo, "mplsTeTunnelBfdMinnRx")) != null ? defaultV : -1) : this.intValue(mo.getMplsTeTunnelBfdMinnRx());
        asn.minSendInterval = null == mo.getMplsTeTunnelBfdMinTx() || -1L == mo.getMplsTeTunnelBfdMinTx() ? ((defaultV = this.getBfdIntegerAttrDefaultValue(capInfo, "mplsTeTunnelBfdMinTx")) != null ? defaultV : -1) : this.intValue(mo.getMplsTeTunnelBfdMinTx());
        asn.poOperMask = this.getOperMask(asn.poOperMask, mask |= this.setChangeMask((VmfMO)mo, context, z_rsvpTeTunnelBfdMasks));
    }

    public Class<QAsnMplsBFDAttr> getAsnClass() {
        return QAsnMplsBFDAttr.class;
    }

    public Class<RsvpTeTunnelBfd> getMoClass() {
        return RsvpTeTunnelBfd.class;
    }

    private CapabilityInfo getBfdCapInfo(RsvpTeTunnelBfd mo) {
        try {
            return MplsUtil.getMoCapInfo((VmfMO)mo);
        }
        catch (VMFException e) {
            QAsnMplsBFDAttrTranslator.getLogger().error("getCapabilityInfo failed , devID = " + mo.getDevID(), (Throwable)e);
            return null;
        }
    }

    private Integer getBfdIntegerAttrDefaultValue(CapabilityInfo cap, String attrName) {
        if (cap == null) {
            return null;
        }
        for (AttrCapabilityInfo attr : cap.getMoAttrCapabilityInfos(RsvpTeTunnelBfd.class)) {
            if (!ObjectUtils.equals((Object)attrName, (Object)attr.getAttrName())) continue;
            Object defaultV = attr.getDefaultValue();
            if (defaultV == null) {
                return null;
            }
            if (defaultV instanceof Integer) {
                return (Integer)defaultV;
            }
            if (!(defaultV instanceof String)) {
                return null;
            }
            String ss = (String)defaultV;
            if (StringUtil.isEmpty((String)ss)) {
                return null;
            }
            try {
                return Integer.parseInt(ss);
            }
            catch (NumberFormatException e) {
                QAsnMplsBFDAttrTranslator.getLogger().error("getBfdIntegerAttrDefaultValue NumberFormatException, ss = " + ss);
            }
        }
        return null;
    }
}

