/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.vmf.adapter.mpls.translation.asn;

import com.huawei.network.qasn.m_q_ip_tunnel_model.QAsnLspHop;
import com.huawei.vmf.adapter.common.exception.VMFException;
import com.huawei.vmf.adapter.framework.translation.asn.AbstractAsnTranslator;
import com.huawei.vmf.adapter.framework.translation.asn.IAsnTranslationContext;
import com.huawei.vmf.adapter.fservice.model.EOperationType;
import com.huawei.vmf.adapter.fservice.model.VmfMO;
import com.huawei.vmf.adapter.fservice.mpls.model.BiStaticCrLspStateInfo;
import com.huawei.vmf.adapter.mpls.translation.asn.spec.QAsnLspHopSpecTranslator;

public class QAsnLspHopTranslator
extends AbstractAsnTranslator<QAsnLspHop, BiStaticCrLspStateInfo> {
    public static final int RI_IDEPLOYSTATUS_CHG = 32;
    public static final int RI_IENABLESTATUS_CHG = 64;
    public static final int RI_IINLABEL_CHG = 1;
    public static final int RI_IMTU_CHG = 512;
    public static final int RI_IOUTLABEL_CHG = 4;
    public static final int RI_IRUNSTATUS_CHG = 128;
    public static final int RI_LSTBANDWIDTHATTR_CHG = 256;
    public static final int RI_OINCOMINGIFKEY_CHG = 2;
    public static final int RI_OOUTGOINGIFKEY_CHG = 8;
    public static final int RI_STRNEXTHOP_CHG = 16;
    public static final int RI_STRUSERLABEL_CHG = 1024;
    public static final Object[][] z_biStaticCrLspStateInfoMasks = new Object[][]{{"forwardInLabel", 1}, {"forwardOutLabel", 4}, {"forwardOutIf", 8}, {"forwardNextHop", 16}, {"lspStatus", 128}};
    public static final Object[][] z_qasnLspHopMasks = new Object[][]{{"iInLabel", 1}, {"oIncomingIfKey", 2}, {"iOutLabel", 4}, {"oOutgoingIfKey", 8}, {"strNextHop", 16}, {"iDeployStatus", 32}, {"iEnableStatus", 64}, {"iRunStatus", 128}, {"lstBandWidthAttr", 256}, {"iMtu", 512}, {"userLabel", 1024}};
    private QAsnLspHopSpecTranslator qasnLspHopSpecTranslator = new QAsnLspHopSpecTranslator();

    public void decode(QAsnLspHop asn, BiStaticCrLspStateInfo mo, IAsnTranslationContext context) throws VMFException {
        if (asn == null || mo == null) {
            return;
        }
        this.qasnLspHopSpecTranslator.decodeKeyProperties(asn, mo, context);
        this.decodeBiStaticCrLspStateInfo(asn, mo, context);
        if (this.isDelete(0, asn.poOperMask, context)) {
            return;
        }
        this.qasnLspHopSpecTranslator.decodeLstBandWidthAttr(asn, mo, context);
        this.qasnLspHopSpecTranslator.decodePolstRevBandWidth(asn, mo, context);
    }

    public void decodeBiStaticCrLspStateInfo(QAsnLspHop asn, BiStaticCrLspStateInfo mo, IAsnTranslationContext context) throws VMFException {
        mo.setLspName(this.strValue(asn.strHopName));
        context.addProperty(BiStaticCrLspStateInfo.class.getName(), (Object)mo);
        EOperationType operType = this.setAddOrDeleted((VmfMO)mo, 0, 0, asn.poOperMask, context);
        if (operType.equals((Object)EOperationType.DELETE)) {
            return;
        }
        mo.setLsrRole(this.integerValue(asn.iLsrType, "lsrRole", z_biStaticCrLspStateInfoMasks, (VmfMO)mo, context));
        mo.setForwardInLabel(this.longValue(asn.iInLabel, "forwardInLabel", z_biStaticCrLspStateInfoMasks, (VmfMO)mo, context));
        mo.setForwardOutLabel(this.longValue(asn.iOutLabel, "forwardOutLabel", z_biStaticCrLspStateInfoMasks, (VmfMO)mo, context));
        mo.setForwardNextHop(this.strValue(asn.strNextHop, "forwardNextHop", z_biStaticCrLspStateInfoMasks, (VmfMO)mo, context));
        mo.setLspStatus(this.integerValue(asn.iRunStatus, "lspStatus", z_biStaticCrLspStateInfoMasks, (VmfMO)mo, context));
        mo.setBackwardInLabel(this.longValue(asn.poRevInLabel, "backwardInLabel", z_biStaticCrLspStateInfoMasks, (VmfMO)mo, context));
        mo.setBackwardOutLabel(this.longValue(asn.poRevOutLabel, "backwardOutLabel", z_biStaticCrLspStateInfoMasks, (VmfMO)mo, context));
        mo.setBackwardNextHop(this.strValue(asn.poRevNextHop, "backwardNextHop", z_biStaticCrLspStateInfoMasks, (VmfMO)mo, context));
        mo.setDeployStatus(this.integerValue(asn.iDeployStatus, "iDeployStatus", null, (VmfMO)mo, context));
        mo.setUserLabel(this.strValue(asn.userLabel, "userLabel", null, (VmfMO)mo, context));
        this.setChanged((VmfMO)mo, z_biStaticCrLspStateInfoMasks, asn.poOperMask, context);
    }

    public void encode(BiStaticCrLspStateInfo mo, QAsnLspHop asn, IAsnTranslationContext context) throws VMFException {
        if (asn == null || mo == null) {
            return;
        }
        context.addProperty(BiStaticCrLspStateInfo.class.getName(), (Object)mo);
        this.qasnLspHopSpecTranslator.encodeKeyProperties(mo, asn, context);
        this.encodeBiStaticCrLspStateInfo(mo, asn, context);
        this.qasnLspHopSpecTranslator.encodeLstBandWidthAttr(mo, asn, context);
        this.qasnLspHopSpecTranslator.encodePolstRevBandWidth(mo, asn, context);
        asn.poOperResult = this.getAsnOperResult((VmfMO)mo, context);
    }

    public void encodeBiStaticCrLspStateInfo(BiStaticCrLspStateInfo mo, QAsnLspHop asn, IAsnTranslationContext context) throws VMFException {
        int mask = 0;
        asn.strHopName = this.getBytes(mo.getLspName());
        asn.iLsrType = this.intValue(mo.getLsrRole());
        asn.iInLabel = this.intValue(mo.getForwardInLabel());
        asn.iOutLabel = this.intValue(mo.getForwardOutLabel());
        asn.strNextHop = this.getBytes(mo.getForwardNextHop());
        asn.iRunStatus = this.intValue(mo.getLspStatus());
        asn.poRevInLabel = this.intValue(mo.getBackwardInLabel());
        asn.poRevOutLabel = this.intValue(mo.getBackwardOutLabel());
        asn.poRevNextHop = this.getBytes(mo.getBackwardNextHop());
        asn.poOperMask = this.getOperMask(asn.poOperMask, mask |= this.setChangeMask((VmfMO)mo, context, z_biStaticCrLspStateInfoMasks));
        asn.iDeployStatus = mo.getDeployStatus();
        asn.userLabel = this.getBytes(mo.getUserLabel());
    }

    public Class<QAsnLspHop> getAsnClass() {
        return QAsnLspHop.class;
    }

    public Class<BiStaticCrLspStateInfo> getMoClass() {
        return BiStaticCrLspStateInfo.class;
    }
}

