/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.vmf.adapter.mpls.translation.asn;

import com.huawei.network.qasn.m_q_ip_tunnel_model.QAsnLspHop;
import com.huawei.vmf.adapter.common.exception.VMFException;
import com.huawei.vmf.adapter.common.utilty.StringUtil;
import com.huawei.vmf.adapter.framework.translation.asn.AbstractAsnTranslator;
import com.huawei.vmf.adapter.framework.translation.asn.IAsnTranslationContext;
import com.huawei.vmf.adapter.fservice.model.EOperationType;
import com.huawei.vmf.adapter.fservice.model.VmfMO;
import com.huawei.vmf.adapter.fservice.mpls.model.RsvpTeTunnel;
import com.huawei.vmf.adapter.fservice.mpls.model.StaticTunnel;
import com.huawei.vmf.adapter.mpls.common.MplsUtil;
import com.huawei.vmf.adapter.mpls.translation.asn.spec.QAsnLspHopForStaticTunnelSpecTranslator;

public class QAsnLspHopForStaticTunnelTranslator
extends AbstractAsnTranslator<QAsnLspHop, StaticTunnel> {
    public static final int RI_IDEPLOYSTATUS_CHG = 32;
    public static final int RI_IENABLESTATUS_CHG = 64;
    public static final int RI_IINLABEL_CHG = 1;
    public static final int RI_IMTU_CHG = 512;
    public static final int RI_IOUTLABEL_CHG = 4;
    public static final int RI_IRUNSTATUS_CHG = 128;
    public static final int RI_LSTBANDWIDTHATTR_CHG = 256;
    public static final int RI_OINCOMINGIFKEY_CHG = 2;
    public static final int RI_OOUTGOINGIFKEY_CHG = 8;
    public static final int RI_STRNEXTHOP_CHG = 16;
    public static final int RI_STRUSERLABEL_CHG = 1024;
    public static final int RI_REVINLABEL_CHG = 2048;
    public static final int RI_REVOUTLABEL_CHG = 4096;
    public static final int RI_REVNEXTHOP_CHG = 8192;
    public static final Object[][] z_qasnLspHopMasks = new Object[][]{{"iInLabel", 1}, {"oIncomingIfKey", 2}, {"iOutLabel", 4}, {"oOutgoingIfKey", 8}, {"strNextHop", 16}, {"iDeployStatus", 32}, {"iEnableStatus", 64}, {"iRunStatus", 128}, {"lstBandWidthAttr", 256}, {"iMtu", 512}, {"userLabel", 1024}};
    public static final Object[][] z_staticTunnelMasks = new Object[][]{{"forwardInLabel", 1}, {"incomingIfName", 2}, {"forwardOutLabel", 4}, {"outgoingIfName", 8}, {"forwardNextHop", 16}, {"deployStatus", 32}, {"iEnableStatus", 64}, {"iRunStatus", 128}, {"com.huawei.vmf.adapter.fservice.mpls.model.StaticTunnel", 256}, {"backwardInLabel", 2048}, {"backwardOutLabel", 4096}, {"backwardNextHop", 8192}, {"mtu", 512}};
    public static final int E_LSP = 1;
    private QAsnLspHopForStaticTunnelSpecTranslator qasnLspHopSpecTranslator = new QAsnLspHopForStaticTunnelSpecTranslator();

    public void decode(QAsnLspHop asn, StaticTunnel mo, IAsnTranslationContext context) throws VMFException {
        if (asn == null || mo == null) {
            return;
        }
        this.qasnLspHopSpecTranslator.decodeKeyProperties(asn, mo, context);
        this.decodeStaticTunnel(asn, mo, context);
        if (this.isDelete(0, asn.poOperMask, context)) {
            return;
        }
        this.qasnLspHopSpecTranslator.decodeLstBandWidthAttr(asn, mo, context);
        this.qasnLspHopSpecTranslator.decodePoDirection(asn, mo, context);
        this.qasnLspHopSpecTranslator.decodePoTPOam(asn, mo, context);
        this.qasnLspHopSpecTranslator.decodePoInTnlType(asn, mo, context);
        this.qasnLspHopSpecTranslator.decodeOIncomingIfKey(asn, mo, context);
        this.qasnLspHopSpecTranslator.decodePoSrcRing(asn, mo, context);
        this.qasnLspHopSpecTranslator.decodePoOutTnlType(asn, mo, context);
        this.qasnLspHopSpecTranslator.decodeOOutgoingIfKey(asn, mo, context);
        this.qasnLspHopSpecTranslator.decodePoSnkRing(asn, mo, context);
        this.qasnLspHopSpecTranslator.decodeISignalType(asn, mo, context);
        this.qasnLspHopSpecTranslator.decodeILsrType(asn, mo, context);
    }

    public void decodeStaticTunnel(QAsnLspHop asn, StaticTunnel mo, IAsnTranslationContext context) throws VMFException {
        context.addProperty(StaticTunnel.class.getName(), (Object)mo);
        EOperationType operType = this.setAddOrDeleted((VmfMO)mo, 0, 0, asn.poOperMask, context);
        if (operType.equals((Object)EOperationType.DELETE)) {
            return;
        }
        mo.setTunnelId(this.integerValue(asn.iLspID, "tunnelId", z_staticTunnelMasks, (VmfMO)mo, context));
        mo.setIngressLsrId(this.strValue(asn.strIngressLsrID, "ingressLsrId", z_staticTunnelMasks, (VmfMO)mo, context));
        mo.setEgressLsrId(this.strValue(asn.strEgressLsrID, "egressLsrId", z_staticTunnelMasks, (VmfMO)mo, context));
        mo.setForwardInLabel(this.longValue(asn.iInLabel, "forwardInLabel", z_staticTunnelMasks, (VmfMO)mo, context));
        mo.setForwardOutLabel(this.longValue(asn.iOutLabel, "forwardOutLabel", z_staticTunnelMasks, (VmfMO)mo, context));
        mo.setForwardNextHop(this.strValue(asn.strNextHop, "forwardNextHop", z_staticTunnelMasks, (VmfMO)mo, context));
        mo.setMtu(this.longValue(asn.iMtu, "mtu", z_staticTunnelMasks, (VmfMO)mo, context));
        mo.setBackwardInLabel(this.longValue(asn.poRevInLabel, "backwardInLabel", z_staticTunnelMasks, (VmfMO)mo, context));
        mo.setBackwardOutLabel(this.longValue(asn.poRevOutLabel, "backwardOutLabel", z_staticTunnelMasks, (VmfMO)mo, context));
        mo.setBackwardNextHop(this.strValue(asn.poRevNextHop, "backwardNextHop", z_staticTunnelMasks, (VmfMO)mo, context));
        if (StaticTunnel.LSR_ROLE_ENUM.TRANSIT != mo.getLsrRole()) {
            mo.setExpMode(this.integerValue(asn.poLspModel, "expMode", z_staticTunnelMasks, (VmfMO)mo, context));
        } else {
            mo.setExpMode(null);
        }
        if (null != asn.poBackupInLabel && -1 != asn.poBackupInLabel && 0 != asn.poBackupInLabel) {
            mo.setForwardBkpLabel(this.longValue(asn.poBackupInLabel, "forwardBkpLabel", z_staticTunnelMasks, (VmfMO)mo, context));
        } else {
            mo.setForwardBkpLabel(null);
        }
        if (null != asn.poBackupRevInLabel && -1 != asn.poBackupRevInLabel && 0 != asn.poBackupRevInLabel) {
            mo.setBackwardBkpLabel(this.longValue(asn.poBackupRevInLabel, "backwardBkpLabel", z_staticTunnelMasks, (VmfMO)mo, context));
        } else {
            mo.setBackwardBkpLabel(null);
        }
        this.setChanged((VmfMO)mo, z_staticTunnelMasks, asn.poOperMask, context);
    }

    public void encode(StaticTunnel mo, QAsnLspHop asn, IAsnTranslationContext context) throws VMFException {
        if (asn == null || mo == null) {
            return;
        }
        context.addProperty(StaticTunnel.class.getName(), (Object)mo);
        this.qasnLspHopSpecTranslator.encodeKeyProperties(mo, asn, context);
        this.encodeStaticTunnel(mo, asn, context);
        this.qasnLspHopSpecTranslator.encodeLstBandWidthAttr(mo, asn, context);
        this.qasnLspHopSpecTranslator.encodePoDirection(mo, asn, context);
        this.qasnLspHopSpecTranslator.encodePoTPOam(mo, asn, context);
        this.qasnLspHopSpecTranslator.encodePoInTnlType(mo, asn, context);
        this.qasnLspHopSpecTranslator.encodeOIncomingIfKey(mo, asn, context);
        this.qasnLspHopSpecTranslator.encodePoSrcRing(mo, asn, context);
        this.qasnLspHopSpecTranslator.encodePoOutTnlType(mo, asn, context);
        this.qasnLspHopSpecTranslator.encodeOOutgoingIfKey(mo, asn, context);
        this.qasnLspHopSpecTranslator.encodePoSnkRing(mo, asn, context);
        this.qasnLspHopSpecTranslator.encodeISignalType(mo, asn, context);
        this.qasnLspHopSpecTranslator.encodeILsrType(mo, asn, context);
        if (MplsUtil.isPtn()) {
            asn.poLspType = 1;
        }
        asn.poOperResult = this.getAsnOperResult((VmfMO)mo, context);
        if (StringUtil.isEmpty((String)mo.getOutgoingIfName()) && StringUtil.isEmpty((String)mo.getIncomingIfName())) {
            asn.poRevNextHop = null;
        }
        asn.iEnableStatus = null != mo.getTrafficEnable() && mo.getTrafficEnable() == false ? RsvpTeTunnel.ADMIN_STATUS_ENUM.DOWN.intValue() : RsvpTeTunnel.ADMIN_STATUS_ENUM.UP.intValue();
    }

    public void encodeStaticTunnel(StaticTunnel mo, QAsnLspHop asn, IAsnTranslationContext context) throws VMFException {
        int mask = 0;
        asn.strHopName = MplsUtil.isPtn() ? this.getBytes("") : this.getBytes(mo.getTunnelName());
        asn.iLspID = this.intValue(mo.getTunnelId());
        asn.strIngressLsrID = this.getBytes(mo.getIngressLsrId());
        asn.strEgressLsrID = this.getBytes(mo.getEgressLsrId());
        asn.iInLabel = this.intValue(mo.getForwardInLabel());
        asn.iOutLabel = this.intValue(mo.getForwardOutLabel());
        asn.strNextHop = this.getBytes(mo.getForwardNextHop());
        asn.iMtu = this.intValue(mo.getMtu());
        asn.poRevInLabel = this.intValue(mo.getBackwardInLabel());
        asn.poRevOutLabel = this.intValue(mo.getBackwardOutLabel());
        asn.poRevNextHop = this.getBytes(mo.getBackwardNextHop());
        asn.poLspModel = this.intValue(mo.getExpMode());
        asn.poBackupInLabel = this.intValue(mo.getForwardBkpLabel());
        asn.poBackupRevInLabel = this.intValue(mo.getBackwardBkpLabel());
        asn.poOperMask = this.getOperMask(asn.poOperMask, mask |= this.setChangeMask((VmfMO)mo, context, z_staticTunnelMasks));
    }

    public Class<QAsnLspHop> getAsnClass() {
        return QAsnLspHop.class;
    }

    public Class<StaticTunnel> getMoClass() {
        return StaticTunnel.class;
    }
}

