/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.vmf.adapter.mpls.translation.asn;

import com.huawei.network.qasn.m_q_ip_common_model.QAsnLdpSession;
import com.huawei.vmf.adapter.common.exception.VMFException;
import com.huawei.vmf.adapter.framework.translation.asn.AbstractAsnTranslator;
import com.huawei.vmf.adapter.framework.translation.asn.IAsnTranslationContext;
import com.huawei.vmf.adapter.fservice.model.EOperationType;
import com.huawei.vmf.adapter.fservice.model.VmfMO;
import com.huawei.vmf.adapter.fservice.mpls.model.LdpInstance;
import com.huawei.vmf.adapter.fservice.mpls.model.LdpSession;
import com.huawei.vmf.adapter.mpls.translation.asn.spec.QAsnLdpSessionSpecTranslator;

public class QAsnLdpSessionTranslator
extends AbstractAsnTranslator<QAsnLdpSession, LdpSession> {
    public static final Object[][] z_ldpSessionMasks = new Object[0][];
    public static final Object[][] z_qasnLdpSessionMasks = new Object[0][];
    private QAsnLdpSessionSpecTranslator qasnLdpSessionSpecTranslator = new QAsnLdpSessionSpecTranslator();

    public void decode(QAsnLdpSession asn, LdpSession mo, IAsnTranslationContext context) throws VMFException {
        if (asn == null || mo == null) {
            return;
        }
        this.decodeLdpSession(asn, mo, context);
        if (this.isDelete(0, null, context)) {
            return;
        }
        this.qasnLdpSessionSpecTranslator.decodeStrTCPConn(asn, mo, context);
        this.qasnLdpSessionSpecTranslator.decodeISessionFTFlag(asn, mo, context);
        this.qasnLdpSessionSpecTranslator.decodeIMD5Flag(asn, mo, context);
    }

    public void decodeLdpSession(QAsnLdpSession asn, LdpSession mo, IAsnTranslationContext context) throws VMFException {
        LdpInstance ldpInstance = (LdpInstance)context.getProperty(LdpInstance.class.getName());
        mo.setDevID(ldpInstance.getDevID());
        mo.setVrID(ldpInstance.getVrID());
        mo.setVrfName(ldpInstance.getVrfName());
        mo.setPeerLsrid(this.strValue(asn.strPeerLDPID));
        context.addProperty(LdpSession.class.getName(), (Object)mo);
        EOperationType operType = this.setAddOrDeleted((VmfMO)mo, 0, 0, context);
        if (operType.equals((Object)EOperationType.DELETE)) {
            return;
        }
        mo.setLocalLsrid(this.strValue(asn.strLocalLDPID, "localLsrid", z_ldpSessionMasks, (VmfMO)mo, context));
        mo.setSessionState(this.integerValue(asn.iSessionState, "sessionState", z_ldpSessionMasks, (VmfMO)mo, context));
        mo.setSessionRole(this.integerValue(asn.iSessionRole, "sessionRole", z_ldpSessionMasks, (VmfMO)mo, context));
        mo.setReconnetTime(this.longValue(asn.iReconnectTimer, "reconnetTime", z_ldpSessionMasks, (VmfMO)mo, context));
        mo.setRecoveryTime(this.longValue(asn.iRecoveryTimer, "recoveryTime", z_ldpSessionMasks, (VmfMO)mo, context));
        mo.setNegotiatedKaHoldTime(this.longValue(asn.iNegoKeepaliveTimer, "negotiatedKaHoldTime", z_ldpSessionMasks, (VmfMO)mo, context));
        mo.setKaSent(this.longValue(asn.iSentKeepaliveMsgCnt, "kaSent", z_ldpSessionMasks, (VmfMO)mo, context));
        mo.setKaReceived(this.longValue(asn.iRcvKeepaliveMsgCnt, "kaReceived", z_ldpSessionMasks, (VmfMO)mo, context));
        mo.setSessionDistMode(this.integerValue(asn.iLabelAdvMode, "sessionDistMode", z_ldpSessionMasks, (VmfMO)mo, context));
        mo.setPeerLabelState(this.integerValue(asn.iPeerLabelResStat, "peerLabelState", z_ldpSessionMasks, (VmfMO)mo, context));
        mo.setSessionAge(this.strValue(asn.iSessionAge, "sessionAge", z_ldpSessionMasks, (VmfMO)mo, context));
    }

    public void encode(LdpSession mo, QAsnLdpSession asn, IAsnTranslationContext context) throws VMFException {
        if (asn == null || mo == null) {
            return;
        }
        this.encodeLdpSession(mo, asn, context);
        this.qasnLdpSessionSpecTranslator.encodeStrTCPConn(mo, asn, context);
        this.qasnLdpSessionSpecTranslator.encodeISessionFTFlag(mo, asn, context);
        this.qasnLdpSessionSpecTranslator.encodeIMD5Flag(mo, asn, context);
    }

    public void encodeLdpSession(LdpSession mo, QAsnLdpSession asn, IAsnTranslationContext context) throws VMFException {
        int mask = 0;
        asn.strPeerLDPID = this.getBytes(mo.getPeerLsrid());
        asn.strLocalLDPID = this.getBytes(mo.getLocalLsrid());
        asn.iSessionState = this.intValue(mo.getSessionState());
        asn.iSessionRole = this.intValue(mo.getSessionRole());
        asn.iReconnectTimer = this.intValue(mo.getReconnetTime());
        asn.iRecoveryTimer = this.intValue(mo.getRecoveryTime());
        asn.iNegoKeepaliveTimer = this.intValue(mo.getNegotiatedKaHoldTime());
        asn.iSentKeepaliveMsgCnt = this.intValue(mo.getKaSent());
        asn.iRcvKeepaliveMsgCnt = this.intValue(mo.getKaReceived());
        asn.iLabelAdvMode = this.intValue(mo.getSessionDistMode());
        asn.iPeerLabelResStat = this.intValue(mo.getPeerLabelState());
        asn.iSessionAge = this.intValue(mo.getSessionAge());
        mask |= this.setChangeMask((VmfMO)mo, context, z_ldpSessionMasks);
    }

    public Class<QAsnLdpSession> getAsnClass() {
        return QAsnLdpSession.class;
    }

    public Class<LdpSession> getMoClass() {
        return LdpSession.class;
    }
}

