/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.vmf.adapter.mpls.translation.asn;

import com.huawei.network.qasn.m_q_ip_tunnel_model.QAsnIgpAttr;
import com.huawei.vmf.adapter.common.exception.VMFException;
import com.huawei.vmf.adapter.common.utilty.AsnUtil;
import com.huawei.vmf.adapter.framework.translation.asn.AbstractAsnTranslator;
import com.huawei.vmf.adapter.framework.translation.asn.IAsnTranslationContext;
import com.huawei.vmf.adapter.fservice.model.EOperationType;
import com.huawei.vmf.adapter.fservice.model.VmfMO;
import com.huawei.vmf.adapter.fservice.mpls.model.RsvpTeTunnel;
import com.huawei.vmf.adapter.fservice.mpls.model.RsvpTeTunnelAdv;
import com.huawei.vmf.adapter.mpls.translation.asn.spec.QAsnIgpAttrSpecTranslator;

public class QAsnIgpAttrTranslator
extends AbstractAsnTranslator<QAsnIgpAttr, RsvpTeTunnelAdv> {
    public static final int RI_IADVERTISEENABLE_CHG = 2;
    public static final int RI_IADVERTISEHOLDTIME_CHG = 4;
    public static final int RI_IIGPMETRICTYPE_CHG = 16;
    public static final int RI_IIGPMETRICVALUE_CHG = 32;
    public static final int RI_IPATHTYPE_CHG = 8;
    public static final int RI_ISHORTCUTTYPE_CHG = 1;
    public static final Object[][] z_qasnIgpAttrMasks = new Object[][]{{"iShortcutType", 1}, {"iAdvertiseEnable", 2}, {"iAdvertiseHoldTime", 4}, {"iPathType", 8}, {"iIgpMetricType", 16}, {"iIgpMetricValue", 32}};
    public static final Object[][] z_rsvpTeTunnelAdvMasks = new Object[][]{{"shortcutType", 1}, {"advertiseEnable", 2}, {"advertiseHoldTime", 4}, {"pathMetricType", 8}, {"igpMetricType", 16}};
    private QAsnIgpAttrSpecTranslator qasnIgpAttrSpecTranslator = new QAsnIgpAttrSpecTranslator();

    public void decode(QAsnIgpAttr asn, RsvpTeTunnelAdv mo, IAsnTranslationContext context) throws VMFException {
        if (asn == null || mo == null) {
            return;
        }
        this.qasnIgpAttrSpecTranslator.decodeIAdvertiseEnable(asn, mo, context);
        this.decodeRsvpTeTunnelAdv(asn, mo, context);
        if (this.isDelete(0, asn.poOperMask, context)) {
            return;
        }
        this.qasnIgpAttrSpecTranslator.decodeIIgpMetricValue(asn, mo, context);
    }

    public void decodeRsvpTeTunnelAdv(QAsnIgpAttr asn, RsvpTeTunnelAdv mo, IAsnTranslationContext context) throws VMFException {
        RsvpTeTunnel rsvpTeTunnel = (RsvpTeTunnel)context.getProperty(RsvpTeTunnel.class.getName());
        mo.setDevID(rsvpTeTunnel.getDevID());
        mo.setVrID(rsvpTeTunnel.getVrID());
        mo.setTunnelName(rsvpTeTunnel.getTunnelName());
        context.addProperty(RsvpTeTunnelAdv.class.getName(), (Object)mo);
        EOperationType operType = this.setAddOrDeleted((VmfMO)mo, 0, 0, asn.poOperMask, context);
        if (operType.equals((Object)EOperationType.DELETE)) {
            return;
        }
        mo.setShortcutType(this.integerValue(asn.iShortcutType, "shortcutType", z_rsvpTeTunnelAdvMasks, (VmfMO)mo, context));
        if (mo.getAdvertiseEnable().booleanValue()) {
            long advertiseHoldTime = AsnUtil.parseOverflowIntToLong((int)asn.iAdvertiseHoldTime);
            mo.setAdvertiseHoldTime(this.longValue(advertiseHoldTime, "advertiseHoldTime", z_rsvpTeTunnelAdvMasks, (VmfMO)mo, context));
        } else {
            mo.setAdvertiseHoldTime(this.longValue(null, "advertiseHoldTime", z_rsvpTeTunnelAdvMasks, (VmfMO)mo, context));
        }
        mo.setPathMetricType(this.integerValue(asn.iPathType, "pathMetricType", z_rsvpTeTunnelAdvMasks, (VmfMO)mo, context));
        mo.setIgpMetricType(this.integerValue(asn.iIgpMetricType, "igpMetricType", z_rsvpTeTunnelAdvMasks, (VmfMO)mo, context));
        this.setChanged((VmfMO)mo, z_rsvpTeTunnelAdvMasks, asn.poOperMask, context);
    }

    public void encode(RsvpTeTunnelAdv mo, QAsnIgpAttr asn, IAsnTranslationContext context) throws VMFException {
        if (asn == null || mo == null) {
            return;
        }
        this.encodeRsvpTeTunnelAdv(mo, asn, context);
        this.qasnIgpAttrSpecTranslator.encodeIAdvertiseEnable(mo, asn, context);
        this.qasnIgpAttrSpecTranslator.encodeIIgpMetricValue(mo, asn, context);
    }

    public void encodeRsvpTeTunnelAdv(RsvpTeTunnelAdv mo, QAsnIgpAttr asn, IAsnTranslationContext context) throws VMFException {
        int mask = 0;
        asn.iShortcutType = this.intValue(mo.getShortcutType());
        asn.iAdvertiseHoldTime = this.intValue(mo.getAdvertiseHoldTime());
        asn.iPathType = this.intValue(mo.getPathMetricType());
        asn.iIgpMetricType = this.intValue(mo.getIgpMetricType());
        asn.poOperMask = this.getOperMask(asn.poOperMask, mask |= this.setChangeMask((VmfMO)mo, context, z_rsvpTeTunnelAdvMasks));
    }

    public Class<QAsnIgpAttr> getAsnClass() {
        return QAsnIgpAttr.class;
    }

    public Class<RsvpTeTunnelAdv> getMoClass() {
        return RsvpTeTunnelAdv.class;
    }
}

