/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.vmf.adapter.mpls.translation.asn;

import com.huawei.network.qasn.m_q_ip_tunnel_model.QAsnExpath;
import com.huawei.network.qasn.m_q_ip_tunnel_model.QAsnExpathHop;
import com.huawei.network.qasn.m_q_ip_tunnel_model.QAsnExpathHopList;
import com.huawei.network.qasn.m_q_ip_tunnel_model.QAsnExpathKey;
import com.huawei.vmf.adapter.common.exception.VMFException;
import com.huawei.vmf.adapter.common.utilty.AsnUtil;
import com.huawei.vmf.adapter.framework.translation.asn.AbstractAsnTranslator;
import com.huawei.vmf.adapter.framework.translation.asn.IAsnTranslationContext;
import com.huawei.vmf.adapter.framework.translation.asn.IAsnTranslator;
import com.huawei.vmf.adapter.fservice.model.VmfMO;
import com.huawei.vmf.adapter.fservice.mpls.model.ExplicitPath;
import com.huawei.vmf.adapter.fservice.mpls.model.ExplicitPathHop;
import com.huawei.vmf.adapter.mpls.translation.asn.QAsnExpathHopTranslator;
import com.huawei.vmf.adapter.mpls.translation.asn.QAsnExpathKeyTranslator;
import com.huawei.vmf.adapter.mpls.translation.asn.spec.QAsnExpathSpecTranslator;
import java.util.Collection;
import java.util.Vector;
import net.commustru.fstru.FStruct;

public class QAsnExpathTranslator
extends AbstractAsnTranslator<QAsnExpath, ExplicitPath> {
    public static final Object[][] z_explicitPathMasks = new Object[0][];
    public static final Object[][] z_qasnExpathMasks = new Object[0][];
    private IAsnTranslator<QAsnExpathHop, ExplicitPathHop> qasnExpathHopTranslator = new QAsnExpathHopTranslator();
    private IAsnTranslator<QAsnExpathKey, ExplicitPath> qasnExpathKeyTranslator = new QAsnExpathKeyTranslator();
    private QAsnExpathSpecTranslator qasnExpathSpecTranslator = new QAsnExpathSpecTranslator();

    public void decode(QAsnExpath asn, ExplicitPath mo, IAsnTranslationContext context) throws VMFException {
        if (asn == null || mo == null) {
            return;
        }
        this.qasnExpathSpecTranslator.decodeKeyProperties(asn, mo, context);
        this.decodeExplicitPath(asn, mo, context);
        if (this.isDelete(0, null, context)) {
            return;
        }
    }

    public void decodeExplicitPath(QAsnExpath asn, ExplicitPath mo, IAsnTranslationContext context) throws VMFException {
        this.decodeOExpathKey(asn, mo, context);
        if (this.isDelete(0, null, context)) {
            return;
        }
        this.decodeLstExpathHop(asn, mo, context);
    }

    public void encode(ExplicitPath mo, QAsnExpath asn, IAsnTranslationContext context) throws VMFException {
        if (asn == null || mo == null) {
            return;
        }
        this.qasnExpathSpecTranslator.encodeKeyProperties(mo, asn, context);
        this.encodeExplicitPath(mo, asn, context);
    }

    public void encodeExplicitPath(ExplicitPath mo, QAsnExpath asn, IAsnTranslationContext context) throws VMFException {
        int mask = 0;
        mask |= this.setChangeMask((VmfMO)mo, context, z_explicitPathMasks);
        this.encodeOExpathKey(mo, asn, context);
        mask |= this.setChangeMask(0, z_qasnExpathMasks, "oExpathKey");
        this.encodeLstExpathHop(mo, asn, context);
        mask |= this.getChangeMask((Vector)asn.lstExpathHop, z_qasnExpathMasks, "lstExpathHop");
    }

    public Class<QAsnExpath> getAsnClass() {
        return QAsnExpath.class;
    }

    public Class<ExplicitPath> getMoClass() {
        return ExplicitPath.class;
    }

    private void decodeLstExpathHop(QAsnExpath asn, ExplicitPath mo, IAsnTranslationContext context) throws VMFException {
        if (null == asn.lstExpathHop) {
            return;
        }
        mo.addExplicitPathHops(this.qasnExpathHopTranslator.decode((Collection)asn.lstExpathHop, context));
        this.setChanged((VmfMO)mo, "explicitPathHops", mo.getExplicitPathHops(), context);
    }

    private void decodeOExpathKey(QAsnExpath asn, ExplicitPath mo, IAsnTranslationContext context) throws VMFException {
        if (null == asn.oExpathKey) {
            return;
        }
        this.qasnExpathKeyTranslator.decode((FStruct)asn.oExpathKey, (Object)mo, context);
    }

    private void encodeLstExpathHop(ExplicitPath mo, QAsnExpath asn, IAsnTranslationContext context) throws VMFException {
        if (null == mo.getExplicitPathHops()) {
            return;
        }
        if (null == asn.lstExpathHop) {
            asn.lstExpathHop = new QAsnExpathHopList();
        }
        asn.lstExpathHop.addAll(this.qasnExpathHopTranslator.encode(mo.getExplicitPathHops(), context));
    }

    private void encodeOExpathKey(ExplicitPath mo, QAsnExpath asn, IAsnTranslationContext context) throws VMFException {
        if (null == asn.oExpathKey) {
            asn.oExpathKey = new QAsnExpathKey();
            AsnUtil.setDefaultAsnValue((FStruct)asn.oExpathKey);
        }
        this.qasnExpathKeyTranslator.encode((Object)mo, (FStruct)asn.oExpathKey, context);
    }
}

