/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.vmf.adapter.mpls.translation.asn;

import com.huawei.network.qasn.m_q_ip_tunnel_model.QAsnExpathHop;
import com.huawei.vmf.adapter.common.exception.VMFException;
import com.huawei.vmf.adapter.framework.translation.asn.AbstractAsnTranslator;
import com.huawei.vmf.adapter.framework.translation.asn.IAsnTranslationContext;
import com.huawei.vmf.adapter.fservice.model.EOperationType;
import com.huawei.vmf.adapter.fservice.model.VmfMO;
import com.huawei.vmf.adapter.fservice.mpls.model.ExplicitPath;
import com.huawei.vmf.adapter.fservice.mpls.model.ExplicitPathHop;
import com.huawei.vmf.adapter.mpls.translation.asn.spec.QAsnExpathHopSpecTranslator;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import org.springframework.util.CollectionUtils;

public class QAsnExpathHopTranslator
extends AbstractAsnTranslator<QAsnExpathHop, ExplicitPathHop> {
    public static final int EXPATHHOP_ADD = 1;
    public static final int EXPATHHOP_DEL = 2;
    public static final int RI_EXPATH_STRNEXTHOP_CHG = 4;
    public static final int RI_IROUTINGSTYLE_CHG = 8;
    public static final Object[][] z_explicitPathHopMasks = new Object[][]{{"mplsTunnelHopIpAddr", 4}, {"mplsTunnelHopType", 8}};
    public static final Object[][] z_qasnExpathHopMasks = new Object[][]{{"add", 1}, {"delete", 2}, {"strNextHop", 4}, {"iRoutingStyle", 8}};
    private QAsnExpathHopSpecTranslator qasnExpathHopSpecTranslator = new QAsnExpathHopSpecTranslator();

    public void decode(QAsnExpathHop asn, ExplicitPathHop mo, IAsnTranslationContext context) throws VMFException {
        if (asn == null || mo == null) {
            return;
        }
        this.decodeExplicitPathHop(asn, mo, context);
        if (this.isDelete(2, asn.poOperMask, context)) {
            return;
        }
        this.qasnExpathHopSpecTranslator.decodePoExpathType(asn, mo, context);
        this.qasnExpathHopSpecTranslator.decodePoExpathName(asn, mo, context);
    }

    public void decodeExplicitPathHop(QAsnExpathHop asn, ExplicitPathHop mo, IAsnTranslationContext context) throws VMFException {
        ExplicitPath explicitPath = (ExplicitPath)context.getProperty(ExplicitPath.class.getName());
        mo.setDevID(explicitPath.getDevID());
        mo.setVrID(explicitPath.getVrID());
        mo.setExplicitPathName(explicitPath.getExplicitPathName());
        mo.setMplsTunnelHopIndex(Long.valueOf(this.longValue(asn.iHopNo)));
        context.addProperty(ExplicitPathHop.class.getName(), (Object)mo);
        int operMask = null == asn.poOperMask || -1 == asn.poOperMask ? 0 : asn.poOperMask;
        EOperationType operType = this.setAddOrDeleted((VmfMO)mo, 1, 2, operMask, context);
        if (operType.equals((Object)EOperationType.DELETE)) {
            return;
        }
        mo.setMplsTunnelHopIpAddr(this.strValue(asn.strNextHop, "mplsTunnelHopIpAddr", z_explicitPathHopMasks, (VmfMO)mo, context));
        mo.setMplsTunnelHopType(this.integerValue(asn.iRoutingStyle, "mplsTunnelHopType", z_explicitPathHopMasks, (VmfMO)mo, context));
        this.setChanged((VmfMO)mo, z_explicitPathHopMasks, asn.poOperMask, context);
    }

    public Collection<QAsnExpathHop> encode(Collection<ExplicitPathHop> mos, IAsnTranslationContext context) throws VMFException {
        Collection expathHops = super.encode(mos, context);
        ArrayList<QAsnExpathHop> expathHopList = new ArrayList<QAsnExpathHop>(expathHops);
        if (!CollectionUtils.isEmpty((Collection)expathHops)) {
            Collections.sort(expathHopList, new Comparator<QAsnExpathHop>(){

                @Override
                public int compare(QAsnExpathHop hop1, QAsnExpathHop hop2) {
                    return hop1.iHopNo - hop2.iHopNo;
                }
            });
        }
        return expathHopList;
    }

    public void encode(ExplicitPathHop mo, QAsnExpathHop asn, IAsnTranslationContext context) throws VMFException {
        if (asn == null || mo == null) {
            return;
        }
        this.encodeExplicitPathHop(mo, asn, context);
        this.qasnExpathHopSpecTranslator.encodePoExpathType(mo, asn, context);
        this.qasnExpathHopSpecTranslator.encodePoExpathName(mo, asn, context);
    }

    public void encodeExplicitPathHop(ExplicitPathHop mo, QAsnExpathHop asn, IAsnTranslationContext context) throws VMFException {
        int mask = 0;
        asn.iHopNo = this.intValue(mo.getMplsTunnelHopIndex());
        asn.strNextHop = this.getBytes(mo.getMplsTunnelHopIpAddr());
        asn.iRoutingStyle = this.intValue(mo.getMplsTunnelHopType());
        asn.poOperMask = this.getOperMask(asn.poOperMask, mask |= this.setChangeMask((VmfMO)mo, context, z_explicitPathHopMasks));
    }

    public Class<QAsnExpathHop> getAsnClass() {
        return QAsnExpathHop.class;
    }

    public Class<ExplicitPathHop> getMoClass() {
        return ExplicitPathHop.class;
    }
}

