/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.vmf.adapter.mpls.translation.asn;

import com.huawei.network.qasn.m_q_ip_tunnel_model.QAsnCreateAttr;
import com.huawei.vmf.adapter.common.exception.VMFException;
import com.huawei.vmf.adapter.framework.translation.asn.AbstractAsnTranslator;
import com.huawei.vmf.adapter.framework.translation.asn.IAsnTranslationContext;
import com.huawei.vmf.adapter.fservice.model.EOperationType;
import com.huawei.vmf.adapter.fservice.model.VmfMO;
import com.huawei.vmf.adapter.fservice.mpls.model.RsvpTeTunnel;
import com.huawei.vmf.adapter.fservice.mpls.model.RsvpTeTunnelAdv;
import com.huawei.vmf.adapter.mpls.translation.asn.spec.QAsnCreateAttrSpecTranslator;

public class QAsnCreateAttrTranslator
extends AbstractAsnTranslator<QAsnCreateAttr, RsvpTeTunnelAdv> {
    public static final int RI_IHOLDPRIORITY_CHG = 8;
    public static final int RI_ILOOPDETECTIONENABLE_CHG = 2;
    public static final int RI_IRECORDROUTELABEL_CHG = 1;
    public static final int RI_IRESVSTYLE_CHG = 128;
    public static final int RI_IRETRYINTERVAL_CHG = 32;
    public static final int RI_IRETRYNUMBER_CHG = 64;
    public static final int RI_IRRENABLE_CHG = 16;
    public static final int RI_ISETUPPRIORITY_CHG = 4;
    public static final Object[][] z_qasnCreateAttrMasks = new Object[][]{{"iRecordRouteLabel", 1}, {"iLoopDetectionEnable", 2}, {"iSetupPriority", 4}, {"iHoldPriority", 8}, {"iRrEnable", 16}, {"iRetryInterval", 32}, {"iRetryNumber", 64}, {"iResvStyle", 128}};
    public static final Object[][] z_rsvpTeTunnelAdvMasks = new Object[][]{{"mplsTunnelRecordRoute", 1}, {"mplsTeTunnelSetupPriority", 4}, {"holdPriority", 8}, {"resvStyle", 128}};
    private QAsnCreateAttrSpecTranslator qasnCreateAttrSpecTranslator = new QAsnCreateAttrSpecTranslator();

    public void decode(QAsnCreateAttr asn, RsvpTeTunnelAdv mo, IAsnTranslationContext context) throws VMFException {
        if (asn == null || mo == null) {
            return;
        }
        this.decodeRsvpTeTunnelAdv(asn, mo, context);
        if (this.isDelete(0, asn.poOperMask, context)) {
            return;
        }
        this.qasnCreateAttrSpecTranslator.decodeILoopDetectionEnable(asn, mo, context);
        this.qasnCreateAttrSpecTranslator.decodeIRetryInterval(asn, mo, context);
        this.qasnCreateAttrSpecTranslator.decodeIRetryNumber(asn, mo, context);
    }

    public void decodeRsvpTeTunnelAdv(QAsnCreateAttr asn, RsvpTeTunnelAdv mo, IAsnTranslationContext context) throws VMFException {
        RsvpTeTunnel rsvpTeTunnel = (RsvpTeTunnel)context.getProperty(RsvpTeTunnel.class.getName());
        mo.setDevID(rsvpTeTunnel.getDevID());
        mo.setVrID(rsvpTeTunnel.getVrID());
        mo.setTunnelName(rsvpTeTunnel.getTunnelName());
        context.addProperty(RsvpTeTunnelAdv.class.getName(), (Object)mo);
        EOperationType operType = this.setAddOrDeleted((VmfMO)mo, 0, 0, asn.poOperMask, context);
        if (operType.equals((Object)EOperationType.DELETE)) {
            return;
        }
        mo.setMplsTunnelRecordRoute(this.integerValue(asn.iRecordRouteLabel, "mplsTunnelRecordRoute", z_rsvpTeTunnelAdvMasks, (VmfMO)mo, context));
        mo.setMplsTeTunnelSetupPriority(this.integerValue(asn.iSetupPriority, "mplsTeTunnelSetupPriority", z_rsvpTeTunnelAdvMasks, (VmfMO)mo, context));
        mo.setHoldPriority(this.integerValue(asn.iHoldPriority, "holdPriority", z_rsvpTeTunnelAdvMasks, (VmfMO)mo, context));
        mo.setResvStyle(this.integerValue(asn.iResvStyle, "resvStyle", z_rsvpTeTunnelAdvMasks, (VmfMO)mo, context));
        this.setChanged((VmfMO)mo, z_rsvpTeTunnelAdvMasks, asn.poOperMask, context);
    }

    public void encode(RsvpTeTunnelAdv mo, QAsnCreateAttr asn, IAsnTranslationContext context) throws VMFException {
        if (asn == null || mo == null) {
            return;
        }
        this.encodeRsvpTeTunnelAdv(mo, asn, context);
        this.qasnCreateAttrSpecTranslator.encodeILoopDetectionEnable(mo, asn, context);
        this.qasnCreateAttrSpecTranslator.encodeIRetryInterval(mo, asn, context);
        this.qasnCreateAttrSpecTranslator.encodeIRetryNumber(mo, asn, context);
    }

    public void encodeRsvpTeTunnelAdv(RsvpTeTunnelAdv mo, QAsnCreateAttr asn, IAsnTranslationContext context) throws VMFException {
        int mask = 0;
        asn.iRecordRouteLabel = this.intValue(mo.getMplsTunnelRecordRoute());
        asn.iSetupPriority = this.intValue(mo.getMplsTeTunnelSetupPriority());
        asn.iHoldPriority = this.intValue(mo.getHoldPriority());
        asn.iResvStyle = this.intValue(mo.getResvStyle());
        asn.poOperMask = this.getOperMask(asn.poOperMask, mask |= this.setChangeMask((VmfMO)mo, context, z_rsvpTeTunnelAdvMasks));
    }

    public Class<QAsnCreateAttr> getAsnClass() {
        return QAsnCreateAttr.class;
    }

    public Class<RsvpTeTunnelAdv> getMoClass() {
        return RsvpTeTunnelAdv.class;
    }
}

