/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.vmf.adapter.mpls.translation.asn;

import com.huawei.network.qasn.m_q_ip_tunnel_model.QAsnBackupAttr;
import com.huawei.vmf.adapter.common.utilty.AsnUtil;
import com.huawei.vmf.adapter.framework.capability.CapabilityInfo;
import com.huawei.vmf.adapter.framework.translation.asn.AbstractAsnTranslator;
import com.huawei.vmf.adapter.framework.translation.asn.IAsnTranslationContext;
import com.huawei.vmf.adapter.fservice.model.EOperationType;
import com.huawei.vmf.adapter.fservice.model.VmfMO;
import com.huawei.vmf.adapter.fservice.mpls.model.RsvpTeTunnel;
import com.huawei.vmf.adapter.fservice.mpls.model.RsvpTeTunnelAdv;
import com.huawei.vmf.adapter.mpls.common.MplsUtil;
import com.huawei.vmf.adapter.mpls.translation.asn.spec.QAsnBackupAttrSpecTranslator;
import com.huawei.vmf.common.exception.VMFException;
import org.apache.commons.lang.ObjectUtils;

public class QAsnBackupAttrTranslator
extends AbstractAsnTranslator<QAsnBackupAttr, RsvpTeTunnelAdv> {
    public static final int RI_IBACKUPTYPE_CHG = 1;
    public static final int RI_IENABLEBESTEFF_CHG = 4;
    public static final int RI_IWTRINTERVAL_CHG = 2;
    public static final int RI_POREVERTIVEMODE_CHG = 8;
    public static final Object[][] z_qasnBackupAttrMasks = new Object[][]{{"iBackupType", 1}, {"iWtrInterval", 2}, {"iEnableBesteff", 4}, {"poRevertiveMode", 8}};
    public static final Object[][] z_rsvpTeTunnelAdvMasks = new Object[][]{{"hotStandbyWtr", 2}, {"bestEffortEnable", 4}, {"hsbRevertiveMode", 8}, {"hotStandbyEnable", 1}};
    private QAsnBackupAttrSpecTranslator qasnBackupAttrSpecTranslator = new QAsnBackupAttrSpecTranslator();

    public void decode(QAsnBackupAttr asn, RsvpTeTunnelAdv mo, IAsnTranslationContext context) throws com.huawei.vmf.adapter.common.exception.VMFException {
        if (asn == null || mo == null) {
            return;
        }
        this.decodeRsvpTeTunnelAdv(asn, mo, context);
        if (this.isDelete(0, asn.poOperMask, context)) {
            return;
        }
        this.qasnBackupAttrSpecTranslator.decodeIBackupType(asn, mo, context);
    }

    public void decodeRsvpTeTunnelAdv(QAsnBackupAttr asn, RsvpTeTunnelAdv mo, IAsnTranslationContext context) throws com.huawei.vmf.adapter.common.exception.VMFException {
        RsvpTeTunnel rsvpTeTunnel = (RsvpTeTunnel)context.getProperty(RsvpTeTunnel.class.getName());
        mo.setDevID(rsvpTeTunnel.getDevID());
        mo.setVrID(rsvpTeTunnel.getVrID());
        mo.setTunnelName(rsvpTeTunnel.getTunnelName());
        context.addProperty(RsvpTeTunnelAdv.class.getName(), (Object)mo);
        EOperationType operType = this.setAddOrDeleted((VmfMO)mo, 0, 0, asn.poOperMask, context);
        if (operType.equals((Object)EOperationType.DELETE)) {
            return;
        }
        mo.setHotStandbyWtr(this.integerValue(asn.iWtrInterval, "hotStandbyWtr", z_rsvpTeTunnelAdvMasks, (VmfMO)mo, context));
        if (mo.getHotStandbyWtr() == null) {
            mo.setHotStandbyWtr(this.getHotStandbyWtrDefaultValue(mo));
        }
        mo.setBestEffortEnable(this.parseBoolean(asn.iEnableBesteff, "bestEffortEnable", z_rsvpTeTunnelAdvMasks, (VmfMO)mo, context));
        mo.setHsbRevertiveMode(this.integerValue(asn.poRevertiveMode, "hsbRevertiveMode", z_rsvpTeTunnelAdvMasks, (VmfMO)mo, context));
        if (QAsnBackupAttrSpecTranslator.ASN_BACKUPTYPE.HOTSTANDBY != asn.iBackupType) {
            mo.setHsbRevertiveMode(RsvpTeTunnelAdv.HSB_REVERTIVE_MODE_ENUM.REVERTIVE);
        }
        mo.setHsbPathOverlap(this.parseBoolean(asn.poEnableOverlapPath, "hsbPathOverlap", z_rsvpTeTunnelAdvMasks, (VmfMO)mo, context));
        this.setChanged((VmfMO)mo, z_rsvpTeTunnelAdvMasks, asn.poOperMask, context);
    }

    public void encode(RsvpTeTunnelAdv mo, QAsnBackupAttr asn, IAsnTranslationContext context) throws com.huawei.vmf.adapter.common.exception.VMFException {
        if (asn == null || mo == null) {
            return;
        }
        this.encodeRsvpTeTunnelAdv(mo, asn, context);
        this.qasnBackupAttrSpecTranslator.encodeIBackupType(mo, asn, context);
    }

    public void encodeRsvpTeTunnelAdv(RsvpTeTunnelAdv mo, QAsnBackupAttr asn, IAsnTranslationContext context) throws com.huawei.vmf.adapter.common.exception.VMFException {
        int mask = 0;
        asn.iWtrInterval = ObjectUtils.equals((Object)mo.getHotStandbyEnable(), (Object)Boolean.TRUE) ? this.intValue(mo.getHotStandbyWtr()) : -1;
        asn.iEnableBesteff = this.intValue(mo.getBestEffortEnable());
        asn.poRevertiveMode = Boolean.TRUE.equals(mo.getHotStandbyEnable()) ? Integer.valueOf(AsnUtil.intValue((Integer)mo.getHsbRevertiveMode())) : Integer.valueOf(-1);
        asn.poEnableOverlapPath = this.intValue(mo.getHsbPathOverlap());
        asn.poOperMask = this.getOperMask(asn.poOperMask, mask |= this.setChangeMask((VmfMO)mo, context, z_rsvpTeTunnelAdvMasks));
    }

    public Class<QAsnBackupAttr> getAsnClass() {
        return QAsnBackupAttr.class;
    }

    public Class<RsvpTeTunnelAdv> getMoClass() {
        return RsvpTeTunnelAdv.class;
    }

    private Integer getHotStandbyWtrDefaultValue(RsvpTeTunnelAdv mo) {
        try {
            CapabilityInfo cap = MplsUtil.getMoCapInfo((VmfMO)mo);
            return MplsUtil.getMoDefaultValue(cap, RsvpTeTunnelAdv.class, "hotStandbyWtr", Integer.class);
        }
        catch (VMFException e) {
            QAsnBackupAttrTranslator.getLogger().error("MplsUtil.getMoCapInfo exception", (Throwable)e);
            return null;
        }
    }
}

