/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.vmf.adapter.mpls.translation.asn;

import com.huawei.network.qasn.m_q_ip_tunnel_model.QAsnBWReoptimizationAttr;
import com.huawei.vmf.adapter.common.exception.VMFException;
import com.huawei.vmf.adapter.common.utilty.AsnUtil;
import com.huawei.vmf.adapter.framework.translation.asn.AbstractAsnTranslator;
import com.huawei.vmf.adapter.framework.translation.asn.AsnTranslatorUtil;
import com.huawei.vmf.adapter.framework.translation.asn.IAsnTranslationContext;
import com.huawei.vmf.adapter.fservice.model.EOperationType;
import com.huawei.vmf.adapter.fservice.model.VmfMO;
import com.huawei.vmf.adapter.fservice.mpls.model.RsvpTeTunnel;
import com.huawei.vmf.adapter.fservice.mpls.model.RsvpTeTunnelAdv;
import java.math.BigInteger;

public class QAsnBWReoptimizationAttrTranslator
extends AbstractAsnTranslator<QAsnBWReoptimizationAttr, RsvpTeTunnelAdv> {
    public static final int RI_IFREQUENCY_CHG = 2;
    public static final int RI_IMAXBANDWIDTH_CHG = 4;
    public static final int RI_IMINBANDWIDTH_CHG = 8;
    public static final int RI_IREOPTIMIZATIONTYPE_CHG = 1;
    public static final Object[][] z_qasnBWReoptimizationAttrMasks = new Object[][]{{"iReoptimizationType", 1}, {"iFrequency", 2}, {"iMaxBandwidth", 4}, {"iMinBandwidth", 8}};
    public static final Object[][] z_rsvpTeTunnelAdvMasks = new Object[][]{{"autoBwMode", 1}, {"autoBwFreq", 2}, {"autoBwMax", 4}, {"autoBwMin", 8}};

    public void decode(QAsnBWReoptimizationAttr asn, RsvpTeTunnelAdv mo, IAsnTranslationContext context) throws VMFException {
        if (asn == null || mo == null) {
            return;
        }
        this.decodeRsvpTeTunnelAdv(asn, mo, context);
        if (this.isDelete(0, asn.poOperMask, context)) {
            return;
        }
    }

    public void decodeRsvpTeTunnelAdv(QAsnBWReoptimizationAttr asn, RsvpTeTunnelAdv mo, IAsnTranslationContext context) throws VMFException {
        RsvpTeTunnel rsvpTeTunnel = (RsvpTeTunnel)context.getProperty(RsvpTeTunnel.class.getName());
        mo.setDevID(rsvpTeTunnel.getDevID());
        mo.setVrID(rsvpTeTunnel.getVrID());
        mo.setTunnelName(rsvpTeTunnel.getTunnelName());
        context.addProperty(RsvpTeTunnelAdv.class.getName(), (Object)mo);
        EOperationType operType = this.setAddOrDeleted((VmfMO)mo, 0, 0, asn.poOperMask, context);
        if (operType.equals((Object)EOperationType.DELETE)) {
            return;
        }
        mo.setAutoBwMode(this.integerValue(asn.iReoptimizationType, "autoBwMode", z_rsvpTeTunnelAdvMasks, (VmfMO)mo, context));
        if (RsvpTeTunnelAdv.AUTO_BW_MODE_ENUM.DISABLE.equals(mo.getAutoBwMode())) {
            if (AsnTranslatorUtil.isMaskChanged((Integer)asn.poOperMask, (int)1)) {
                AsnTranslatorUtil.addModifyChangeRecord((String)"autoBwMode", (Object)mo, (IAsnTranslationContext)context);
            }
        } else {
            mo.setAutoBwFreq(this.integerValue(asn.iFrequency, "autoBwFreq", z_rsvpTeTunnelAdvMasks, (VmfMO)mo, context));
            BigInteger maxBandwidth = AsnUtil.chooseBigIntegerValue((byte[])asn.poiMaxBandwidth, (int)asn.iMaxBandwidth);
            mo.setAutoBwMax(this.bigIntegerValue(maxBandwidth, "autoBwMax", z_rsvpTeTunnelAdvMasks, (VmfMO)mo, context));
            BigInteger minBandwidth = AsnUtil.chooseBigIntegerValue((byte[])asn.poiMinBandwidth, (int)asn.iMinBandwidth);
            mo.setAutoBwMin(this.bigIntegerValue(minBandwidth, "autoBwMin", z_rsvpTeTunnelAdvMasks, (VmfMO)mo, context));
            this.setChanged((VmfMO)mo, z_rsvpTeTunnelAdvMasks, asn.poOperMask, context);
        }
    }

    public void encode(RsvpTeTunnelAdv mo, QAsnBWReoptimizationAttr asn, IAsnTranslationContext context) throws VMFException {
        if (asn == null || mo == null) {
            return;
        }
        this.encodeRsvpTeTunnelAdv(mo, asn, context);
    }

    public void encodeRsvpTeTunnelAdv(RsvpTeTunnelAdv mo, QAsnBWReoptimizationAttr asn, IAsnTranslationContext context) throws VMFException {
        int mask = 0;
        asn.iReoptimizationType = this.intValue(mo.getAutoBwMode());
        asn.iFrequency = this.intValue(mo.getAutoBwFreq());
        asn.iMaxBandwidth = QAsnBWReoptimizationAttrTranslator.intValue((BigInteger)mo.getAutoBwMax());
        asn.iMinBandwidth = QAsnBWReoptimizationAttrTranslator.intValue((BigInteger)mo.getAutoBwMax());
        asn.poiMaxBandwidth = AsnUtil.getBytes((String)(mo.getAutoBwMax() == null ? "-1" : this.strValue(mo.getAutoBwMax())));
        asn.poiMinBandwidth = AsnUtil.getBytes((String)(mo.getAutoBwMax() == null ? "-1" : this.strValue(mo.getAutoBwMin())));
        asn.poOperMask = this.getOperMask(asn.poOperMask, mask |= this.setChangeMask((VmfMO)mo, context, z_rsvpTeTunnelAdvMasks));
    }

    public Class<QAsnBWReoptimizationAttr> getAsnClass() {
        return QAsnBWReoptimizationAttr.class;
    }

    public Class<RsvpTeTunnelAdv> getMoClass() {
        return RsvpTeTunnelAdv.class;
    }
}

