/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.vmf.adapter.mpls.translation.asn;

import com.huawei.network.qasn.m_q_common.QAsnErrInfo;
import com.huawei.network.qasn.m_q_ip_tunnel_model.QAsnInterfaceMplsInfo;
import com.huawei.network.qasn.m_q_ip_tunnel_model.QAsnPortBandWidthBCInfo;
import com.huawei.network.qasn.m_q_ip_tunnel_model.QAsnPortBandWidthInfo;
import com.huawei.vmf.adapter.common.exception.VMFException;
import com.huawei.vmf.adapter.common.fdn.FDNUtil;
import com.huawei.vmf.adapter.common.utilty.StringUtil;
import com.huawei.vmf.adapter.framework.translation.asn.IAsnTranslationContext;
import com.huawei.vmf.adapter.framework.translation.asn.OnlyEncodeAsnTranslator;
import com.huawei.vmf.adapter.fservice.mpls.view.InterfaceMplsInfo;

public class InterfaceMplsInfo2InterfaceMplsInfoTranslator
extends OnlyEncodeAsnTranslator<QAsnInterfaceMplsInfo, InterfaceMplsInfo> {
    public static final int NEMPLS_CAPABILITY_NOSUPPORT = -1;
    public static final int NEMPLS_CAPABILITY_UNENABLE = 0;

    public void encode(InterfaceMplsInfo mo, QAsnInterfaceMplsInfo asn, IAsnTranslationContext context) throws VMFException {
        asn.iInterfaceKey.neID = mo.getDevID();
        asn.iInterfaceKey.strFDN = StringUtil.globalByte((String)mo.getFdn());
        asn.iInterfaceKey.strMOC = StringUtil.globalByte((String)FDNUtil.getFdnType((String)mo.getFdn()));
        asn.iInterfaceMpls = mo.getMplsCapability();
        asn.iTunnelStatus = -1;
        if (null == asn.poOperResult) {
            asn.poOperResult = new QAsnErrInfo();
            asn.poOperResult.errCode = 0;
        }
        if (-1 == mo.getMplsCapability()) {
            asn.iInterfaceMplsTe = -1;
        } else if (0 == mo.getMplsCapability()) {
            asn.iInterfaceMplsTe = 0;
            asn.iTunnelStatus = -1;
            asn.poiInterfaceLDP = 0;
            asn.poiLabelAdvertiseMode = -1;
            asn.poRSVPTEAuthMode = 0;
            asn.poRSVPTEAuthPassword = StringUtil.globalByte((String)"");
            asn.poRSVPTEHello = 0;
            asn.poRSVPTE = 0;
        } else {
            asn.iInterfaceMplsTe = this.intValue(mo.getMplsTEEnable());
            asn.iTunnelStatus = -1;
            asn.poiInterfaceLDP = this.intValue(null == mo.getLdpEnable() ? false : mo.getLdpEnable());
            asn.poiLabelAdvertiseMode = 2;
            asn.poRSVPTEAuthMode = 2;
            if (null != mo.getAuthMD5Key()) {
                asn.poRSVPTEAuthPassword = StringUtil.globalByte((String)mo.getAuthMD5Key());
            }
            asn.poRSVPTEHello = this.intValue(null == mo.getHelloEnable() ? false : mo.getHelloEnable());
            asn.poRSVPTE = this.intValue(null == mo.getRsvpTEEnable() ? false : mo.getRsvpTEEnable());
            if (null == asn.poPortBandWidthInfo) {
                asn.poPortBandWidthInfo = new QAsnPortBandWidthInfo();
            }
            if (null != mo.getTeIfMaxreservablebandwidth()) {
                asn.poPortBandWidthInfo.maxReservableVale = mo.getTeIfMaxreservablebandwidth().intValue();
            }
            QAsnPortBandWidthBCInfo bw0 = new QAsnPortBandWidthBCInfo();
            bw0.iType = 0;
            bw0.iValue = -1;
            QAsnPortBandWidthBCInfo bw1 = new QAsnPortBandWidthBCInfo();
            bw0.iType = 1;
            bw0.iValue = -1;
            asn.poPortBandWidthInfo.bclist.add((Object)bw0);
            asn.poPortBandWidthInfo.bclist.add((Object)bw1);
        }
    }

    public Class<QAsnInterfaceMplsInfo> getAsnClass() {
        return QAsnInterfaceMplsInfo.class;
    }

    public Class<InterfaceMplsInfo> getMoClass() {
        return InterfaceMplsInfo.class;
    }
}

