/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.vmf.adapter.mpls.task;

import com.huawei.commextend.taskmgr.Task;
import com.huawei.network.qasn.m_q_ip_tunnel_model.QAsnVerifyStrResource;
import com.huawei.network.qasn.m_q_ip_tunnel_model.QAsnVerifyTunnelIdResource;
import com.huawei.network.qasn.m_q_ip_tunnel_model.QAsnVerifyTunnelResource;
import com.huawei.network.qasn.m_q_ip_tunnel_op.QAsnVerifyTunnelRecourseRsp;
import com.huawei.network.qasn.m_q_ip_tunnel_op.QAsnVerifyTunnelResourceReq;
import com.huawei.vmf.adapter.common.exception.VMFException;
import com.huawei.vmf.adapter.common.utilty.StringUtil;
import com.huawei.vmf.adapter.framework.task.AbstractQTask;
import com.huawei.vmf.adapter.fservice.mpls.model.RsvpTeTunnel;
import com.huawei.vmf.adapter.mpls.dao.MplsDao;
import java.util.Arrays;
import java.util.Collection;
import org.apache.commons.collections.CollectionUtils;

public class VerifyTunnelResourceTask
extends AbstractQTask<QAsnVerifyTunnelResourceReq, QAsnVerifyTunnelRecourseRsp> {
    public static final int RESOURCE_CONFLICT = 1;
    public static final int RESOURCE_NOT_CONFLICT = 0;
    MplsDao dao = MplsDao.newInstance();

    protected void executeTask(QAsnVerifyTunnelResourceReq req, QAsnVerifyTunnelRecourseRsp rsp, Task task) {
        rsp.lstVerifyLspHop = req.lstVerifyTnlResource;
        try {
            for (Object obj : rsp.lstVerifyLspHop) {
                Collection tunnels;
                RsvpTeTunnel tmpTunnel;
                QAsnVerifyTunnelResource verifyTnlResource = (QAsnVerifyTunnelResource)obj;
                int devID = verifyTnlResource.neID;
                for (Object objRes : verifyTnlResource.lstTunnelID) {
                    QAsnVerifyTunnelIdResource tunnelIdRes = (QAsnVerifyTunnelIdResource)objRes;
                    int tunnelID = tunnelIdRes.iTunnelID;
                    tmpTunnel = new RsvpTeTunnel();
                    tmpTunnel.setDevID(Integer.valueOf(devID));
                    tmpTunnel.setMplsTunnelIndex(Integer.valueOf(tunnelID));
                    tunnels = this.dao.queryByFields(RsvpTeTunnel.class, new String[]{"devID", "mplsTunnelIndex"}, Arrays.asList(tmpTunnel), false);
                    if (CollectionUtils.isEmpty((Collection)tunnels)) {
                        tunnelIdRes.iVerifyResult = 0;
                        continue;
                    }
                    tunnelIdRes.iVerifyResult = 1;
                }
                for (Object objRes : verifyTnlResource.lstIfName) {
                    QAsnVerifyStrResource tunnelIfRes = (QAsnVerifyStrResource)objRes;
                    String tunnelName = StringUtil.globalString((byte[])tunnelIfRes.strResource);
                    tmpTunnel = new RsvpTeTunnel();
                    tmpTunnel.setDevID(Integer.valueOf(devID));
                    tmpTunnel.setTunnelName(tunnelName);
                    tunnels = this.dao.queryByFields(RsvpTeTunnel.class, new String[]{"devID", "tunnelName"}, Arrays.asList(tmpTunnel), false);
                    if (CollectionUtils.isEmpty((Collection)tunnels)) {
                        tunnelIfRes.iVerifyResult = 0;
                        continue;
                    }
                    tunnelIfRes.iVerifyResult = 1;
                }
            }
            rsp.oResult.result = 0;
        }
        catch (VMFException e) {
            this.getLogger().error("VerifyTunnelResourceTask query database error.", (Throwable)e);
            rsp.oResult.result = e.getErrorCode();
        }
    }
}

