/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.vmf.adapter.mpls.task;

import com.huawei.commextend.taskmgr.Task;
import com.huawei.network.qasn.m_q_common.QAsnUniResID;
import com.huawei.network.qasn.m_q_ip_tunnel_op.QAsnUndoTunnelReverseLspReq;
import com.huawei.network.qasn.m_q_ip_tunnel_op.QAsnUndoTunnelReverseLspRsp;
import com.huawei.vmf.adapter.framework.notify.IMOChangeRecord;
import com.huawei.vmf.adapter.framework.notify.PropertyChangeItem;
import com.huawei.vmf.adapter.framework.service.DefaultCompositeService;
import com.huawei.vmf.adapter.framework.service.ICompositeService;
import com.huawei.vmf.adapter.framework.service.OperResult;
import com.huawei.vmf.adapter.framework.task.AbstractConfigQTask;
import com.huawei.vmf.adapter.framework.transaction.Context;
import com.huawei.vmf.adapter.framework.translation.asn.AsnTranslatorUtil;
import com.huawei.vmf.adapter.framework.translation.asn.IAsnTranslationContext;
import com.huawei.vmf.adapter.fservice.model.EOperationType;
import com.huawei.vmf.adapter.fservice.model.VmfMO;
import com.huawei.vmf.adapter.fservice.mpls.fdn.RsvpTeTunnelFdnParser;
import com.huawei.vmf.adapter.fservice.mpls.model.ReverseRsvpTeLsp;
import com.huawei.vmf.adapter.fservice.mpls.model.RsvpTeTunnel;
import com.huawei.vmf.adapter.fservice.service.IFdnParser;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Set;

public class UndoTunnelReverseLspTask
extends AbstractConfigQTask<QAsnUndoTunnelReverseLspReq, QAsnUndoTunnelReverseLspRsp> {
    private IFdnParser<RsvpTeTunnel> fdnParser = new RsvpTeTunnelFdnParser();

    public UndoTunnelReverseLspTask() {
        super(EOperationType.UNDEPLOY);
        this.addMoCompositeService(ReverseRsvpTeLsp.class, (ICompositeService)new DefaultCompositeService(ReverseRsvpTeLsp.class));
    }

    protected void decode(QAsnUndoTunnelReverseLspReq req, Task task, IAsnTranslationContext context) {
        ArrayList<ReverseRsvpTeLsp> mos = new ArrayList<ReverseRsvpTeLsp>();
        for (Object tunnelKey : req.lstTnlRevLsp) {
            ReverseRsvpTeLsp mo = new ReverseRsvpTeLsp();
            RsvpTeTunnel tunnel = (RsvpTeTunnel)this.fdnParser.getIndexMo((QAsnUniResID)tunnelKey);
            mo.setDevID(tunnel.getDevID());
            mo.setVrID(tunnel.getVrID());
            mo.setTunnelName(tunnel.getTunnelName());
            mos.add(mo);
        }
        Context ctx = context.getTransactionContext();
        IMOChangeRecord devMoChangeRecord = ctx.addChangeRecord(ReverseRsvpTeLsp.class);
        IMOChangeRecord dbMoChangeRecord = ctx.addDBChangeRecord(ReverseRsvpTeLsp.class);
        for (ReverseRsvpTeLsp mo : mos) {
            devMoChangeRecord.addDelete((Object)mo);
            mo.setDeployStatus(Integer.valueOf(0));
            dbMoChangeRecord.addModify((Object)mo, new PropertyChangeItem("deployStatus"));
        }
    }

    protected void encode(QAsnUndoTunnelReverseLspRsp rsp, IAsnTranslationContext asnTranslatorContext) {
        Context context = asnTranslatorContext.getTransactionContext();
        OperResult operResult = context.getOperResult();
        IMOChangeRecord rsvpTeLspChangeRecord = context.getChangeRecord(ReverseRsvpTeLsp.class);
        Set rsvpTeLsp = rsvpTeLspChangeRecord.getAllChanges();
        rsp.oResult = AsnTranslatorUtil.getMosQAsnErrInfoReturn((Collection)rsvpTeLsp, (OperResult)operResult);
        for (ReverseRsvpTeLsp singleRsvpLsp : rsvpTeLsp) {
            RsvpTeTunnel moTunnel = new RsvpTeTunnel();
            moTunnel.setDevID(singleRsvpLsp.getDevID());
            moTunnel.setVrID(singleRsvpLsp.getVrID());
            moTunnel.setTunnelName(singleRsvpLsp.getTunnelName());
            rsp.lstTunnelKeyRet.add((Object)this.fdnParser.getFdn((VmfMO)moTunnel));
        }
    }

    protected Integer getAsnBestEffort(QAsnUndoTunnelReverseLspReq req) {
        return req.bestEffort;
    }

    protected byte[] getAsnTaskFlag(QAsnUndoTunnelReverseLspReq req) {
        return req.strTaskFlag;
    }
}

