/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.vmf.adapter.mpls.task;

import com.huawei.commextend.taskmgr.Task;
import com.huawei.network.qasn.m_q_common.QAsnUniResID;
import com.huawei.network.qasn.m_q_ip_tunnel_model.QAsnTunnelKeyResult;
import com.huawei.network.qasn.m_q_ip_tunnel_op.QAsnUnDeployTunnelReq;
import com.huawei.network.qasn.m_q_ip_tunnel_op.QAsnUnDeployTunnelRsp;
import com.huawei.vmf.adapter.common.exception.VMFException;
import com.huawei.vmf.adapter.framework.dao.DaoFactory;
import com.huawei.vmf.adapter.framework.notify.IMOChangeRecord;
import com.huawei.vmf.adapter.framework.notify.PropertyChangeItem;
import com.huawei.vmf.adapter.framework.service.ICompositeService;
import com.huawei.vmf.adapter.framework.service.OperResult;
import com.huawei.vmf.adapter.framework.task.AbstractConfigQTask;
import com.huawei.vmf.adapter.framework.transaction.Context;
import com.huawei.vmf.adapter.framework.translation.asn.AsnTranslatorUtil;
import com.huawei.vmf.adapter.framework.translation.asn.IAsnTranslationContext;
import com.huawei.vmf.adapter.fservice.ifm.model.Interface;
import com.huawei.vmf.adapter.fservice.model.EOperationType;
import com.huawei.vmf.adapter.fservice.model.VmfMO;
import com.huawei.vmf.adapter.fservice.mpls.fdn.RsvpTeTunnelFdnParser;
import com.huawei.vmf.adapter.fservice.mpls.model.MplsOamTunnel;
import com.huawei.vmf.adapter.fservice.mpls.model.RsvpTeTunnel;
import com.huawei.vmf.adapter.fservice.mpls.model.StaticTunnel;
import com.huawei.vmf.adapter.fservice.service.IFdnParser;
import com.huawei.vmf.adapter.fservice.tpoam.service.ITpoamService;
import com.huawei.vmf.adapter.mpls.Activator;
import com.huawei.vmf.adapter.mpls.common.MplsAsnUtil;
import com.huawei.vmf.adapter.mpls.common.MplsUtil;
import com.huawei.vmf.adapter.mpls.dao.MplsDao;
import com.huawei.vmf.adapter.mpls.service.RsvpTETunnelService;
import com.huawei.vmf.adapter.mpls.service.StaticTunnelService;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import net.commustru.fstru.FStruct;
import org.springframework.util.CollectionUtils;

public class UnDeployTunnelTask
extends AbstractConfigQTask<QAsnUnDeployTunnelReq, QAsnUnDeployTunnelRsp> {
    public UnDeployTunnelTask() {
        super(EOperationType.UNDEPLOY);
        this.addMoCompositeService(RsvpTeTunnel.class, (ICompositeService)new RsvpTETunnelService());
        this.addMoCompositeService(StaticTunnel.class, (ICompositeService)new StaticTunnelService());
    }

    protected void decode(QAsnUnDeployTunnelReq req, Task task, IAsnTranslationContext context) {
        if (CollectionUtils.isEmpty((Collection)req.lstTunnelKey)) {
            return;
        }
        ArrayList<RsvpTeTunnel> rsvpTeFdnTunnels = new ArrayList<RsvpTeTunnel>();
        ArrayList<StaticTunnel> staticFdnTunnels = new ArrayList<StaticTunnel>();
        MplsAsnUtil.parseTunnelKeys(req.lstTunnelKey, rsvpTeFdnTunnels, staticFdnTunnels);
        Context ctx = context.getTransactionContext();
        if (!CollectionUtils.isEmpty(rsvpTeFdnTunnels)) {
            this.setUnDeployRsvpTeTunnelChanges(rsvpTeFdnTunnels, context);
        }
        if (!CollectionUtils.isEmpty(staticFdnTunnels)) {
            this.setUnDeployStaticTunnelChanges(staticFdnTunnels, ctx);
        }
    }

    private void setOamTunnelChanges(StaticTunnel staticTunnel, Context ctx) {
        ArrayList<MplsOamTunnel> tunnelOamList = new ArrayList<MplsOamTunnel>();
        MplsOamTunnel tunnelOam = new MplsOamTunnel();
        tunnelOam.setDevID(staticTunnel.getDevID());
        tunnelOam.setVrID(staticTunnel.getVrID());
        tunnelOam.setTunnelName(staticTunnel.getTunnelName());
        tunnelOamList.add(tunnelOam);
        try {
            Collection oamTunnelFromDB = DaoFactory.getInstance().getDefaultDao(DaoFactory.VMF_DB, null).queryByKey(MplsOamTunnel.class, tunnelOamList, true);
            if (!CollectionUtils.isEmpty((Collection)oamTunnelFromDB)) {
                staticTunnel.addKeyRefMos(oamTunnelFromDB);
                this.addTunnelOamDeployRecord(ctx, staticTunnel.getKeyRefMos(MplsOamTunnel.class));
            }
        }
        catch (VMFException e) {
            this.getLogger().error("UnDeployTunnelTask setOamTunnelChanges operation error.");
        }
    }

    protected void addTunnelOamDeployRecord(Context context, List<MplsOamTunnel> tpKeyRefMos) throws VMFException {
        if (CollectionUtils.isEmpty(tpKeyRefMos)) {
            return;
        }
        IMOChangeRecord tpMoChangeRecord = context.addDBChangeRecord(MplsOamTunnel.class);
        for (MplsOamTunnel oamTunnel : tpKeyRefMos) {
            oamTunnel.setDeployStatus(Integer.valueOf(0));
            tpMoChangeRecord.addModify((Object)oamTunnel, new PropertyChangeItem("deployStatus", (Object)0, (Object)1));
        }
    }

    private void setUnDeployStaticTunnelChanges(List<StaticTunnel> staticFdnTunnels, Context ctx) {
        Collection<StaticTunnel> dbStaticTunnels = null;
        try {
            MplsDao dao = MplsDao.newInstance();
            dbStaticTunnels = dao.queryStaticTunnelByFdnKeys(staticFdnTunnels, false);
            dao.loadStaticTunnelInterfaceByName(dbStaticTunnels, true);
        }
        catch (VMFException e) {
            this.getLogger().error("UnDeployTunnelTask query from db failed!", (Throwable)e);
            return;
        }
        IMOChangeRecord devRecord = ctx.addChangeRecord(StaticTunnel.class);
        IMOChangeRecord dbRecord = ctx.addDBChangeRecord(StaticTunnel.class);
        PropertyChangeItem deployStatusItem = new PropertyChangeItem("deployStatus");
        IFdnParser<StaticTunnel> staticTunnelFdnParser = MplsUtil.getStaticTunnelFdnParser();
        for (StaticTunnel fdnTunnel : staticFdnTunnels) {
            if (MplsUtil.containsMo(dbStaticTunnels, fdnTunnel, staticTunnelFdnParser)) continue;
            AsnTranslatorUtil.addMoOperResult((VmfMO)fdnTunnel, (Context)ctx, (int)1107501604);
            devRecord.addDelete((Object)fdnTunnel);
        }
        IMOChangeRecord ifmDbMoChangeRecord = ctx.addDBChangeRecord(Interface.class);
        for (StaticTunnel dbStaticTunnel : dbStaticTunnels) {
            dbStaticTunnel.setDeployStatus(Integer.valueOf(0));
            devRecord.addDelete((Object)dbStaticTunnel);
            dbRecord.addModify((Object)dbStaticTunnel, deployStatusItem);
            List ifms = dbStaticTunnel.getKeyRefMos(Interface.class);
            if (!CollectionUtils.isEmpty((Collection)ifms)) {
                Interface ifm = (Interface)ifms.iterator().next();
                ifm.setDeployStatus(Integer.valueOf(0));
                ifmDbMoChangeRecord.addModify((Object)ifm, deployStatusItem);
            }
            this.setOamTunnelChanges(dbStaticTunnel, ctx);
        }
    }

    private void setUnDeployRsvpTeTunnelChanges(List<RsvpTeTunnel> rsvpTeFdnTunnels, IAsnTranslationContext context) {
        try {
            MplsDao.newInstance().loadRsvpTeTunnelInterface(rsvpTeFdnTunnels, false);
        }
        catch (VMFException e) {
            this.getLogger().error("UnDeployTunnelTask RsvpTeTunnel load Interface failed!", (Throwable)e);
        }
        Context ctx = context.getTransactionContext();
        IMOChangeRecord devMoChangeRecord = ctx.addChangeRecord(RsvpTeTunnel.class);
        IMOChangeRecord dbMoChangeRecord = ctx.addDBChangeRecord(RsvpTeTunnel.class);
        IMOChangeRecord ifmDbMoChangeRecord = ctx.addDBChangeRecord(Interface.class);
        PropertyChangeItem deployStatusItem = new PropertyChangeItem("deployStatus");
        for (RsvpTeTunnel mo : rsvpTeFdnTunnels) {
            List ifms = mo.getKeyRefMos(Interface.class);
            if (!CollectionUtils.isEmpty((Collection)ifms)) {
                Interface ifm = (Interface)ifms.iterator().next();
                ifm.setDeployStatus(Integer.valueOf(0));
                ifmDbMoChangeRecord.addModify((Object)ifm, deployStatusItem);
            }
            devMoChangeRecord.addDelete((Object)mo);
            mo.setDeployStatus(Integer.valueOf(0));
            dbMoChangeRecord.addModify((Object)mo, deployStatusItem);
        }
    }

    protected void encode(QAsnUnDeployTunnelRsp rsp, IAsnTranslationContext context) {
        RsvpTeTunnelFdnParser rsvpTeTunnelFdnParser = new RsvpTeTunnelFdnParser();
        IFdnParser<StaticTunnel> staticTunnelFdnParser = MplsUtil.getStaticTunnelFdnParser();
        Context ctx = context.getTransactionContext();
        OperResult operResult = ctx.getOperResult();
        ArrayList mos = new ArrayList();
        IMOChangeRecord rsvpTeRecord = ctx.addChangeRecord(RsvpTeTunnel.class);
        mos.addAll(rsvpTeRecord.getAllChanges());
        IMOChangeRecord staticCRRecord = ctx.addChangeRecord(StaticTunnel.class);
        mos.addAll(staticCRRecord.getAllChanges());
        rsp.oResult = AsnTranslatorUtil.getMosQAsnErrInfoReturn(mos, (OperResult)operResult);
        for (VmfMO mo : mos) {
            QAsnTunnelKeyResult asn = new QAsnTunnelKeyResult();
            if (mo instanceof RsvpTeTunnel) {
                asn.oTunnelKey = rsvpTeTunnelFdnParser.getUniResID((VmfMO)((RsvpTeTunnel)mo));
                asn.result = AsnTranslatorUtil.getMoQAsnErrInfo((VmfMO)mo, (OperResult)operResult);
            } else if (mo instanceof StaticTunnel) {
                asn.oTunnelKey = staticTunnelFdnParser.getUniResID((VmfMO)((StaticTunnel)mo));
                asn.result = AsnTranslatorUtil.getMoQAsnErrInfo((VmfMO)mo, (OperResult)operResult);
            } else {
                this.getLogger().info("no control");
            }
            rsp.lstTunnelFail.add((Object)asn);
        }
    }

    protected Integer getAsnBestEffort(QAsnUnDeployTunnelReq req) {
        return req.bestEffort;
    }

    protected byte[] getAsnTaskFlag(QAsnUnDeployTunnelReq req) {
        return req.strTaskFlag;
    }

    protected void executeTask(QAsnUnDeployTunnelReq req, QAsnUnDeployTunnelRsp rsp, Task task) {
        super.executeTask((FStruct)req, (FStruct)rsp, task);
        if (MplsUtil.isPtn()) {
            ITpoamService tpOamService = Activator.getService(ITpoamService.class);
            int len = req.lstTunnelKey.size();
            for (int i = 0; i < len; ++i) {
                QAsnUniResID resID = (QAsnUniResID)req.lstTunnelKey.get(i);
                if (!MplsUtil.isConfigTpOam(resID)) continue;
                try {
                    tpOamService.undeployTPOAM(2, resID);
                    continue;
                }
                catch (VMFException e) {
                    this.getLogger().error("UnDeployTunnelTask tpOamService.undeployTPOAM failed!");
                }
            }
        }
    }
}

