/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.vmf.adapter.mpls.task;

import com.huawei.commextend.taskmgr.Task;
import com.huawei.network.qasn.m_q_common.QAsnErrInfo;
import com.huawei.network.qasn.m_q_common.QAsnErrInfoReturn;
import com.huawei.network.qasn.m_q_ip_spring_model.QAsnSPRingSwitch;
import com.huawei.network.qasn.m_q_ip_spring_op.QAsnSwitchStatusReq;
import com.huawei.network.qasn.m_q_ip_spring_op.QAsnSwitchStatusRsp;
import com.huawei.vmf.adapter.common.exception.ErrorInfo;
import com.huawei.vmf.adapter.common.exception.VMFException;
import com.huawei.vmf.adapter.framework.notify.MOChangePublisher;
import com.huawei.vmf.adapter.framework.task.AbstractQTask;
import com.huawei.vmf.adapter.framework.transaction.Context;
import com.huawei.vmf.adapter.framework.translation.asn.AsnTranslationContext;
import com.huawei.vmf.adapter.framework.translation.asn.AsnTranslatorUtil;
import com.huawei.vmf.adapter.framework.translation.asn.IAsnTranslationContext;
import com.huawei.vmf.adapter.fservice.model.VmfMO;
import com.huawei.vmf.adapter.fservice.mpls.model.MplsRing;
import com.huawei.vmf.adapter.fservice.mpls.model.act.RingProtectSwitch;
import com.huawei.vmf.adapter.mpls.dao.MplsDao;
import com.huawei.vmf.adapter.mpls.dao.MplsDevDao;
import com.huawei.vmf.adapter.mpls.translation.asn.spec.QAsnSPRingSwitchTranslator;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Map;

public class SwitchStatusTask
extends AbstractQTask<QAsnSwitchStatusReq, QAsnSwitchStatusRsp> {
    protected void executeTask(QAsnSwitchStatusReq req, QAsnSwitchStatusRsp rsp, Task task) {
        QAsnSPRingSwitchTranslator translator = new QAsnSPRingSwitchTranslator();
        AsnTranslationContext context = new AsnTranslationContext();
        context.setTransactionContext(new Context());
        Collection mos = null;
        try {
            mos = translator.decode((Collection)req.ringSwitchList, (IAsnTranslationContext)context);
        }
        catch (VMFException e) {
            this.getLogger().error("SwitchStatusTask decode failed!", (Throwable)e);
            AsnTranslatorUtil.addRspResultError((QAsnErrInfoReturn)rsp.oResult, (VMFException)e);
            return;
        }
        rsp.oResult.result = 0;
        Map<VmfMO, ErrorInfo> errorInfo = null;
        try {
            errorInfo = MplsDevDao.newInstance().executeSwitchStatusAction(mos);
        }
        catch (VMFException e) {
            this.getLogger().error("SwitchStatusTask executeSwitchStatusAction failed!", (Throwable)e);
            AsnTranslatorUtil.addRspResultError((QAsnErrInfoReturn)rsp.oResult, (VMFException)e);
            return;
        }
        try {
            for (RingProtectSwitch mo : mos) {
                QAsnSPRingSwitch asn = (QAsnSPRingSwitch)translator.encode(mo, (IAsnTranslationContext)context);
                asn.poResult = new QAsnErrInfo();
                if (errorInfo != null && !errorInfo.isEmpty()) {
                    ErrorInfo error = errorInfo.get(mo);
                    asn.poResult.errCode = error.getErrorCode();
                    asn.poResult.strOperDesc = error.getErrorMessage().getBytes();
                    rsp.oResult.result = error.getErrorCode();
                    rsp.switchResultList.add((Object)asn);
                    continue;
                }
                asn.poResult = new QAsnErrInfo();
                asn.poResult.errCode = 0;
                rsp.switchResultList.add((Object)asn);
            }
        }
        catch (VMFException e) {
            this.getLogger().error("SwitchStatusTask encode failed!", (Throwable)e);
            AsnTranslatorUtil.addRspResultError((QAsnErrInfoReturn)rsp.oResult, (VMFException)e);
        }
        try {
            this.syncStatusAndRpt(mos);
        }
        catch (VMFException e) {
            this.getLogger().error("SwitchStatusTask syncStatusAndRpt failed!", (Throwable)e);
        }
    }

    private void syncStatusAndRpt(Collection<RingProtectSwitch> mos) throws VMFException {
        ArrayList<MplsRing> conditions = new ArrayList<MplsRing>();
        for (RingProtectSwitch mo : mos) {
            MplsRing ring = new MplsRing();
            AsnTranslatorUtil.copyDevAndVrId((VmfMO)mo, (VmfMO)ring);
            ring.setRingId(Integer.valueOf(mo.getRingId()));
            conditions.add(ring);
        }
        Collection dbRings = MplsDao.newInstance().queryByKey(MplsRing.class, conditions, false);
        Context ctx = new Context();
        MplsDevDao.newInstance().syncMplsRingSwitchStatus(dbRings, ctx);
        MOChangePublisher.getInstance().notifyChanges(ctx);
    }
}

