/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.vmf.adapter.mpls.task;

import com.huawei.commextend.taskmgr.Task;
import com.huawei.network.qasn.m_q_common.QAsnErrInfoReturn;
import com.huawei.network.qasn.m_q_common.QAsnUniResIDList;
import com.huawei.network.qasn.m_q_ip_tpoam_model.QAsnTPOamResKey;
import com.huawei.network.qasn.m_q_ip_tpoam_model.QAsnTPOamResKeyResult;
import com.huawei.network.qasn.m_q_ip_tpoam_model.QAsnTPOamResKeyResultList;
import com.huawei.network.qasn.m_q_ip_tpoam_op.QAsnSwitchServiceOAMStandardReq;
import com.huawei.network.qasn.m_q_ip_tpoam_op.QAsnSwitchServiceOAMStandardRsp;
import com.huawei.vmf.adapter.common.exception.ErrorInfo;
import com.huawei.vmf.adapter.common.exception.VMFException;
import com.huawei.vmf.adapter.framework.dao.DaoFactory;
import com.huawei.vmf.adapter.framework.notify.IMOChangeRecord;
import com.huawei.vmf.adapter.framework.task.AbstractQTask;
import com.huawei.vmf.adapter.framework.transaction.Context;
import com.huawei.vmf.adapter.fservice.mpls.fdn.StaticTunnelFdnParser;
import com.huawei.vmf.adapter.fservice.mpls.model.MplsOamPw;
import com.huawei.vmf.adapter.fservice.mpls.model.MplsOamTunnel;
import com.huawei.vmf.adapter.fservice.mpls.model.StaticTunnel;
import com.huawei.vmf.adapter.fservice.pwe3.fdn.VpwsPwFdnParser;
import com.huawei.vmf.adapter.fservice.pwe3.model.VpwsInstance;
import com.huawei.vmf.adapter.fservice.pwe3.model.VpwsPw;
import com.huawei.vmf.adapter.fservice.pwe3.service.IPwe3Service;
import com.huawei.vmf.adapter.fservice.tpoam.service.ITpoamService;
import com.huawei.vmf.adapter.mpls.Activator;
import com.huawei.vmf.adapter.mpls.common.MplsUtil;
import com.huawei.vmf.adapter.mpls.dao.MplsDao;
import java.util.ArrayList;
import java.util.Collection;
import org.springframework.util.CollectionUtils;

public class SwitchServiceOAMStandardTask
extends AbstractQTask<QAsnSwitchServiceOAMStandardReq, QAsnSwitchServiceOAMStandardRsp> {
    private int OAM_STANDARD_1731 = 2;
    private int SERVICE_TYPE_PW = 1;
    private int SERVICE_TYPE_LSP = 2;

    protected void executeTask(QAsnSwitchServiceOAMStandardReq req, QAsnSwitchServiceOAMStandardRsp rsp, Task task) {
        rsp.result = new QAsnErrInfoReturn();
        rsp.result.result = 0;
        rsp.svcResKeyList = new QAsnTPOamResKeyResultList();
        QAsnUniResIDList tpoamResList = new QAsnUniResIDList();
        if (req.oamStandard == this.OAM_STANDARD_1731) {
            ITpoamService tpOamService = Activator.getService(ITpoamService.class);
            int size = req.svcResKeyList.size();
            for (int i = 0; i < size; ++i) {
                QAsnTPOamResKey resKey = (QAsnTPOamResKey)req.svcResKeyList.get(i);
                ErrorInfo errorInfo = null;
                try {
                    boolean isConfigTpoam = false;
                    if (null != tpOamService) {
                        boolean bl = isConfigTpoam = tpOamService.queryPOAM(resKey.oResKey) != null;
                    }
                    if (this.SERVICE_TYPE_PW == resKey.iSeviceType && !isConfigTpoam) {
                        errorInfo = MplsUtil.switchPW(resKey);
                        tpoamResList.add((Object)resKey.oResKey);
                    }
                    if (this.SERVICE_TYPE_LSP == resKey.iSeviceType && !isConfigTpoam) {
                        errorInfo = MplsUtil.switchLSP(resKey);
                        tpoamResList.add((Object)resKey.oResKey);
                    }
                    QAsnTPOamResKeyResult result = new QAsnTPOamResKeyResult();
                    result.oamResKey = resKey;
                    if (!this.isSuccess(errorInfo)) {
                        result.result.isSuccess = false;
                        result.result.retCode = errorInfo.getErrorCode();
                    } else {
                        result.result.isSuccess = true;
                        result.result.retCode = 0;
                        this.deleteOam(resKey);
                    }
                    rsp.svcResKeyList.add((Object)result);
                    continue;
                }
                catch (VMFException e) {
                    this.getLogger().error("query TP OAM failed, the res == " + new String(resKey.oResKey.strFDN));
                }
            }
            if (!CollectionUtils.isEmpty((Collection)tpoamResList)) {
                ITpoamService tpService = Activator.getService(ITpoamService.class);
                if (null == tpService) {
                    this.getLogger().error("the class of SwitchServiceOAMStandardTask get TpOam Serice is null!");
                }
                try {
                    tpService.initSwtichTPOamInfo(tpoamResList);
                }
                catch (VMFException e) {
                    this.getLogger().error("the class of SwitchServiceOAMStandardTask initSwtichTPOamInfo failed!");
                }
            }
        } else {
            int size = req.svcResKeyList.size();
            for (int i = 0; i < size; ++i) {
                QAsnTPOamResKey resKey = (QAsnTPOamResKey)req.svcResKeyList.get(i);
                QAsnTPOamResKeyResult result = new QAsnTPOamResKeyResult();
                result.oamResKey = resKey;
                result.result.isSuccess = true;
                result.result.retCode = 0;
                rsp.svcResKeyList.add((Object)result);
            }
        }
        rsp.result.result = 0;
    }

    private void deleteOam(QAsnTPOamResKey resKey) {
        if (this.SERVICE_TYPE_PW == resKey.iSeviceType) {
            VpwsPwFdnParser pwfdnParser = new VpwsPwFdnParser();
            VpwsPw pw = (VpwsPw)pwfdnParser.getIndexMo(resKey.oResKey);
            VpwsPw vpwspw = new VpwsPw();
            IPwe3Service pwe3Service = Activator.getService(IPwe3Service.class);
            try {
                Collection vpwsInst = pwe3Service.getVpwsInstances(pw.getFdn());
                if (CollectionUtils.isEmpty((Collection)vpwsInst)) {
                    this.getLogger().error("pwe3Service.getVpwsInstances in SwitchServiceOAMStandardTask: no pwe3 instance record!");
                    return;
                }
                Collection pwLst = ((VpwsInstance)vpwsInst.iterator().next()).getVpwsPws();
                if (CollectionUtils.isEmpty((Collection)pwLst)) {
                    this.getLogger().error("pwe3Service.getVpwsInstances in SwitchServiceOAMStandardTask: no vpwspw record!");
                    return;
                }
                for (VpwsPw pwIndex : pwLst) {
                    if (!pwIndex.getDevID().equals(pw.getDevID()) || !pwIndex.getPwId().equals(pw.getPwId()) || !pwIndex.getPwType().equals(pw.getPwType())) continue;
                    vpwspw = pwIndex;
                    break;
                }
            }
            catch (VMFException e) {
                this.getLogger().error("Activator.getService failed!", (Throwable)e);
            }
            MplsOamPw pwMo = new MplsOamPw();
            pwMo.setDevID(pw.getDevID());
            pwMo.setFdn(pw.getFdn());
            pwMo.setPeerIp(vpwspw.getPeerIp());
            pwMo.setVcId(Long.valueOf(Long.parseLong(String.valueOf(vpwspw.getPwId()))));
            pwMo.setVrID(vpwspw.getVrID());
            pwMo.setVcType(vpwspw.getPwType());
            ArrayList<MplsOamPw> pwMos = new ArrayList<MplsOamPw>();
            pwMos.add(pwMo);
            try {
                Collection dbPwMos = DaoFactory.getInstance().getDefaultDao(DaoFactory.VMF_DB, null).queryByKey(MplsOamPw.class, pwMos, false);
                if (!CollectionUtils.isEmpty((Collection)dbPwMos)) {
                    Context ctx = new Context();
                    IMOChangeRecord record = ctx.addChangeRecord(MplsOamPw.class);
                    record.addDelete(dbPwMos);
                    MplsDao.newInstance(ctx).merge(MplsOamPw.class, false);
                }
            }
            catch (VMFException e) {
                this.getLogger().error("after switch to 1731 then delete pwOam failed!", (Throwable)e);
            }
        }
        if (this.SERVICE_TYPE_LSP == resKey.iSeviceType) {
            StaticTunnelFdnParser lspfdnParser = new StaticTunnelFdnParser();
            StaticTunnel staticTunnel = (StaticTunnel)lspfdnParser.getIndexMo(resKey.oResKey);
            MplsOamTunnel tunnelMo = new MplsOamTunnel();
            tunnelMo.setDevID(staticTunnel.getDevID());
            tunnelMo.setFdn(staticTunnel.getFdn());
            tunnelMo.setTunnelName(staticTunnel.getTunnelName());
            ArrayList<MplsOamTunnel> tunnelMos = new ArrayList<MplsOamTunnel>();
            tunnelMos.add(tunnelMo);
            try {
                Collection dbTunnelMos = DaoFactory.getInstance().getDefaultDao(DaoFactory.VMF_DB, null).queryByKey(MplsOamTunnel.class, tunnelMos, false);
                if (!CollectionUtils.isEmpty((Collection)dbTunnelMos)) {
                    Context ctx = new Context();
                    IMOChangeRecord record = ctx.addChangeRecord(MplsOamTunnel.class);
                    record.addDelete(dbTunnelMos);
                    MplsDao.newInstance(ctx).merge(MplsOamTunnel.class, false);
                }
            }
            catch (VMFException e) {
                this.getLogger().error("after switch to 1731 then delete tunnel Oam failed!", (Throwable)e);
            }
        }
    }
}

