/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.vmf.adapter.mpls.task;

import com.huawei.commextend.taskmgr.Task;
import com.huawei.network.qasn.m_q_common.QAsnUniResID;
import com.huawei.network.qasn.m_q_common.QAsnUniResIDList;
import com.huawei.network.qasn.m_q_ip_tunnel_op.QAsnSwitchProtectionGroupReq;
import com.huawei.network.qasn.m_q_ip_tunnel_op.QAsnSwitchProtectionGroupRsp;
import com.huawei.vmf.adapter.common.exception.VMFException;
import com.huawei.vmf.adapter.common.utilty.RunLogger;
import com.huawei.vmf.adapter.framework.service.DefaultMOService;
import com.huawei.vmf.adapter.framework.task.AbstractQTask;
import com.huawei.vmf.adapter.framework.translation.schema.ActionSchemaTranslatorContext;
import com.huawei.vmf.adapter.fservice.model.VmfMO;
import com.huawei.vmf.adapter.fservice.mpls.fdn.TunnelGroupFdnParser;
import com.huawei.vmf.adapter.fservice.mpls.model.TunnelGroup;
import com.huawei.vmf.adapter.fservice.mpls.model.act.TunnelGroupPS;
import com.huawei.vmf.adapter.fservice.service.FeatureName;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;

public class SwitchProtectionGroupTask
extends AbstractQTask<QAsnSwitchProtectionGroupReq, QAsnSwitchProtectionGroupRsp> {
    private Logger logger = RunLogger.getLogger(SwitchProtectionGroupTask.class);

    protected void executeTask(QAsnSwitchProtectionGroupReq req, QAsnSwitchProtectionGroupRsp rsp, Task task) {
        LinkedList<TunnelGroupPS> tunnelGroupPSs = new LinkedList<TunnelGroupPS>();
        TunnelGroupFdnParser fdnParser = new TunnelGroupFdnParser();
        QAsnUniResIDList tunnelGroupKeyList = req.lstProtectionGroupKey;
        for (QAsnUniResID fdnAsn : tunnelGroupKeyList) {
            TunnelGroup tunnelGroup = (TunnelGroup)fdnParser.getIndexMo(fdnAsn);
            TunnelGroupPS tunnelGroupPS = new TunnelGroupPS();
            tunnelGroupPS.setDevID(tunnelGroup.getDevID());
            tunnelGroupPS.setVrID(tunnelGroup.getVrID());
            tunnelGroupPS.setTunnelName(tunnelGroup.getWorkingTunnel());
            tunnelGroupPS.setPsOperation(Integer.valueOf(req.iSwitchCmd));
            tunnelGroupPSs.add(tunnelGroupPS);
        }
        HashMap<Integer, ArrayList<TunnelGroupPS>> devIDAndTunnelGroupPSsMap = new HashMap<Integer, ArrayList<TunnelGroupPS>>();
        for (TunnelGroupPS tmpTunnelGroupPS : tunnelGroupPSs) {
            ArrayList<TunnelGroupPS> viConditions = (ArrayList<TunnelGroupPS>)devIDAndTunnelGroupPSsMap.get(tmpTunnelGroupPS.getDevID());
            if (null == viConditions) {
                viConditions = new ArrayList<TunnelGroupPS>();
                devIDAndTunnelGroupPSsMap.put(tmpTunnelGroupPS.getDevID(), viConditions);
            }
            viConditions.add(tmpTunnelGroupPS);
        }
        DefaultMOService moService = new DefaultMOService();
        for (Map.Entry entry : devIDAndTunnelGroupPSsMap.entrySet()) {
            ActionSchemaTranslatorContext actionContext = new ActionSchemaTranslatorContext(((Integer)entry.getKey()).intValue());
            for (TunnelGroupPS viCondition : (List)entry.getValue()) {
                actionContext.addAction(FeatureName.MPLS, (VmfMO)viCondition);
            }
            moService.addActionJob(actionContext);
        }
        try {
            moService.execute();
        }
        catch (VMFException e) {
            this.logger.error("SwitchProtectionGroupTask moService.execute failed.", (Throwable)e);
            rsp.oResult.result = e.getErrorCode();
        }
    }
}

