/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.vmf.adapter.mpls.task;

import com.huawei.commextend.taskmgr.Task;
import com.huawei.network.qasn.m_q_ip_tunnel_model.QAsnTunnelKeyResult;
import com.huawei.network.qasn.m_q_ip_tunnel_op.QAsnSetTunnelReverseLspReq;
import com.huawei.network.qasn.m_q_ip_tunnel_op.QAsnSetTunnelReverseLspRsp;
import com.huawei.vmf.adapter.common.exception.VMFException;
import com.huawei.vmf.adapter.framework.notify.IMOChangeRecord;
import com.huawei.vmf.adapter.framework.service.DefaultCompositeService;
import com.huawei.vmf.adapter.framework.service.ICompositeService;
import com.huawei.vmf.adapter.framework.service.OperResult;
import com.huawei.vmf.adapter.framework.task.AbstractConfigQTask;
import com.huawei.vmf.adapter.framework.transaction.Context;
import com.huawei.vmf.adapter.framework.translation.asn.AsnTranslatorUtil;
import com.huawei.vmf.adapter.framework.translation.asn.IAsnTranslationContext;
import com.huawei.vmf.adapter.fservice.model.EOperationType;
import com.huawei.vmf.adapter.fservice.model.VmfMO;
import com.huawei.vmf.adapter.fservice.mpls.fdn.RsvpTeTunnelFdnParser;
import com.huawei.vmf.adapter.fservice.mpls.model.ReverseRsvpTeLsp;
import com.huawei.vmf.adapter.mpls.common.MplsUtil;
import com.huawei.vmf.adapter.mpls.translation.asn.QAsnTunnelReverseLspInfoTranslator;
import java.util.Collection;
import java.util.Set;

public class SetTunnelReverseLspTask
extends AbstractConfigQTask<QAsnSetTunnelReverseLspReq, QAsnSetTunnelReverseLspRsp> {
    public SetTunnelReverseLspTask() {
        super(EOperationType.MODIFY);
        this.addMoCompositeService(ReverseRsvpTeLsp.class, (ICompositeService)new DefaultCompositeService(ReverseRsvpTeLsp.class));
    }

    protected void decode(QAsnSetTunnelReverseLspReq req, Task task, IAsnTranslationContext asnTranslatorContext) {
        try {
            QAsnTunnelReverseLspInfoTranslator translator = new QAsnTunnelReverseLspInfoTranslator();
            translator.decode((Collection)req.lstTnlRevLsp, asnTranslatorContext);
        }
        catch (VMFException e) {
            this.getLogger().error("decode req error. req = QAsnSetTunnelReverseLspReq", (Throwable)e);
        }
    }

    protected void encode(QAsnSetTunnelReverseLspRsp rsp, IAsnTranslationContext context) {
        Context ctx = context.getTransactionContext();
        IMOChangeRecord record = ctx.getChangeRecord(ReverseRsvpTeLsp.class);
        OperResult operResult = ctx.getOperResult();
        Set reverseRsvpTeLsps = record.getAllChanges();
        rsp.oResult = AsnTranslatorUtil.getMosQAsnErrInfoReturn((Collection)reverseRsvpTeLsps, (OperResult)operResult);
        RsvpTeTunnelFdnParser fdnParser = new RsvpTeTunnelFdnParser();
        for (ReverseRsvpTeLsp reverseRsvpTeLsp : reverseRsvpTeLsps) {
            QAsnTunnelKeyResult asn = new QAsnTunnelKeyResult();
            asn.oTunnelKey = fdnParser.getUniResID((VmfMO)MplsUtil.translate2RsvpTeTunnel(reverseRsvpTeLsp));
            asn.result = AsnTranslatorUtil.getMoQAsnErrInfo((VmfMO)reverseRsvpTeLsp, (OperResult)operResult);
            rsp.lstTunnelKeyRet.add((Object)asn);
        }
    }

    protected Integer getAsnBestEffort(QAsnSetTunnelReverseLspReq req) {
        return req.bestEffort;
    }

    protected byte[] getAsnTaskFlag(QAsnSetTunnelReverseLspReq req) {
        return req.strTaskFlag;
    }
}

