/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.vmf.adapter.mpls.task;

import com.huawei.network.qasn.m_q_common.QAsnSingleReturn;
import com.huawei.network.qasn.m_q_ip_common_model.QAsnLDPPeerInfo;
import com.huawei.network.qasn.m_q_ip_common_model.QAsnLDPPeerInfoList;
import com.huawei.network.qasn.m_q_ip_common_model.QAsnMplsInfo;
import com.huawei.network.qasn.m_q_ip_common_model.QAsnSetMplsInfo;
import com.huawei.network.qasn.m_q_ip_common_op.QAsnSetMplsReq;
import com.huawei.network.qasn.m_q_ip_common_op.QAsnSetMplsRsp;
import com.huawei.vmf.adapter.common.exception.VMFException;
import com.huawei.vmf.adapter.common.utilty.StringUtil;
import com.huawei.vmf.adapter.framework.service.ICompositeService;
import com.huawei.vmf.adapter.framework.service.OperResult;
import com.huawei.vmf.adapter.framework.task.AbstractSingleMoConfigQTask;
import com.huawei.vmf.adapter.framework.translation.asn.AsnTranslatorUtil;
import com.huawei.vmf.adapter.framework.translation.asn.IAsnTranslationContext;
import com.huawei.vmf.adapter.framework.translation.asn.IAsnTranslator;
import com.huawei.vmf.adapter.fservice.model.EOperationType;
import com.huawei.vmf.adapter.fservice.model.VmfMO;
import com.huawei.vmf.adapter.fservice.mpls.model.LdpInstance;
import com.huawei.vmf.adapter.fservice.mpls.model.LdpRemotePeer;
import com.huawei.vmf.adapter.fservice.mpls.model.MplsCommonCfg;
import com.huawei.vmf.adapter.mpls.service.MplsCommonCfgService;
import com.huawei.vmf.adapter.mpls.translation.asn.QAsnLDPPeerInfoTranslator;
import com.huawei.vmf.adapter.mpls.translation.asn.QAsnMplsInfoTranslator;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import org.springframework.util.CollectionUtils;

public class SetMplsTask
extends AbstractSingleMoConfigQTask<QAsnSetMplsReq, QAsnSetMplsRsp, QAsnMplsInfo, QAsnSetMplsInfo, MplsCommonCfg> {
    public SetMplsTask() {
        super(MplsCommonCfg.class, EOperationType.MODIFY, (IAsnTranslator)new QAsnMplsInfoTranslator(), null);
        this.addMoCompositeService(MplsCommonCfg.class, (ICompositeService)new MplsCommonCfgService());
    }

    protected void encode(QAsnSetMplsRsp rsp, IAsnTranslationContext context) {
        Set mos = context.getTransactionContext().getChangeRecord(this.getMoClazz()).getAllChanges();
        OperResult operResult = context.getTransactionContext().getOperResult();
        rsp.result = AsnTranslatorUtil.getMosQAsnErrInfoReturn((Collection)mos, (OperResult)operResult);
        for (MplsCommonCfg mo : mos) {
            LdpInstance ldpInstance;
            QAsnSetMplsInfo asn = new QAsnSetMplsInfo();
            rsp.lstSetMplsInfo.add((Object)asn);
            asn.neID = mo.getDevID();
            asn.oResult = AsnTranslatorUtil.getMosQAsnErrInfoReturn(Arrays.asList(mo), (OperResult)operResult);
            List ldpInstances = mo.getKeyRefMos(LdpInstance.class);
            if (CollectionUtils.isEmpty((Collection)ldpInstances) || CollectionUtils.isEmpty((Collection)(ldpInstance = (LdpInstance)ldpInstances.iterator().next()).getLdpRemotePeers())) continue;
            asn.lstLdpPeerResult = new QAsnLDPPeerInfoList();
            QAsnSingleReturn ldpResult = AsnTranslatorUtil.getMoQAsnSingleReturn((VmfMO)ldpInstance, (OperResult)operResult);
            QAsnLDPPeerInfoTranslator translator = new QAsnLDPPeerInfoTranslator();
            for (LdpRemotePeer remoteLdpPeer : ldpInstance.getLdpRemotePeers()) {
                QAsnLDPPeerInfo peerInfo = new QAsnLDPPeerInfo();
                try {
                    translator.encode(remoteLdpPeer, peerInfo, context);
                    peerInfo.poOperResult = asn.oResult.result != 0 ? AsnTranslatorUtil.getMoQAsnSingleReturn((VmfMO)mo, (OperResult)operResult) : (ldpResult.isSuccess ? AsnTranslatorUtil.getMoQAsnSingleReturn((VmfMO)remoteLdpPeer, (OperResult)operResult) : ldpResult);
                }
                catch (VMFException e) {
                    peerInfo.poOperResult.retCode = e.getErrorCode();
                    peerInfo.poOperResult.isSuccess = false;
                    peerInfo.poOperResult.reason = StringUtil.globalByte((String)e.getErrorMessage());
                    this.getLogger().error("SetMplsTask QAsnLDPPeerInfoTranslator encode failed!", (Throwable)e);
                }
                asn.lstLdpPeerResult.add((Object)peerInfo);
            }
        }
    }

    protected Integer getAsnBestEffort(QAsnSetMplsReq req) {
        return null;
    }

    protected byte[] getAsnTaskFlag(QAsnSetMplsReq req) {
        return null;
    }

    protected Collection<QAsnMplsInfo> getDecodeAsns(QAsnSetMplsReq req) {
        return req.lstMplsInfo;
    }

    protected void setEncodeAsns(Collection<QAsnSetMplsInfo> encodeAsns, QAsnSetMplsRsp rsp, IAsnTranslationContext context) {
        rsp.lstSetMplsInfo.addAll(encodeAsns);
    }
}

