/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.vmf.adapter.mpls.task;

import com.huawei.commextend.taskmgr.Task;
import com.huawei.network.qasn.m_q_common.QAsnErrInfo;
import com.huawei.network.qasn.m_q_common.QAsnErrInfoReturn;
import com.huawei.network.qasn.m_q_common.QAsnUniResID;
import com.huawei.network.qasn.m_q_ip_tunnel_model.QAsnTunnelKeyResult;
import com.huawei.network.qasn.m_q_ip_tunnel_op.QAsnRsvpTunnelForceSwitchingReq;
import com.huawei.network.qasn.m_q_ip_tunnel_op.QAsnRsvpTunnelForceSwitchingRsp;
import com.huawei.vmf.adapter.common.exception.ErrorInfo;
import com.huawei.vmf.adapter.common.exception.VMFException;
import com.huawei.vmf.adapter.common.fdn.TunnelUniResIDParser;
import com.huawei.vmf.adapter.framework.task.AbstractQTask;
import com.huawei.vmf.adapter.framework.translation.asn.AsnTranslatorUtil;
import com.huawei.vmf.adapter.fservice.model.VmfMO;
import com.huawei.vmf.adapter.fservice.mpls.model.act.RsvpTeHotStandbySwitch;
import com.huawei.vmf.adapter.mpls.dao.MplsDevDao;
import java.util.ArrayList;
import java.util.Map;

public class RsvpTunnelForceSwitchTask
extends AbstractQTask<QAsnRsvpTunnelForceSwitchingReq, QAsnRsvpTunnelForceSwitchingRsp> {
    protected void executeTask(QAsnRsvpTunnelForceSwitchingReq req, QAsnRsvpTunnelForceSwitchingRsp rsp, Task task) {
        ArrayList<RsvpTeHotStandbySwitch> mos = new ArrayList<RsvpTeHotStandbySwitch>();
        TunnelUniResIDParser tunnelParser = new TunnelUniResIDParser();
        for (int i = 0; i < req.lstTunnelKey.size(); ++i) {
            QAsnUniResID resID = (QAsnUniResID)req.lstTunnelKey.get(i);
            tunnelParser.deserialize(new String(resID.strFDN));
            RsvpTeHotStandbySwitch hsbSwitch = new RsvpTeHotStandbySwitch();
            hsbSwitch.setTunnelName(tunnelParser.getTunnelName());
            hsbSwitch.setDevID(Integer.valueOf(tunnelParser.getDevID()));
            hsbSwitch.setSwitchMode(Integer.valueOf(req.iAction));
            mos.add(hsbSwitch);
        }
        rsp.oResult.result = 0;
        Map<VmfMO, ErrorInfo> errorInfo = null;
        try {
            errorInfo = MplsDevDao.newInstance().executeHsbSwitchAction(mos);
        }
        catch (VMFException e) {
            this.getLogger().error("SwitchStatusTask executeSwitchStatusAction failed!", (Throwable)e);
            AsnTranslatorUtil.addRspResultError((QAsnErrInfoReturn)rsp.oResult, (VMFException)e);
            return;
        }
        for (RsvpTeHotStandbySwitch mo : mos) {
            QAsnTunnelKeyResult asn = new QAsnTunnelKeyResult();
            asn.result = new QAsnErrInfo();
            if (errorInfo != null && !errorInfo.isEmpty()) {
                ErrorInfo error = errorInfo.get(mo);
                asn.result.errCode = error.getErrorCode();
                asn.result.strOperDesc = error.getErrorMessage().getBytes();
                rsp.oResult.result = error.getErrorCode();
            } else {
                asn.result = new QAsnErrInfo();
                asn.result.errCode = 0;
            }
            asn.oTunnelKey.neID = mo.getDevID();
            asn.oTunnelKey.poSerialNum = null == mo.getSerialNum() ? null : mo.getSerialNum().getBytes();
            asn.oTunnelKey.strFDN = tunnelParser.serialize().getBytes();
            asn.oTunnelKey.strMOC = tunnelParser.getMOType().getBytes();
            rsp.lstFail.add((Object)asn);
        }
    }
}

