/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.vmf.adapter.mpls.task;

import com.huawei.commextend.taskmgr.Task;
import com.huawei.network.qasn.m_q_common.QAsnErrInfoReturn;
import com.huawei.network.qasn.m_q_common.QAsnUniResID;
import com.huawei.network.qasn.m_q_ip_spring_op.QAsnRefleshSPRingSwitchStatusReq;
import com.huawei.network.qasn.m_q_ip_spring_op.QAsnRefleshSPRingSwitchStatusRsp;
import com.huawei.vmf.adapter.common.exception.VMFException;
import com.huawei.vmf.adapter.framework.task.AbstractQTask;
import com.huawei.vmf.adapter.framework.transaction.Context;
import com.huawei.vmf.adapter.framework.translation.asn.AsnTranslationContext;
import com.huawei.vmf.adapter.framework.translation.asn.AsnTranslatorUtil;
import com.huawei.vmf.adapter.framework.translation.asn.IAsnTranslationContext;
import com.huawei.vmf.adapter.fservice.mpls.fdn.MplsRingFdnParser;
import com.huawei.vmf.adapter.fservice.mpls.model.MplsRing;
import com.huawei.vmf.adapter.mpls.dao.MplsDao;
import com.huawei.vmf.adapter.mpls.dao.MplsDevDao;
import com.huawei.vmf.adapter.mpls.translation.asn.QAsnSPRingSwitchStatusTranslator;
import java.util.ArrayList;
import java.util.Collection;

public class RefleshSPRingSwitchStatusTask
extends AbstractQTask<QAsnRefleshSPRingSwitchStatusReq, QAsnRefleshSPRingSwitchStatusRsp> {
    protected void executeTask(QAsnRefleshSPRingSwitchStatusReq req, QAsnRefleshSPRingSwitchStatusRsp rsp, Task task) {
        MplsRingFdnParser fdnParser = new MplsRingFdnParser();
        ArrayList<MplsRing> mos = new ArrayList<MplsRing>();
        for (Object resId : req.ringKeyList) {
            MplsRing mo = (MplsRing)fdnParser.getIndexMo((QAsnUniResID)resId);
            mos.add(mo);
        }
        Collection dbRings = null;
        Context ctx = new Context();
        try {
            dbRings = MplsDao.newInstance().queryByKey(MplsRing.class, mos, false);
            MplsDevDao.newInstance().syncMplsRingSwitchStatus(dbRings, ctx);
        }
        catch (VMFException e) {
            this.getLogger().error("RefleshSPRingSwitchStatusTask query form dev failed!", (Throwable)e);
            AsnTranslatorUtil.addRspResultError((QAsnErrInfoReturn)rsp.oResult, (VMFException)e);
            return;
        }
        QAsnSPRingSwitchStatusTranslator translator = new QAsnSPRingSwitchStatusTranslator();
        AsnTranslationContext context = new AsnTranslationContext();
        context.setTransactionContext(ctx);
        try {
            Collection asns = translator.encode(dbRings, (IAsnTranslationContext)context);
            rsp.switchResultList.addAll(asns);
            rsp.oResult.result = 0;
        }
        catch (VMFException e) {
            this.getLogger().error("RefleshSPRingSwitchStatusTask encode failed!", (Throwable)e);
            AsnTranslatorUtil.addRspResultError((QAsnErrInfoReturn)rsp.oResult, (VMFException)e);
        }
    }
}

