/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.vmf.adapter.mpls.task;

import com.huawei.commextend.taskmgr.Task;
import com.huawei.network.qasn.m_q_common.QAsnUniResID;
import com.huawei.network.qasn.m_q_ip_tnl_vpn.QAsnQueryVpnByTnlKeyReq;
import com.huawei.network.qasn.m_q_ip_tnl_vpn.QAsnQueryVpnByTnlKeyRsp;
import com.huawei.network.qasn.m_q_ip_tnl_vpn.QAsnTunnelSvrRelationInfo;
import com.huawei.vmf.adapter.common.exception.VMFException;
import com.huawei.vmf.adapter.common.utilty.StringUtil;
import com.huawei.vmf.adapter.framework.task.AbstractQTask;
import com.huawei.vmf.adapter.framework.transaction.Context;
import com.huawei.vmf.adapter.framework.translation.asn.AsnTranslationContext;
import com.huawei.vmf.adapter.framework.translation.asn.AsnTranslatorUtil;
import com.huawei.vmf.adapter.framework.translation.asn.IAsnTranslationContext;
import com.huawei.vmf.adapter.fservice.l3vpn.fdn.L3vpnInstanceFdnParser;
import com.huawei.vmf.adapter.fservice.l3vpn.model.L3vpnInstance;
import com.huawei.vmf.adapter.fservice.l3vpn.service.IVrfService;
import com.huawei.vmf.adapter.fservice.model.VmfMO;
import com.huawei.vmf.adapter.fservice.mpls.fdn.RsvpTeTunnelFdnParser;
import com.huawei.vmf.adapter.fservice.mpls.fdn.StaticTunnelFdnParser;
import com.huawei.vmf.adapter.fservice.mpls.model.RsvpTeTunnel;
import com.huawei.vmf.adapter.fservice.mpls.model.StaticTunnel;
import com.huawei.vmf.adapter.fservice.pwe3.fdn.VpwsPwFdnParser;
import com.huawei.vmf.adapter.fservice.pwe3.model.VpwsPw;
import com.huawei.vmf.adapter.fservice.pwe3.model.VpwsSwitchPw;
import com.huawei.vmf.adapter.fservice.pwe3.service.IPwe3Service;
import com.huawei.vmf.adapter.fservice.vpls.fdn.VplsPwFdnParser;
import com.huawei.vmf.adapter.fservice.vpls.model.VplsLdpPw;
import com.huawei.vmf.adapter.fservice.vpls.service.IVplsService;
import com.huawei.vmf.adapter.mpls.Activator;
import com.huawei.vmf.adapter.mpls.dao.MplsDao;
import com.huawei.vmf.adapter.mpls.dao.MplsDevDao;
import com.huawei.vmf.adapter.mpls.translation.asn.spec.QAsnTunnelSvrRelationInfoTeTranslator;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.springframework.util.CollectionUtils;

public class QueryVpnByTnlKeyTask
extends AbstractQTask<QAsnQueryVpnByTnlKeyReq, QAsnQueryVpnByTnlKeyRsp> {
    protected void executeTask(QAsnQueryVpnByTnlKeyReq req, QAsnQueryVpnByTnlKeyRsp rsp, Task task) {
        ArrayList<VmfMO> teTunnels = new ArrayList<VmfMO>();
        ArrayList<VmfMO> staticTunnels = new ArrayList<VmfMO>();
        RsvpTeTunnelFdnParser teFdnParser = new RsvpTeTunnelFdnParser();
        StaticTunnelFdnParser staticFdnParser = new StaticTunnelFdnParser();
        for (Object obj : req.lstTnlKey) {
            QAsnUniResID resId = (QAsnUniResID)obj;
            if ("TUNNEL".equals(StringUtil.globalString((byte[])resId.strMOC))) {
                teTunnels.add(teFdnParser.getIndexMo(resId));
            }
            if (!"TUNNEL".equals(StringUtil.globalString((byte[])resId.strMOC))) continue;
            staticTunnels.add(staticFdnParser.getIndexMo(resId));
        }
        Collection dbTeTunnels = null;
        Collection StaticDbTunnels = null;
        try {
            Iterator iter;
            dbTeTunnels = MplsDao.newInstance().queryByKey(RsvpTeTunnel.class, teTunnels, false);
            if (!CollectionUtils.isEmpty((Collection)dbTeTunnels)) {
                iter = dbTeTunnels.iterator();
                while (iter.hasNext()) {
                    if (((RsvpTeTunnel)iter.next()).isDeployed()) continue;
                    iter.remove();
                }
                MplsDevDao.newInstance().loadTunnelVPN(dbTeTunnels, req.iSvrType);
            } else {
                StaticDbTunnels = MplsDao.newInstance().queryByKey(StaticTunnel.class, staticTunnels, false);
                if (!CollectionUtils.isEmpty((Collection)StaticDbTunnels)) {
                    iter = StaticDbTunnels.iterator();
                    while (iter.hasNext()) {
                        StaticTunnel staticTunnel = (StaticTunnel)iter.next();
                        if (staticTunnel.isDeployed()) continue;
                        iter.remove();
                    }
                    rsp.oResult.result = 0;
                    rsp = this.queryVplsByTunnel(StaticDbTunnels, rsp);
                    rsp = this.queryVrfByTunnel(StaticDbTunnels, rsp);
                    rsp = this.queryPwe3ByTunnel(StaticDbTunnels, rsp);
                    return;
                }
            }
        }
        catch (VMFException e) {
            this.getLogger().error("QueryVpnByTnlKeyTask loadTunnelVPN failed!", (Throwable)e);
            rsp.oResult.result = 1107499878;
            return;
        }
        AsnTranslationContext context = new AsnTranslationContext();
        context.setTransactionContext(new Context());
        List<RsvpTeTunnel> teResultList = this.splitRelation(dbTeTunnels);
        QAsnTunnelSvrRelationInfoTeTranslator teTranslator = new QAsnTunnelSvrRelationInfoTeTranslator();
        try {
            rsp.oResult.result = 0;
            Collection asns = teTranslator.encode(teResultList, (IAsnTranslationContext)context);
            rsp.lstServiceKey.addAll(asns);
        }
        catch (VMFException e) {
            rsp.oResult.result = e.getErrorCode();
            this.getLogger().error("QueryVpnByTnlKeyTask QAsnTunnelSvrRelationInfoTeTranslator encode failed!", (Throwable)e);
        }
    }

    private QAsnQueryVpnByTnlKeyRsp queryVplsByTunnel(Collection<StaticTunnel> staticTunnels, QAsnQueryVpnByTnlKeyRsp rsp) {
        IVplsService vplsService = Activator.getService(IVplsService.class);
        Map vpnMap = vplsService.getVpnByTunnelKey(staticTunnels);
        StaticTunnelFdnParser staticTunnelFdnParser = new StaticTunnelFdnParser();
        VplsPwFdnParser vplsPwParser = new VplsPwFdnParser();
        if (!CollectionUtils.isEmpty((Map)vpnMap)) {
            for (StaticTunnel staticTunnel : staticTunnels) {
                Collection vplsMo = (Collection)vpnMap.get(staticTunnel);
                if (CollectionUtils.isEmpty((Collection)vplsMo)) continue;
                for (VmfMO vplsLdpPw : vplsMo) {
                    QAsnTunnelSvrRelationInfo tunelRelation = new QAsnTunnelSvrRelationInfo();
                    if (vplsLdpPw instanceof VplsLdpPw) {
                        tunelRelation.oTunnelKey = staticTunnelFdnParser.getUniResID((VmfMO)staticTunnel);
                        tunelRelation.serviceKey = vplsPwParser.getUniResID((VmfMO)((VplsLdpPw)vplsLdpPw));
                    }
                    rsp.lstServiceKey.add((Object)tunelRelation);
                }
            }
        }
        return rsp;
    }

    private QAsnQueryVpnByTnlKeyRsp queryVrfByTunnel(Collection<StaticTunnel> staticTunnels, QAsnQueryVpnByTnlKeyRsp rsp) {
        IVrfService vrfService = Activator.getService(IVrfService.class);
        Map vpnMap = vrfService.getVpnByTunnelKey(staticTunnels);
        StaticTunnelFdnParser staticTunnelFdnParser = new StaticTunnelFdnParser();
        L3vpnInstanceFdnParser vrfParser = new L3vpnInstanceFdnParser();
        if (!CollectionUtils.isEmpty((Map)vpnMap)) {
            for (StaticTunnel staticTunnel : staticTunnels) {
                Collection vrfMo = (Collection)vpnMap.get(staticTunnel);
                if (CollectionUtils.isEmpty((Collection)vrfMo)) continue;
                for (VmfMO vplsInstance : vrfMo) {
                    QAsnTunnelSvrRelationInfo tunelRelation = new QAsnTunnelSvrRelationInfo();
                    if (vplsInstance instanceof L3vpnInstance) {
                        tunelRelation.oTunnelKey = staticTunnelFdnParser.getUniResID((VmfMO)staticTunnel);
                        tunelRelation.serviceKey = vrfParser.getUniResID((VmfMO)((L3vpnInstance)vplsInstance));
                    }
                    rsp.lstServiceKey.add((Object)tunelRelation);
                }
            }
        }
        return rsp;
    }

    private QAsnQueryVpnByTnlKeyRsp queryPwe3ByTunnel(Collection<StaticTunnel> staticTunnels, QAsnQueryVpnByTnlKeyRsp rsp) {
        IPwe3Service pwe3Service = Activator.getService(IPwe3Service.class);
        Map vpnMap = pwe3Service.getVpnByTunnelKey(staticTunnels);
        StaticTunnelFdnParser staticTunnelFdnParser = new StaticTunnelFdnParser();
        VpwsPwFdnParser pwe3Parser = new VpwsPwFdnParser();
        if (!CollectionUtils.isEmpty((Map)vpnMap)) {
            for (StaticTunnel staticTunnel : staticTunnels) {
                Collection pwe3Mo = (Collection)vpnMap.get(staticTunnel);
                if (CollectionUtils.isEmpty((Collection)pwe3Mo)) continue;
                for (VmfMO pw : pwe3Mo) {
                    QAsnTunnelSvrRelationInfo tunelRelation = new QAsnTunnelSvrRelationInfo();
                    if (pw instanceof VpwsPw) {
                        tunelRelation.oTunnelKey = staticTunnelFdnParser.getUniResID((VmfMO)staticTunnel);
                        tunelRelation.serviceKey = pwe3Parser.getUniResID((VmfMO)((VpwsPw)pw));
                    }
                    rsp.lstServiceKey.add((Object)tunelRelation);
                }
            }
        }
        return rsp;
    }

    private RsvpTeTunnel copyTunnel(RsvpTeTunnel tunnel) {
        RsvpTeTunnel newTunnel = new RsvpTeTunnel();
        AsnTranslatorUtil.copyDevAndVrId((VmfMO)tunnel, (VmfMO)newTunnel);
        newTunnel.setTunnelName(tunnel.getTunnelName());
        return newTunnel;
    }

    private List<RsvpTeTunnel> splitRelation(Collection<RsvpTeTunnel> tunnels) {
        ArrayList<RsvpTeTunnel> resultList = new ArrayList<RsvpTeTunnel>();
        for (RsvpTeTunnel tunnel : tunnels) {
            List vsiPws;
            List switchLdpPws;
            List ldpPws;
            List l3vpnInstances = tunnel.getKeyRefMos(L3vpnInstance.class);
            if (!CollectionUtils.isEmpty((Collection)l3vpnInstances)) {
                for (L3vpnInstance mo : l3vpnInstances) {
                    RsvpTeTunnel newTunnel = this.copyTunnel(tunnel);
                    newTunnel.addKeyRefMo((VmfMO)mo);
                    resultList.add(newTunnel);
                }
            }
            if (!CollectionUtils.isEmpty((Collection)(ldpPws = tunnel.getKeyRefMos(VpwsPw.class)))) {
                for (VpwsPw mo : ldpPws) {
                    RsvpTeTunnel newTunnel = this.copyTunnel(tunnel);
                    newTunnel.addKeyRefMo((VmfMO)mo);
                    resultList.add(newTunnel);
                }
            }
            if (!CollectionUtils.isEmpty((Collection)(switchLdpPws = tunnel.getKeyRefMos(VpwsSwitchPw.class)))) {
                for (VpwsSwitchPw mo : switchLdpPws) {
                    RsvpTeTunnel newTunnel = this.copyTunnel(tunnel);
                    newTunnel.addKeyRefMo((VmfMO)mo);
                    resultList.add(newTunnel);
                }
            }
            if (CollectionUtils.isEmpty((Collection)(vsiPws = tunnel.getKeyRefMos(VplsLdpPw.class)))) continue;
            for (VplsLdpPw mo : vsiPws) {
                RsvpTeTunnel newTunnel = this.copyTunnel(tunnel);
                newTunnel.addKeyRefMo((VmfMO)mo);
                resultList.add(newTunnel);
            }
        }
        return resultList;
    }
}

